<html><head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <title>workerman-chat PHP聊天室 Websocket(HTLM5/Flash)+PHP多進程socket實時推送技術</title>
  <script type="text/javascript">
  //WebSocket = null;
  </script>
  <link href="/css/bootstrap.min.css" rel="stylesheet">
  <link href="/css/style.css" rel="stylesheet">
  <!-- Include these three JS files: -->
  <script type="text/javascript" src="/js/swfobject.js"></script>
  <script type="text/javascript" src="/js/web_socket.js"></script>
  <script type="text/javascript" src="/js/json.js"></script>
  <script type="text/javascript" src="/js/jquery.min.js"></script>

  <script type="text/javascript">
    if (typeof console == "undefined") {    this.console = { log: function (msg) {  } };}
    WEB_SOCKET_SWF_LOCATION = "/swf/WebSocketMain.swf";
    WEB_SOCKET_DEBUG = true;
    var ws, name, client_list={},timeid, reconnect=false;
    function init() {
       // 創建websocket
    	ws = new WebSocket("ws://"+document.domain+":7272");
      // 當socket連接打開時，輸入用戶名
      ws.onopen = function() {
    	  timeid && window.clearInterval(timeid);
    	  if(!name)
    	  {
  		    show_prompt();
    	  }
    	  if(!name) {
    		  return ws.close();
   		  }
    	  if(reconnect == false)
    	  {
        	  // 登錄
    		  var login_data = JSON.stringify({"type":"login","client_name":name,"room_id":<?php echo isset($_GET['room_id']) ? $_GET['room_id'] : 1?>});
    		  console.log("websocket握手成功，發送登錄數據:"+login_data);
  		      ws.send(login_data);
    		  reconnect = true;
    	  }
    	  else
    	  {
        	  // 斷線重連
        	  var relogin_data = JSON.stringify({"type":"re_login","client_name":name,"room_id":<?php echo isset($_GET['room_id']) ? $_GET['room_id'] : 1?>});
    		  console.log("websocket握手成功，發送重連數據:"+relogin_data);
    		  ws.send(relogin_data);
    	  }
      };
      // 當有消息時根據消息類型顯示不同信息
      ws.onmessage = function(e) {
    	console.log(e.data);
        var data = JSON.parse(e.data);
        switch(data['type']){
              // 服務端ping客戶端
              case 'ping':
            	ws.send(JSON.stringify({"type":"pong"}));
                break;;
              // 登錄 更新用戶列表
              case 'login':
                  //{"type":"login","client_id":xxx,"client_name":"xxx","client_list":"[...]","time":"xxx"}
                  say(data['client_id'], data['client_name'],  data['client_name']+' 加入了聊天室', data['time']);
                  flush_client_list(data['client_list']);
                  console.log(data['client_name']+"登錄成功");
                  break;
              // 斷線重連，只更新用戶列表
              case 're_login':
              	  //{"type":"re_login","client_id":xxx,"client_name":"xxx","client_list":"[...]","time":"xxx"}
            	  flush_client_list(data['client_list']);
            	  console.log(data['client_name']+"重連成功");
                  break;
              // 發言
              case 'say':
            	  //{"type":"say","from_client_id":xxx,"to_client_id":"all/client_id","content":"xxx","time":"xxx"}
            	  say(data['from_client_id'], data['from_client_name'], data['content'], data['time']);
            	  break;
             // 用戶退出 更新用戶列表
              case 'logout':
            	  //{"type":"logout","client_id":xxx,"time":"xxx"}
            	  say(data['from_client_id'], data['from_client_name'], data['from_client_name']+' 退出了', data['time']);
          		 flush_client_list(data['client_list']);
        }
      };
      ws.onclose = function() {
    	  console.log("連接關閉，定時重連");
    	  // 定時重連
    	  window.clearInterval(timeid);
    	  timeid = window.setInterval(init, 3000);
      };
      ws.onerror = function() {
    	  console.log("出現錯誤");
      };
    }

    // 輸入姓名
    function show_prompt(){  
        name = prompt('輸入你的名字：', '');
        if(!name || name=='null'){  
            alert("輸入名字為空或者為'null'，請重新輸入！");  
            show_prompt();
        }
    }  

    // 提交對話
    function onSubmit() {
      var input = document.getElementById("textarea");
      var to_client_id = $("#client_list option:selected").attr("value");
      var to_client_name = $("#client_list option:selected").text();
      ws.send(JSON.stringify({"type":"say","to_client_id":to_client_id,"to_client_name":to_client_name,"content":input.value}));
      input.value = "";
      input.focus();
    }

    // 刷新用戶列表框
    function flush_client_list(client_list){
    	var userlist_window = $("#userlist");
    	var client_list_slelect = $("#client_list");
    	userlist_window.empty();
    	client_list_slelect.empty();
    	userlist_window.append('<h4>在線用戶</h4><ul>');
    	client_list_slelect.append('<option value="all" id="cli_all">所有人</option>');
    	for(var p in client_list){
    		userlist_window.append('<li id="'+client_list[p]['client_id']+'">'+client_list[p]['client_name']+'</li>');
    		client_list_slelect.append('<option value="'+client_list[p]['client_id']+'">'+client_list[p]['client_name']+'</option>');
        }
    	$("#client_list").val(select_client_id);
    	userlist_window.append('</ul>');
    }

    // 發言
    function say(from_client_id, from_client_name, content, time){
    	$("#dialog").append('<div class="speech_item"><img src="http://lorempixel.com/38/38/?'+from_client_id+'" class="user_icon" /> '+from_client_name+' <br> '+time+'<div style="clear:both;"></div><p class="triangle-isosceles top">'+content+'</p> </div>');
    }

    $(function(){
    	select_client_id = 'all';
	    $("#client_list").change(function(){
	         select_client_id = $("#client_list option:selected").attr("value");
	    });
    });
  </script>
</head>
<body onload="init();">
    <div class="container">
	    <div class="row clearfix">
	        <div class="col-md-1 column">
	        </div>
	        <div class="col-md-6 column">
	           <div class="thumbnail">
	               <div class="caption" id="dialog"></div>
	           </div>
	           <form onsubmit="onSubmit(); return false;">
	                <select style="margin-bottom:8px" id="client_list">
                        <option value="all">所有人</option>
                    </select>
                    <textarea class="textarea thumbnail" id="textarea"></textarea>
                    <div class="say-btn"><input type="submit" class="btn btn-default" value="發表" /></div>
               </form>
               <div>
               &nbsp;&nbsp;&nbsp;&nbsp;<b>房間列表:</b>（當前在&nbsp;房間<?php echo isset($_GET['room_id'])&&intval($_GET['room_id'])>0 ? intval($_GET['room_id']):1; ?>）<br>
               &nbsp;&nbsp;&nbsp;&nbsp;<a href="/?room_id=1">房間1</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/?room_id=2">房間2</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/?room_id=3">房間3</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/?room_id=4">房間4</a>
               <br><br>
               </div>
               <p class="cp">PHP多進程+Websocket(HTML5/Flash)+PHP Socket實時推送技術&nbsp;&nbsp;&nbsp;&nbsp;Powered by <a href="http://www.workerman.net/workerman-chat" target="_blank">workerman-chat</a></p>
	        </div>
	        <div class="col-md-3 column">
	           <div class="thumbnail">
                   <div class="caption" id="userlist"></div>
               </div>
               <a href="http://workerman.net:8383" target="_blank"><img style="width:252px;margin-left:5px;" src="/img/workerman-todpole.png"></a>
	        </div>
	    </div>
    </div>
</body>
</html>
