<?php 
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
use \Workerman\Worker;
use \Workerman\WebServer;
use \GatewayWorker\Gateway;
use \GatewayWorker\BusinessWorker;
use \Workerman\Autoloader;

// 自動加載類
require_once __DIR__ . '/../../Workerman/Autoloader.php';
Autoloader::setRootPath(__DIR__);

// gateway 進程
$gateway = new Gateway("Text://0.0.0.0:7273");
// 設置名稱，方便status時查看
$gateway->name = 'internalGateway';
// 設置進程數，gateway進程數建議與cpu核數相同
$gateway->count = 4;
// 分佈式部署時請設置成內網ip（非127.0.0.1）
$gateway->lanIp = '127.0.0.1';
// 內部通訊起始端口，假如$gateway->count=4，起始端口為4000
// 則一般會使用4001 4002 4003 4004 4個端口作為內部通訊端口 
$gateway->startPort = 2800;
// 心跳間隔
$gateway->pingInterval = 10;
// 心跳數據
$gateway->pingData = '{"type":"ping"}';


/* 
// 當客戶端連接上來時，設置連接的onWebSocketConnect，即在websocket握手時的回調
$gateway->onConnect = function($connection)
{
    $connection->onWebSocketConnect = function($connection , $http_header)
    {
        // 可以在這裡判斷連接來源是否合法，不合法就關掉連接
        // $_SERVER['HTTP_ORIGIN']標識來自哪個站點的頁面發起的websocket鏈接
        if($_SERVER['HTTP_ORIGIN'] != 'http://chat.workerman.net')
        {
            $connection->close();
        }
        // onWebSocketConnect 裡面$_GET $_SERVER是可用的
        // var_dump($_GET, $_SERVER);
    };
}; 
*/

// 如果不是在根目錄啟動，則運行runAll方法
if(!defined('GLOBAL_START'))
{
    Worker::runAll();
}

