<?php
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace GatewayWorker\Lib;

/**
 * 上下文 包含當前用戶uid， 內部通信local_ip local_port socket_id ，以及客戶端client_ip client_port
 */
class Context
{
    /**
     * 內部通訊id
     * @var string
     */
    public static $local_ip;
    /**
     * 內部通訊端口
     * @var int
     */
    public static $local_port;
    /**
     * 客戶端ip
     * @var string
     */
    public static $client_ip;
    /**
     * 客戶端端口
     * @var int
     */
    public static $client_port;
    /**
     * 用戶id
     * @var int
     */
    public static $client_id;
    
    /**
     * 編碼session
     * @param mixed $session_data
     * @return string
     */
    public static function sessionEncode($session_data = '')
    {
        if($session_data !== '')
        {
            return serialize($session_data);
        }
        return '';
    }
    
    /**
     * 解碼session
     * @param string $session_buffer
     * @return mixed
     */
    public static function sessionDecode($session_buffer)
    {
        return unserialize($session_buffer);
    }
    
    /**
     * 清除上下文
     * @return void
     */
    public static function clear()
    {
        self::$local_ip = self::$local_port  = self::$client_ip = self::$client_port = self::$client_id  = null;
    }
}
