<?php
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace Workerman;

// 包含常量定義文件
require_once __DIR__.'/Lib/Constants.php';

/**
 * 自動加載類
 * @author walkor<walkor@workerman.net>
 */
class Autoloader
{
    // 應用的初始化目錄，作為加載類文件的參考目錄
    protected static $_appInitPath = '';
    
    /**
     * 設置應用初始化目錄
     * @param string $root_path
     * @return void
     */
    public static function setRootPath($root_path)
    {
          self::$_appInitPath = $root_path;
    }

    /**
     * 根據命名空間加載文件
     * @param string $name
     * @return boolean
     */
    public static function loadByNamespace($name)
    {
        // 相對路徑
        $class_path = str_replace('\\', DIRECTORY_SEPARATOR ,$name);
        // 如果是Workerman命名空間，則在當前目錄尋找類文件
        if(strpos($name, 'Workerman\\') === 0)
        {
            $class_file = __DIR__.substr($class_path, strlen('Workerman')).'.php';
        }
        else 
        {
            // 先嘗試在應用目錄尋找文件
            if(self::$_appInitPath)
            {
                $class_file = self::$_appInitPath . DIRECTORY_SEPARATOR . $class_path.'.php';
            }
            // 文件不存在，則在上一層目錄尋找
            if(empty($class_file) || !is_file($class_file))
            {
                $class_file = __DIR__.DIRECTORY_SEPARATOR.'..'.DIRECTORY_SEPARATOR . "$class_path.php";
            }
        }
       
        // 找到文件
        if(is_file($class_file))
        {
            // 加載
            require_once($class_file);
            if(class_exists($name, false))
            {
                return true;
            }
        }
        return false;
    }
}
// 設置類自動加載回調函數
spl_autoload_register('\Workerman\Autoloader::loadByNamespace');