<?php
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace Workerman\Connection;

use Workerman\Events\Libevent;
use Workerman\Events\Select;
use Workerman\Events\EventInterface;
use Workerman\Worker;
use \Exception;

/**
 * connection類的接口 
 */
abstract class  ConnectionInterface
{
    /**
     * status命令的統計數據
     * @var array
     */
    public static $statistics = array(
        'connection_count'=>0,
        'total_request'   => 0, 
        'throw_exception' => 0,
        'send_fail'       => 0,
    );
    
    /**
     * 當收到數據時，如果有設置$onMessage回調，則執行
     * @var callback
     */
    public $onMessage = null;
    
    /**
     * 當連接關閉時，如果設置了$onClose回調，則執行
     * @var callback
     */
    public $onClose = null;
    
    /**
     * 當出現錯誤時，如果設置了$onError回調，則執行
     * @var callback
     */
    public $onError = null;
    
    /**
     * 發送數據給對端
     * @param string $send_buffer
     * @return void|boolean
     */
    abstract public function send($send_buffer);
    
    /**
     * 獲得遠端ip
     * @return string
     */
    abstract public function getRemoteIp();
    
    /**
     * 獲得遠端端口
     * @return int
     */
    abstract public function getRemotePort();

    /**
     * 關閉連接，為了保持接口一致，udp保留了此方法，當是udp時調用此方法無任何作用
     * @void
     */
    abstract public function close($data = null);
}
