<?php 
/**
 * This file is part of workerman.
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the MIT-LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @author walkor<walkor@workerman.net>
 * @copyright walkor<walkor@workerman.net>
 * @link http://www.workerman.net/
 * @license http://www.opensource.org/licenses/mit-license.php MIT License
 */
namespace Workerman\Protocols;
use \Workerman\Connection\TcpConnection;

/**
 * Text協議
 * 以換行為請求結束標記
 * @author walkor <walkor@workerman.net>
 */
class Text
{
    /**
     * 檢查包的完整性
     * 如果能夠得到包長，則返回包的長度，否則返回0繼續等待數據
     * @param string $buffer
     */
    public static function input($buffer ,TcpConnection $connection)
    {
        // 由於沒有包頭，無法預先知道包長，不能無限制的接收數據，
        // 所以需要判斷當前接收的數據是否超過限定值
        if(strlen($buffer)>=TcpConnection::$maxPackageSize)
        {
            $connection->close();
            return 0;
        }
        // 獲得換行字符"\n"位置
        $pos = strpos($buffer, "\n");
        // 沒有換行符，無法得知包長，返回0繼續等待數據
        if($pos === false)
        {
            return 0;
        }
        // 有換行符，返回當前包長，包含換行符
        return $pos+1;
    }
    
    /**
     * 打包，當向客戶端發送數據的時候會自動調用
     * @param string $buffer
     * @return string
     */
    public static function encode($buffer)
    {
        // 加上換行
        return $buffer."\n";
    }
    
    /**
     * 解包，當接收到的數據字節數等於input返回的值（大於0的值）自動調用
     * 並傳遞給onMessage回調函數的$data參數
     * @param string $buffer
     * @return string
     */
    public static function decode($buffer)
    {
        // 去掉換行
        return trim($buffer);
    }
}
