<?php
/**
 * KindEditor PHP
 * 
 * 本PHP程序是演示程序，建議不要直接在實際項目中使用。
 * 如果您確定直接使用本程序，使用之前請仔細確認相關安全設置。
 * 
 */

require_once 'JSON.php';
 
$php_path = dirname(__FILE__) . '/';
$php_url = dirname($_SERVER['PHP_SELF']) . '/';

//根目錄路徑，可以指定絕對路徑，比如 /var/www/attached/
$root_path = $php_path . '../attached/';
//根目錄URL，可以指定絕對路徑，比如 http://www.yoursite.com/attached/
$root_url = $php_url . '../attached/';
//圖片擴展名
$ext_arr = array('gif', 'jpg', 'jpeg', 'png', 'bmp');

//根據path參數，設置各路徑和URL
if (empty($_GET['path'])) {
	$current_path = realpath($root_path) . '/';
	$current_url = $root_url;
	$current_dir_path = '';
	$moveup_dir_path = '';
} else {
	$current_path = realpath($root_path) . '/' . $_GET['path'];
	$current_url = $root_url . $_GET['path'];
	$current_dir_path = $_GET['path'];
	$moveup_dir_path = preg_replace('/(.*?)[^\/]+\/$/', '$1', $current_dir_path);
}
//排序形式，name or size or type
$order = empty($_GET['order']) ? 'name' : strtolower($_GET['order']);

//不允許使用..移動到上一級目錄
if (preg_match('/\.\./', $current_path)) {
	echo 'Access is not allowed.';
	exit;
}
//最後一個字符不是/
if (!preg_match('/\/$/', $current_path)) {
	echo 'Parameter is not valid.';
	exit;
}
//目錄不存在或不是目錄
if (!file_exists($current_path) || !is_dir($current_path)) {
	echo 'Directory does not exist.';
	exit;
}

//遍歷目錄取得文件信息
$file_list = array();
if ($handle = opendir($current_path)) {
	$i = 0;
	while (false !== ($filename = readdir($handle))) {
		if ($filename{0} == '.') continue;
		$file = $current_path . $filename;
		if (is_dir($file)) {
			$file_list[$i]['is_dir'] = true; //是否文件夾
			$file_list[$i]['has_file'] = (count(scandir($file)) > 2); //文件夾是否包含文件
			$file_list[$i]['filesize'] = 0; //文件大小
			$file_list[$i]['is_photo'] = false; //是否圖片
			$file_list[$i]['filetype'] = ''; //文件類別，用擴展名判斷
		} else {
			$file_list[$i]['is_dir'] = false;
			$file_list[$i]['has_file'] = false;
			$file_list[$i]['filesize'] = filesize($file);
			$file_list[$i]['dir_path'] = '';
			$file_ext = strtolower(array_pop(explode('.', trim($file))));
			$file_list[$i]['is_photo'] = in_array($file_ext, $ext_arr);
			$file_list[$i]['filetype'] = $file_ext;
		}
		$file_list[$i]['filename'] = $filename; //文件名，包含擴展名
		$file_list[$i]['datetime'] = date('Y-m-d H:i:s', filemtime($file)); //文件最後修改時間
		$i++;
	}
	closedir($handle);
}

//排序
function cmp_func($a, $b) {
	global $order;
	if ($a['is_dir'] && !$b['is_dir']) {
		return -1;
	} else if (!$a['is_dir'] && $b['is_dir']) {
		return 1;
	} else {
		if ($order == 'size') {
			if ($a['filesize'] > $b['filesize']) {
				return 1;
			} else if ($a['filesize'] < $b['filesize']) {
				return -1;
			} else {
				return 0;
			}
		} else if ($order == 'type') {
			return strcmp($a['filetype'], $b['filetype']);
		} else {
			return strcmp($a['filename'], $b['filename']);
		}
	}
}
usort($file_list, 'cmp_func');

$result = array();
//相對於根目錄的上一級目錄
$result['moveup_dir_path'] = $moveup_dir_path;
//相對於根目錄的當前目錄
$result['current_dir_path'] = $current_dir_path;
//當前目錄的URL
$result['current_url'] = $current_url;
//文件數
$result['total_count'] = count($file_list);
//文件列表數組
$result['file_list'] = $file_list;

//輸出JSON字符串
header('Content-type: application/json; charset=UTF-8');
$json = new Services_JSON();
echo $json->encode($result);
?>
