<?php
/**
 * KindEditor PHP
 * 
 * 本PHP程序是演示程序，建議不要直接在實際項目中使用。
 * 如果您確定直接使用本程序，使用之前請仔細確認相關安全設置。
 * 
 */

require_once 'JSON.php';

//文件保存目錄路徑
$save_path = '../attached/';
//文件保存目錄URL
$save_url = 'eweb/attached/';
//定義允許上傳的文件擴展名
$ext_arr = array('gif', 'jpg', 'jpeg', 'png', 'bmp');
//最大文件大小
$max_size = 1000000;

//有上傳文件時
if (empty($_FILES) === false) {
	//原文件名
	$file_name = $_FILES['imgFile']['name'];
	//服務器上臨時文件名
	$tmp_name = $_FILES['imgFile']['tmp_name'];
	//文件大小
	$file_size = $_FILES['imgFile']['size'];
	//檢查文件名
	if (!$file_name) {
		alert("請選擇文件。");
	}
	//檢查目錄
	if (@is_dir($save_path) === false) {
		alert("上傳目錄不存在。");
	}
	//檢查目錄寫權限
	if (@is_writable($save_path) === false) {
		alert("上傳目錄沒有寫權限。");
	}
	//檢查是否已上傳
	if (@is_uploaded_file($tmp_name) === false) {
		alert("臨時文件可能不是上傳文件。");
	}
	//檢查文件大小
	if ($file_size > $max_size) {
		alert("上傳文件大小超過限制。");
	}
	//獲得文件擴展名
	$temp_arr = explode(".", $file_name);
	$file_ext = array_pop($temp_arr);
	$file_ext = trim($file_ext);
	$file_ext = strtolower($file_ext);
	//檢查擴展名
	if (in_array($file_ext, $ext_arr) === false) {
		alert("上傳文件擴展名是不允許的擴展名。");
	}
	//新文件名
	$new_file_name = date("YmdHis") . '_' . rand(10000, 99999) . '.' . $file_ext;
	//移動文件
	$file_path = $save_path . $new_file_name;
	if (move_uploaded_file($tmp_name, $file_path) === false) {
		alert("上傳文件失敗。");
	}
	@chmod($file_path, 0644);
	$file_url = $save_url . $new_file_name;
	
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 0, 'url' => $file_url));
	exit;
}

function alert($msg) {
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 1, 'message' => $msg));
	exit;
}
?>