<?php

/*
	[Office 515158] (C) 2009-2012 天生創想 Inc.
	$Id: dbbackup.class.php 1209087 2012-01-08 08:58:28Z baiwei.jiang $
*/


	class dbbackup{


		/**
		 * 數據庫主機
		 *
		 * @private string
		 */
			private $db_host;

		/**
		 * 數據庫用戶名
		 *
		 * @private string
		 */
			private $db_user;

		/**
		 * 數據庫密碼
		 *
		 * @private string
		 */
			private $db_pwd;

		/**
		 * 數據庫名
		 *
		 * @private string
		 */
			private $db_database;

		/**
		 * 數據庫編碼,GBK,UTF8,gb2312
		 *
		 * @private string
		 */
			private $coding;

		/**
		 * 數據庫連接標識
		 *
		 * @private string
		 */
			private $conn;

		/**
		 * 文件夾路徑（存放備份數據）
		 *
		 * @private string
		 */
			private $data_dir = 'data/db/';

		/**
		 * 分卷長度（單位KB）
		 *
		 * @private string
		 */
			private $part = 2048;

		/**
		 * 備份文件名
		 *
		 * @private string | array
		 */
			public $bakfn;


		/**
		 * 構造函數
		 *
		 * @access public
		 * @parameter string $db_host 		數據庫主機
		 * @parameter string $db_user 		數據庫用戶名
		 * @parameter string $db_pwd  		數據庫密碼
		 * @parameter string $db_database   數據庫名
		 * @parameter string $coding  		編碼
		 * @return void
		 */
		public function __construct($db_host, $db_user, $db_pwd, $db_database, $coding = 'gb2312'){
			$this->init();
			$this->db_host = $db_host;
			$this->db_user = $db_user;
			$this->db_pwd =  $db_pwd;
			$this->db_database = $db_database;
			$this->coding = $coding;
			$this->connect();
			$this->part = $this->part * 1024; //設置分卷長度,單位為KB
			$this->cre_dir();  				  //創建文件夾
		}

		/**
		 * 初始化程序
		 *
		 * @access private
		 * @return void
		 */
		private function init(){
			set_time_limit(0);					//程序執行不限時
			error_reporting(E_ERROR | E_PARSE); //報錯級別
		}

		/**
		 * 鏈接數據庫
		 *
		 * @access private
		 * @return void
		 */
		private function connect(){
			$this->conn = @mysql_connect($this->db_host,$this->db_user,$this->db_pwd);
			if(!$this->conn){
				echo '<font color="red">錯誤提示：鏈接數據庫失敗！</font>';
				exit();
			}

			if(!@mysql_select_db($this->db_database, $this->conn)){
				echo '<font color="red">錯誤提示：打開數據庫失敗！</font>';
				exit();
			}

			if(!@mysql_query("SET NAMES $this->coding")){
				echo '錯誤提示：設置編碼失敗！';
			}
		}

		/**
		 * 創建文件夾
		 *
		 * @access private
		 * @return void
		 */
		private function cre_dir(){
			//文件夾不存在則創建
			if(!is_dir($this->data_dir)){
				mkdir($this->data_dir, 0777);
			}
		}

		/**
		 * 	獲取數據庫表集合
		 *
		 * @access public
		 * @return Array
		 */
		public function get_tb(){
			//查詢表集合
			$tq = mysql_list_tables($this->db_database);
			while($tr = mysql_fetch_row($tq)){
				$arrtb[] = $tr[0];
			}
			return $arrtb; //返回表集合
		}

		/**
		 * 獲取備份數據
		 *
		 * @access public
		 * @parameter string $db_host	表集合
		 * @return String or Array
		 */
		public function get_backupdata($arrtb){
			$backupdata = ''; //存儲備份數據
			//獲取備份數據
			foreach($arrtb as $tb){
				//獲取表結構
				$query = mysql_query("SHOW CREATE TABLE $tb");
				$row = mysql_fetch_row($query);
				$backupdata .= "DROP TABLE IF EXISTS $tb;\n" . $row[1] . ";\n\n";
				//獲取表數據
				$query = mysql_query("select * from $tb");
				$numfields = mysql_num_fields($query); //統計字段數
				//構造INSERT語句
				while($row = mysql_fetch_row($query)){
					$comma = ""; //存儲逗號
					$backupdata .= "INSERT INTO $tb VALUES (";
					for($i=0; $i<$numfields; $i++){
											  	  //轉義SQL語句中的特殊字符
						$backupdata .= $comma . "'" . mysql_escape_string($row[$i]) . "'";
						$comma = ",";
					}
					$backupdata .= ");\n";
					//備份數據大於 part值 則存入數組,分卷備份
					if(strlen($backupdata) > $this->part){
						$arrbackupdata[] = $backupdata;
						$backupdata = ''; //清空之前的sql
					}
				}
				$backupdata .= "\n"; // \n隔開每張表中的數據
			}
			//+
			//| 提示：
			//| 根據是否需要分卷備份,返回不同值
			//+
			if(is_array($arrbackupdata)){
				//將剩餘數據加入數組
				array_push($arrbackupdata, $backupdata);
				return $arrbackupdata; //返回數組備份數據
			}
			return $backupdata; //返回備份數據
		}

		/**
		 * 將備份數據寫入文件
		 *
		 * @access private
		 * @parameter string $data	數據
		 * @return Boolean
		 */
		private function wri_file($data){
			//數據為數組則分卷備份
			if(is_array($data)){
				$i = 1;
				foreach($data as $val){
					//寫入數據
					$filename = $this->data_dir . $this->db_database . mktime() . "_part{$i}.sql"; //文件名
					if(!$fp = @fopen($filename, "w+")){ echo "在打開文件時遇到錯誤,備份失敗!"; return false;}
					if(!@fwrite($fp, $val)){
						echo "在寫入信息時遇到錯誤,備份失敗!"; fclose($fp); //需關閉文件才能刪除
						unlink($filename); //刪除文件
						return false;}
					$this->bakfn[] = $this->db_database . mktime() . "_part{$i}.sql"; //備份成功則返回文件名數組
					$i++;
				}
			}else{ //單獨備份
				$filename = $this->data_dir . $this->db_database . mktime() . ".sql";
				if(!$fp = @fopen($filename, "w+")){ echo "在打開文件時遇到錯誤,備份失敗!"; return false;}
				if(!@fwrite($fp, $data)){
					echo "在寫入信息時遇到錯誤,備份失敗!"; fclose($fp);
					unlink($filename);
					return false;}
				$this->bakfn = $this->db_database . mktime() . ".sql"; //備份成功則返回文件名
			}
			fclose($fp);
			return true;
		}

		/**
		 * 備份數據
		 *
		 * @access public
		 * @parameter string $data	數據
		 * @return void
		 */
		public function export($data){
			return $this->wri_file($data); //寫入數據
		}

		//+-------------
		//+-------------

		/**
		 * 獲取所有備份文件
		 *
		 * @access public
		 * @return Array
		 */
		public function get_backup(){
			$backup = scandir($this->data_dir); //查詢所有的備份文件
			for($i=0; $i<count($backup); $i++){
				if($backup[$i] != "." && $backup[$i] != ".."){
					$arrbackup[] = $backup[$i];
				}
			}
			return $arrbackup; //返回備份文件集合
		}

		/**
		 * 導入數據
		 * （一個備份文件有多個分卷，只需任選一個備份文件導入,程序會自動導入其他分卷 ）
		 *
		 * @access public
		 * @parameter string|array $filename	備份文件名
		 * @return Boolean
		 */
		public function import($filename){
			//傳入文件名為分卷文件之一,則查找出所有分卷文件
			$Boolean = preg_match("/_part/",$filename); 		   //判斷文件是否為分卷文件
			if($Boolean){
				$fn = explode("_part", $filename);				   //取分卷文件名
				$backup = scandir($this->data_dir);	    		   //查詢所有的備份文件
				for($i=0; $i<count($backup); $i++){
					$part = preg_match("/{$fn[0]}/", $backup[$i]); //取得所有匹配的分卷文件
					if($part){
						$filenames[] = $backup[$i];
					}
				}
			}
			//存在文件數組則獲取分卷數據,否則獲取單個文件數據
			if(is_array($filenames)){
				foreach($filenames as $fn){
					$data .= file_get_contents($this->data_dir . $fn);  //獲取數據
				}
			}else{
				$data = file_get_contents($this->data_dir . $filename);
			}
			//切割數據
			$data = str_replace("\r", "\n", $data);
			$regular = "/;\n/";
			$data = preg_split($regular,trim($data));
			//循環導入數據
			foreach($data as $val){
				mysql_query($val) or die('導入數據失敗！' . mysql_error());
			}
			return true;
		}

		//+-------------
		//+-------------

		/**
		 * 刪除備份文件
		 *
		 * @access public
		 * @parameter string $delfn	備份文件名
		 * @return void
		 */
		public function del($delfn){
			//刪除多個備份文件
			if(is_array($delfn)){
				foreach($delfn as $fn){
					if(!unlink($this->data_dir.$fn)){ return false;}
				}
				return true;
			}
			//刪除單個備份文件
			return unlink($this->data_dir.$delfn);
		}

	}
?>





