/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageViewBindingListener;
import org.apache.pivot.wtk.ImageViewListener;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.media.Image;

@DefaultProperty(value="image")
public class ImageView
extends Component {
    private Image image = null;
    private boolean asynchronous = false;
    private String imageKey = null;
    private BindType imageBindType = BindType.BOTH;
    private ImageBindMapping imageBindMapping = null;
    private ImageViewListenerList imageViewListeners = new ImageViewListenerList();
    private ImageViewBindingListenerList imageViewBindingListeners = new ImageViewBindingListenerList();
    private static HashMap<URI, ArrayList<ImageView>> loadMap = new HashMap();

    public ImageView() {
        this(null);
    }

    public ImageView(Image image) {
        this.setImage(image);
        this.installSkin(ImageView.class);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image previousImage = this.image;
        if (previousImage != image) {
            this.image = image;
            this.imageViewListeners.imageChanged(this, previousImage);
        }
    }

    public final void setImage(final URL imageURL) {
        if (imageURL == null) {
            throw new IllegalArgumentException("imageURL is null.");
        }
        Image imageLocal = (Image)ApplicationContext.getResourceCache().get(imageURL);
        if (imageLocal == null) {
            URI imageURI;
            try {
                imageURI = imageURL.toURI();
            }
            catch (URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
            if (this.asynchronous) {
                if (loadMap.containsKey((Object)imageURI)) {
                    ((ArrayList)loadMap.get((Object)imageURI)).add((Object)this);
                } else {
                    Image.load(imageURL, new TaskAdapter<Image>(new TaskListener<Image>(){

                        public void taskExecuted(Task<Image> task) {
                            Image imageLoadedLocal = (Image)task.getResult();
                            for (ImageView imageView : (ArrayList)loadMap.get((Object)imageURI)) {
                                imageView.setImage(imageLoadedLocal);
                            }
                            loadMap.remove((Object)imageURI);
                            ApplicationContext.getResourceCache().put(imageURL, (Object)imageLoadedLocal);
                        }

                        public void executeFailed(Task<Image> task) {
                        }
                    }));
                    loadMap.put((Object)imageURI, (Object)new ArrayList((Object[])new ImageView[]{this}));
                }
            } else {
                imageLocal = Image.loadFromCache(imageURL);
            }
        }
        this.setImage(imageLocal);
    }

    public final void setImage(String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException("imageName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(imageName.substring(1));
        if (url == null) {
            throw new IllegalArgumentException("cannot find image resource " + imageName);
        }
        this.setImage(url);
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        if (this.asynchronous != asynchronous) {
            this.asynchronous = asynchronous;
            this.imageViewListeners.asynchronousChanged(this);
        }
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public void setImageKey(String imageKey) {
        String previousImageKey = this.imageKey;
        if (previousImageKey != imageKey) {
            this.imageKey = imageKey;
            this.imageViewBindingListeners.imageKeyChanged(this, previousImageKey);
        }
    }

    public BindType getImageBindType() {
        return this.imageBindType;
    }

    public void setImageBindType(BindType imageBindType) {
        if (imageBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousImageBindType = this.imageBindType;
        if (previousImageBindType != imageBindType) {
            this.imageBindType = imageBindType;
            this.imageViewBindingListeners.imageBindTypeChanged(this, previousImageBindType);
        }
    }

    public ImageBindMapping getImageBindMapping() {
        return this.imageBindMapping;
    }

    public void setImageBindMapping(ImageBindMapping imageBindMapping) {
        ImageBindMapping previousImageBindMapping = this.imageBindMapping;
        if (previousImageBindMapping != imageBindMapping) {
            this.imageBindMapping = imageBindMapping;
            this.imageViewBindingListeners.imageBindMappingChanged(this, previousImageBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.imageKey != null && JSON.containsKey((Object)context, (String)this.imageKey) && this.imageBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.imageKey);
            if (this.imageBindMapping != null) {
                switch (this.imageBindMapping.getType()) {
                    case IMAGE: {
                        value = this.imageBindMapping.toImage(value);
                        break;
                    }
                    case URL: {
                        value = this.imageBindMapping.toImageURL(value);
                        break;
                    }
                    case NAME: {
                        value = this.imageBindMapping.toImageName(value);
                        break;
                    }
                }
            }
            if (value == null || value instanceof Image) {
                this.setImage((Image)value);
            } else if (value instanceof URL) {
                this.setImage((URL)value);
            } else if (value instanceof String) {
                this.setImage((String)value);
            } else {
                throw new IllegalArgumentException(this.getClass().getName() + " can't bind to " + value + ".");
            }
        }
    }

    @Override
    public void store(Object context) {
        if (this.imageKey != null && this.imageBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.imageKey, (Object)(this.imageBindMapping == null ? this.image : this.imageBindMapping.valueOf(this.image)));
        }
    }

    @Override
    public void clear() {
        if (this.imageKey != null) {
            this.setImage((Image)null);
        }
    }

    public ListenerList<ImageViewListener> getImageViewListeners() {
        return this.imageViewListeners;
    }

    public ListenerList<ImageViewBindingListener> getImageViewBindingListeners() {
        return this.imageViewBindingListeners;
    }

    private static class ImageViewBindingListenerList
    extends WTKListenerList<ImageViewBindingListener>
    implements ImageViewBindingListener {
        private ImageViewBindingListenerList() {
        }

        @Override
        public void imageKeyChanged(ImageView imageView, String previousImageKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageViewBindingListener listener = (ImageViewBindingListener)i$.next();
                listener.imageKeyChanged(imageView, previousImageKey);
            }
        }

        @Override
        public void imageBindTypeChanged(ImageView imageView, BindType previousImageBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageViewBindingListener listener = (ImageViewBindingListener)i$.next();
                listener.imageBindTypeChanged(imageView, previousImageBindType);
            }
        }

        @Override
        public void imageBindMappingChanged(ImageView imageView, ImageBindMapping previousImageBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageViewBindingListener listener = (ImageViewBindingListener)i$.next();
                listener.imageBindMappingChanged(imageView, previousImageBindMapping);
            }
        }
    }

    private static class ImageViewListenerList
    extends WTKListenerList<ImageViewListener>
    implements ImageViewListener {
        private ImageViewListenerList() {
        }

        @Override
        public void imageChanged(ImageView imageView, Image previousImage) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageViewListener listener = (ImageViewListener)i$.next();
                listener.imageChanged(imageView, previousImage);
            }
        }

        @Override
        public void asynchronousChanged(ImageView imageView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ImageViewListener listener = (ImageViewListener)i$.next();
                listener.asynchronousChanged(imageView);
            }
        }
    }

    public static interface ImageBindMapping {
        public Type getType();

        public Image toImage(Object var1);

        public URL toImageURL(Object var1);

        public String toImageName(Object var1);

        public Object valueOf(Image var1);

        public static enum Type {
            IMAGE,
            URL,
            NAME;

        }
    }
}

