/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.TabPaneAttributeListener;
import org.apache.pivot.wtk.TabPaneListener;
import org.apache.pivot.wtk.TabPaneSelectionListener;
import org.apache.pivot.wtk.WTKListenerList;
import org.apache.pivot.wtk.content.ButtonDataRenderer;

@DefaultProperty(value="tabs")
public class TabPane
extends Container {
    private ArrayList<Component> tabs = new ArrayList();
    private TabSequence tabSequence = new TabSequence();
    private Component corner = null;
    private int selectedIndex = -1;
    private Button.DataRenderer tabDataRenderer = DEFAULT_TAB_DATA_RENDERER;
    private boolean closeable = false;
    private boolean collapsible = false;
    private TabPaneListenerList tabPaneListeners = new TabPaneListenerList();
    private TabPaneSelectionListenerList tabPaneSelectionListeners = new TabPaneSelectionListenerList();
    private TabPaneAttributeListenerList tabPaneAttributeListeners = new TabPaneAttributeListenerList();
    private static final Button.DataRenderer DEFAULT_TAB_DATA_RENDERER = new ButtonDataRenderer();

    public TabPane() {
        this.installSkin(TabPane.class);
    }

    public TabSequence getTabs() {
        return this.tabSequence;
    }

    public Component getCorner() {
        return this.corner;
    }

    public void setCorner(Component corner) {
        Component previousCorner = this.corner;
        if (previousCorner != corner) {
            this.corner = null;
            if (previousCorner != null) {
                this.remove(previousCorner);
            }
            if (corner != null) {
                this.insert(corner, 0);
            }
            this.corner = corner;
            this.tabPaneListeners.cornerChanged(this, previousCorner);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        TabPane.indexBoundsCheck("selectedIndex", selectedIndex, -1, this.tabs.getLength() - 1);
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            Vote vote = this.tabPaneSelectionListeners.previewSelectedIndexChange(this, selectedIndex);
            if (vote == Vote.APPROVE) {
                this.selectedIndex = selectedIndex;
                this.tabPaneSelectionListeners.selectedIndexChanged(this, previousSelectedIndex);
            } else {
                this.tabPaneSelectionListeners.selectedIndexChangeVetoed(this, vote);
            }
        }
    }

    public Component getSelectedTab() {
        return this.selectedIndex == -1 ? null : (Component)this.tabs.get(this.selectedIndex);
    }

    public void setSelectedTab(Component comp) {
        if (comp == null) {
            this.setSelectedIndex(-1);
        } else {
            int index = this.tabs.indexOf((Object)comp);
            if (index < 0) {
                throw new IllegalArgumentException("component is not a child of the TabPane");
            }
            this.setSelectedIndex(index);
        }
    }

    public Button.DataRenderer getTabDataRenderer() {
        return this.tabDataRenderer;
    }

    public void setTabDataRenderer(Button.DataRenderer tabDataRenderer) {
        if (tabDataRenderer == null) {
            throw new IllegalArgumentException();
        }
        Button.DataRenderer previousTabDataRenderer = this.tabDataRenderer;
        if (previousTabDataRenderer != tabDataRenderer) {
            this.tabDataRenderer = tabDataRenderer;
            this.tabPaneListeners.tabDataRendererChanged(this, previousTabDataRenderer);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.tabPaneListeners.closeableChanged(this);
        }
    }

    public boolean isCollapsed() {
        return this.collapsible && this.selectedIndex == -1;
    }

    public void setCollapsed(boolean collapsed) {
        if (this.collapsible && this.isCollapsed() != collapsed) {
            int index = collapsed || this.tabs.getLength() == 0 ? -1 : 0;
            this.setSelectedIndex(index);
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (this.collapsible != collapsible) {
            this.collapsible = collapsible;
            this.tabPaneListeners.collapsibleChanged(this);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.corner && this.tabs.indexOf((Object)component) < 0) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<TabPaneListener> getTabPaneListeners() {
        return this.tabPaneListeners;
    }

    public ListenerList<TabPaneSelectionListener> getTabPaneSelectionListeners() {
        return this.tabPaneSelectionListeners;
    }

    public ListenerList<TabPaneAttributeListener> getTabPaneAttributeListeners() {
        return this.tabPaneAttributeListeners;
    }

    public static Object getTabData(Component component) {
        return component.getAttribute(Attribute.TAB_DATA);
    }

    public static void setTabData(Component component, Object tabData) {
        Container parent;
        Object previousTabData = component.setAttribute(Attribute.TAB_DATA, tabData);
        if (previousTabData != tabData && (parent = component.getParent()) instanceof TabPane) {
            TabPane tabPane = (TabPane)parent;
            tabPane.tabPaneAttributeListeners.tabDataChanged(tabPane, component, previousTabData);
        }
    }

    public static String getTooltipText(Component component) {
        return (String)component.getAttribute(Attribute.TOOLTIP_TEXT);
    }

    public static void setTooltipText(Component component, String tooltipText) {
        Container parent;
        String previousTooltipText = (String)component.setAttribute(Attribute.TOOLTIP_TEXT, tooltipText);
        if (previousTooltipText != tooltipText && (parent = component.getParent()) instanceof TabPane) {
            TabPane tabPane = (TabPane)parent;
            tabPane.tabPaneAttributeListeners.tooltipTextChanged(tabPane, component, previousTooltipText);
        }
    }

    private static class TabPaneAttributeListenerList
    extends WTKListenerList<TabPaneAttributeListener>
    implements TabPaneAttributeListener {
        private TabPaneAttributeListenerList() {
        }

        @Override
        public void tabDataChanged(TabPane tabPane, Component component, Object previousTabData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneAttributeListener listener = (TabPaneAttributeListener)i$.next();
                listener.tabDataChanged(tabPane, component, previousTabData);
            }
        }

        @Override
        public void tooltipTextChanged(TabPane tabPane, Component component, String previousTooltipText) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneAttributeListener listener = (TabPaneAttributeListener)i$.next();
                listener.tooltipTextChanged(tabPane, component, previousTooltipText);
            }
        }
    }

    private static class TabPaneSelectionListenerList
    extends WTKListenerList<TabPaneSelectionListener>
    implements TabPaneSelectionListener {
        private TabPaneSelectionListenerList() {
        }

        @Override
        public Vote previewSelectedIndexChange(TabPane tabPane, int selectedIndex) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneSelectionListener listener = (TabPaneSelectionListener)i$.next();
                vote = vote.tally(listener.previewSelectedIndexChange(tabPane, selectedIndex));
            }
            return vote;
        }

        @Override
        public void selectedIndexChangeVetoed(TabPane tabPane, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneSelectionListener listener = (TabPaneSelectionListener)i$.next();
                listener.selectedIndexChangeVetoed(tabPane, reason);
            }
        }

        @Override
        public void selectedIndexChanged(TabPane tabPane, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneSelectionListener listener = (TabPaneSelectionListener)i$.next();
                listener.selectedIndexChanged(tabPane, previousSelectedIndex);
            }
        }
    }

    private static class TabPaneListenerList
    extends WTKListenerList<TabPaneListener>
    implements TabPaneListener {
        private TabPaneListenerList() {
        }

        @Override
        public void tabInserted(TabPane tabPane, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.tabInserted(tabPane, index);
            }
        }

        @Override
        public Vote previewRemoveTabs(TabPane tabPane, int index, int count) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                vote = vote.tally(listener.previewRemoveTabs(tabPane, index, count));
            }
            return vote;
        }

        @Override
        public void tabsRemoved(TabPane tabPane, int index, Sequence<Component> tabs) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.tabsRemoved(tabPane, index, tabs);
            }
        }

        @Override
        public void removeTabsVetoed(TabPane tabPane, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.removeTabsVetoed(tabPane, reason);
            }
        }

        @Override
        public void cornerChanged(TabPane tabPane, Component previousCorner) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.cornerChanged(tabPane, previousCorner);
            }
        }

        @Override
        public void tabDataRendererChanged(TabPane tabPane, Button.DataRenderer previousTabDataRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.tabDataRendererChanged(tabPane, previousTabDataRenderer);
            }
        }

        @Override
        public void closeableChanged(TabPane tabPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.closeableChanged(tabPane);
            }
        }

        @Override
        public void collapsibleChanged(TabPane tabPane) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TabPaneListener listener = (TabPaneListener)i$.next();
                listener.collapsibleChanged(tabPane);
            }
        }
    }

    private static enum Attribute {
        TAB_DATA,
        TOOLTIP_TEXT;

    }

    public final class TabSequence
    implements Sequence<Component>,
    Iterable<Component> {
        private TabSequence() {
        }

        public int add(Component tab) {
            int index = this.getLength();
            this.insert(tab, index);
            return index;
        }

        public void insert(Component tab, int index) {
            if (tab == null) {
                throw new IllegalArgumentException("tab is null.");
            }
            TabPane.this.add(tab);
            TabPane.this.tabs.insert((Object)tab, index);
            int previousSelectedIndex = TabPane.this.selectedIndex;
            if (TabPane.this.selectedIndex >= index) {
                TabPane.this.selectedIndex++;
            }
            TabPane.this.tabPaneListeners.tabInserted(TabPane.this, index);
            if (TabPane.this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
                TabPane.this.tabPaneSelectionListeners.selectedIndexChanged(TabPane.this, TabPane.this.selectedIndex);
            }
        }

        public Component update(int index, Component tab) {
            throw new UnsupportedOperationException();
        }

        public int remove(Component tab) {
            int index = this.indexOf(tab);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Component> remove(int index, int count) {
            Sequence removed;
            Vote vote = TabPane.this.tabPaneListeners.previewRemoveTabs(TabPane.this, index, count);
            if (vote == Vote.APPROVE) {
                removed = TabPane.this.tabs.remove(index, count);
                int previousSelectedIndex = TabPane.this.selectedIndex;
                if (TabPane.this.selectedIndex >= index) {
                    if (TabPane.this.selectedIndex < index + count) {
                        TabPane.this.selectedIndex = -1;
                    } else {
                        TabPane.this.selectedIndex -= count;
                    }
                }
                TabPane.this.tabPaneListeners.tabsRemoved(TabPane.this, index, (Sequence<Component>)removed);
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    Component tab = (Component)removed.get(i);
                    TabPane.this.remove(tab);
                }
                if (TabPane.this.selectedIndex != previousSelectedIndex && previousSelectedIndex > -1) {
                    TabPane.this.tabPaneSelectionListeners.selectedIndexChanged(TabPane.this, TabPane.this.selectedIndex);
                }
            } else {
                removed = null;
                TabPane.this.tabPaneListeners.removeTabsVetoed(TabPane.this, vote);
            }
            return removed;
        }

        public Component get(int index) {
            return (Component)TabPane.this.tabs.get(index);
        }

        public int indexOf(Component tab) {
            return TabPane.this.tabs.indexOf((Object)tab);
        }

        public int getLength() {
            return TabPane.this.tabs.getLength();
        }

        @Override
        public Iterator<Component> iterator() {
            return new ImmutableIterator((Iterator)TabPane.this.tabs.iterator());
        }
    }
}

