/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.net.URL;
import org.apache.pivot.wtk.media.Image;

public class ButtonData {
    private Image icon;
    private String text;
    private Object userData = null;

    public ButtonData() {
        this(null, null);
    }

    public ButtonData(Image icon) {
        this(icon, null);
    }

    public ButtonData(String text) {
        this(null, text);
    }

    public ButtonData(Image icon, String text) {
        this.icon = icon;
        this.text = text;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setIcon(URL iconURL) {
        if (iconURL == null) {
            throw new IllegalArgumentException("iconURL is null.");
        }
        this.setIcon(Image.loadFromCache(iconURL));
    }

    public void setIcon(String iconName) {
        if (iconName == null) {
            throw new IllegalArgumentException("iconName is null.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(iconName.substring(1));
        if (url == null) {
            throw new IllegalArgumentException("cannot find icon resource " + iconName);
        }
        this.setIcon(url);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

