/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.ListenerList;

public class CalendarDateSpinnerData
implements List<CalendarDate> {
    private GregorianCalendar calendar;
    private int calendarIndex;
    private transient int length;
    private List.ListListenerList<CalendarDate> listListeners = new List.ListListenerList();

    public CalendarDateSpinnerData() {
        this(new CalendarDate(1900, 0, 0), new CalendarDate(2099, 11, 30));
    }

    public CalendarDateSpinnerData(CalendarDate lowerBound, CalendarDate upperBound) {
        if (lowerBound == null) {
            throw new IllegalArgumentException("lowerBound is null.");
        }
        if (upperBound == null) {
            throw new IllegalArgumentException("upperBound is null.");
        }
        if (lowerBound.compareTo(upperBound) > 0) {
            throw new IllegalArgumentException("lowerBound is after upperBound.");
        }
        this.calendar = new GregorianCalendar(lowerBound.year, lowerBound.month, lowerBound.day + 1);
        this.calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.calendarIndex = 0;
        GregorianCalendar upperBoundCalendar = new GregorianCalendar(upperBound.year, upperBound.month, upperBound.day + 1);
        upperBoundCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        long lowerBoundMilliseconds = this.calendar.getTimeInMillis();
        long upperBoundMilliseconds = upperBoundCalendar.getTimeInMillis();
        long indexDiff = (upperBoundMilliseconds - lowerBoundMilliseconds) / 86400000L;
        this.length = (int)indexDiff + 1;
    }

    public int add(CalendarDate item) {
        throw new UnsupportedOperationException();
    }

    public void insert(CalendarDate item, int index) {
        throw new UnsupportedOperationException();
    }

    public CalendarDate update(int index, CalendarDate item) {
        throw new UnsupportedOperationException();
    }

    public int remove(CalendarDate item) {
        throw new UnsupportedOperationException();
    }

    public Sequence<CalendarDate> remove(int index, int count) {
        throw new UnsupportedOperationException();
    }

    public CalendarDate get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index);
        }
        this.calendar.add(6, index - this.calendarIndex);
        this.calendarIndex = index;
        int year = this.calendar.get(1);
        int month = this.calendar.get(2);
        int day = this.calendar.get(5) - 1;
        return new CalendarDate(year, month, day);
    }

    public int indexOf(CalendarDate item) {
        long currentMilliseconds = this.calendar.getTimeInMillis();
        GregorianCalendar tmpCalendar = new GregorianCalendar(item.year, item.month, item.day + 1);
        tmpCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        long itemMilliseconds = tmpCalendar.getTimeInMillis();
        long indexDiff = (itemMilliseconds - currentMilliseconds) / 86400000L;
        int index = this.calendarIndex + (int)indexDiff;
        return index < 0 || index >= this.length ? -1 : index;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int getLength() {
        return this.length;
    }

    public Comparator<CalendarDate> getComparator() {
        return null;
    }

    public void setComparator(Comparator<CalendarDate> comparator) {
        throw new UnsupportedOperationException();
    }

    public Iterator<CalendarDate> iterator() {
        return new DataIterator();
    }

    public ListenerList<ListListener<CalendarDate>> getListListeners() {
        return this.listListeners;
    }

    private class DataIterator
    implements Iterator<CalendarDate> {
        private int index = 0;

        private DataIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < CalendarDateSpinnerData.this.length;
        }

        @Override
        public CalendarDate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return CalendarDateSpinnerData.this.get(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

