/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.VerticalAlignment;

public class TableViewCheckboxCellRenderer
extends BoxPane
implements TableView.CellRenderer {
    protected Checkbox checkbox = new Checkbox();
    private boolean checkboxDisabled = false;

    public TableViewCheckboxCellRenderer() {
        this.add(this.checkbox);
        this.getStyles().put("padding", (Object)3);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
        if (row != null) {
            if (columnName != null) {
                if (this.checkbox.isTriState()) {
                    this.checkbox.setStateKey(columnName);
                } else {
                    this.checkbox.setSelectedKey(columnName);
                }
                this.checkbox.load(row);
            } else {
                this.checkbox.setState(Button.State.UNSELECTED);
            }
            this.checkbox.setEnabled(!this.checkboxDisabled && tableView.isEnabled() && !disabled);
        }
    }

    @Override
    public String toString(Object row, String columnName) {
        return null;
    }

    public boolean isCheckboxDisabled() {
        return this.checkboxDisabled;
    }

    public void setCheckboxDisabled(boolean checkboxDisabled) {
        this.checkboxDisabled = checkboxDisabled;
    }
}

