/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Graphics2D;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSON;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.content.TableViewCellRenderer;

public class TableViewMultiCellRenderer
implements TableView.CellRenderer {
    private int width;
    private int height;
    private HashMap<Class<?>, TableView.CellRenderer> cellRenderers = new HashMap();
    private TableView.CellRenderer defaultRenderer;
    private TableView.CellRenderer currentRenderer = this.defaultRenderer = new TableViewCellRenderer();
    private RendererMappingSequence rendererMappings = new RendererMappingSequence();
    private static final StyleDictionary STYLES = new StyleDictionary();

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBaseline() {
        return this.currentRenderer.getBaseline();
    }

    @Override
    public void paint(Graphics2D graphics) {
        this.currentRenderer.paint(graphics);
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.currentRenderer.setSize(width, height);
    }

    @Override
    public int getPreferredWidth(int heightArgument) {
        return this.currentRenderer.getPreferredWidth(heightArgument);
    }

    @Override
    public int getPreferredHeight(int widthArgument) {
        int preferredHeight = this.defaultRenderer.getPreferredHeight(widthArgument);
        for (Class key : this.cellRenderers) {
            TableView.CellRenderer renderer = (TableView.CellRenderer)this.cellRenderers.get((Object)key);
            preferredHeight = Math.max(preferredHeight, renderer.getPreferredHeight(widthArgument));
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    @Override
    public int getBaseline(int widthArgument, int heightArgument) {
        return -1;
    }

    @Override
    public Dictionary<String, Object> getStyles() {
        return STYLES;
    }

    @Override
    public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
        if (row == null) {
            for (Class key : this.cellRenderers) {
                TableView.CellRenderer renderer = (TableView.CellRenderer)this.cellRenderers.get((Object)key);
                renderer.render(null, rowIndex, columnIndex, tableView, columnName, selected, highlighted, disabled);
            }
        } else {
            Class<?> valueClass;
            Object cellData = JSON.get((Object)row, (String)columnName);
            TableView.CellRenderer cellRenderer = null;
            Class<?> clazz = valueClass = cellData == null ? null : cellData.getClass();
            while (cellRenderer == null && valueClass != null && valueClass != Object.class) {
                cellRenderer = (TableView.CellRenderer)this.cellRenderers.get(valueClass);
                if (cellRenderer != null) continue;
                valueClass = valueClass.getSuperclass();
            }
            if (cellRenderer == null) {
                cellRenderer = this.defaultRenderer;
            }
            if (cellRenderer != this.currentRenderer) {
                this.currentRenderer = cellRenderer;
                cellRenderer.setSize(this.width, this.height);
            }
            cellRenderer.render(row, rowIndex, columnIndex, tableView, columnName, selected, highlighted, disabled);
        }
    }

    @Override
    public String toString(Object row, String columnName) {
        Class<?> valueClass;
        Object cellData = JSON.get((Object)row, (String)columnName);
        TableView.CellRenderer cellRenderer = null;
        Class<?> clazz = valueClass = cellData == null ? null : cellData.getClass();
        while (cellRenderer == null && valueClass != Object.class) {
            cellRenderer = (TableView.CellRenderer)this.cellRenderers.get(valueClass);
            if (cellRenderer != null || valueClass == null) continue;
            valueClass = valueClass.getSuperclass();
        }
        if (cellRenderer == null) {
            cellRenderer = this.defaultRenderer;
        }
        return cellRenderer.toString(row, columnName);
    }

    public TableView.CellRenderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(TableView.CellRenderer defaultRenderer) {
        if (defaultRenderer == null) {
            throw new IllegalArgumentException("defaultRenderer is null.");
        }
        this.defaultRenderer = defaultRenderer;
    }

    public Sequence<RendererMapping> getRendererMappings() {
        return this.rendererMappings;
    }

    private class RendererMappingSequence
    implements Sequence<RendererMapping> {
        private ArrayList<RendererMapping> mappings = new ArrayList();

        private RendererMappingSequence() {
        }

        public int add(RendererMapping item) {
            int index = this.mappings.getLength();
            this.insert(item, index);
            return index;
        }

        public void insert(RendererMapping item, int index) {
            if (item == null) {
                throw new IllegalArgumentException("item is null.");
            }
            Class<?> valueClass = item.getValueClass();
            if (TableViewMultiCellRenderer.this.cellRenderers.containsKey(valueClass)) {
                throw new IllegalArgumentException("Duplicate value class mapping: " + (valueClass == null ? "null" : valueClass.getName()));
            }
            this.mappings.insert((Object)item, index);
            TableView.CellRenderer cellRenderer = item.getCellRenderer();
            TableViewMultiCellRenderer.this.cellRenderers.put(valueClass, (Object)cellRenderer);
            item.multiCellRenderer = TableViewMultiCellRenderer.this;
        }

        public RendererMapping update(int index, RendererMapping item) {
            if (item == null) {
                throw new IllegalArgumentException("item is null.");
            }
            if (index >= this.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            RendererMapping previousItem = (RendererMapping)this.mappings.get(index);
            if (item != previousItem) {
                Class<?> valueClass = item.getValueClass();
                Class<?> previousValueClass = previousItem.getValueClass();
                if (TableViewMultiCellRenderer.this.cellRenderers.containsKey(valueClass) && valueClass != previousValueClass) {
                    throw new IllegalArgumentException("Duplicate value class mapping: " + valueClass.getName());
                }
                this.mappings.update(index, (Object)item);
                TableView.CellRenderer cellRenderer = item.getCellRenderer();
                TableViewMultiCellRenderer.this.cellRenderers.remove(previousValueClass);
                TableViewMultiCellRenderer.this.cellRenderers.put(valueClass, (Object)cellRenderer);
                previousItem.multiCellRenderer = null;
                item.multiCellRenderer = TableViewMultiCellRenderer.this;
            }
            return previousItem;
        }

        public int remove(RendererMapping item) {
            int index = this.mappings.indexOf((Object)item);
            if (index >= 0) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<RendererMapping> remove(int index, int count) {
            Sequence removed = this.mappings.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                RendererMapping item = (RendererMapping)removed.get(i);
                Class<?> valueClass = item.getValueClass();
                TableViewMultiCellRenderer.this.cellRenderers.remove(valueClass);
                item.multiCellRenderer = null;
            }
            return removed;
        }

        public RendererMapping get(int index) {
            return (RendererMapping)this.mappings.get(index);
        }

        public int indexOf(RendererMapping item) {
            return this.mappings.indexOf((Object)item);
        }

        public int getLength() {
            return this.mappings.getLength();
        }
    }

    public static final class RendererMapping {
        private Class<?> valueClass = null;
        private TableView.CellRenderer cellRenderer = null;
        private TableViewMultiCellRenderer multiCellRenderer = null;

        public Class<?> getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(Class<?> valueClass) {
            if (valueClass == null) {
                throw new IllegalArgumentException("valueClass is null.");
            }
            Class<?> previousValueClass = this.valueClass;
            if (valueClass != previousValueClass) {
                this.valueClass = valueClass;
                if (this.multiCellRenderer != null) {
                    this.multiCellRenderer.cellRenderers.remove(previousValueClass);
                    this.multiCellRenderer.cellRenderers.put(valueClass, (Object)this.cellRenderer);
                }
            }
        }

        public void setValueClass(String valueClass) {
            if (valueClass == null) {
                throw new IllegalArgumentException("valueClass is null.");
            }
            try {
                this.setValueClass(Class.forName(valueClass));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }

        public TableView.CellRenderer getCellRenderer() {
            return this.cellRenderer;
        }

        public void setCellRenderer(TableView.CellRenderer cellRenderer) {
            if (cellRenderer == null) {
                throw new IllegalArgumentException("cellRenderer is null.");
            }
            TableView.CellRenderer previousCellRenderer = this.cellRenderer;
            if (cellRenderer != previousCellRenderer) {
                this.cellRenderer = cellRenderer;
                if (this.multiCellRenderer != null) {
                    this.multiCellRenderer.cellRenderers.put(this.valueClass, (Object)cellRenderer);
                }
            }
        }
    }

    private static class StyleDictionary
    implements Dictionary<String, Object> {
        private StyleDictionary() {
        }

        public Object get(String key) {
            return null;
        }

        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(String key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(String key) {
            return false;
        }
    }
}

