/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.TreeBranch;
import org.apache.pivot.wtk.content.TreeNode;
import org.apache.pivot.wtk.media.Image;

public class TreeViewNodeRenderer
extends BoxPane
implements TreeView.NodeRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();
    public static final int DEFAULT_ICON_WIDTH = 16;
    public static final int DEFAULT_ICON_HEIGHT = 16;
    public static boolean DEFAULT_SHOW_ICON = true;

    public TreeViewNodeRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.setPreferredSize(16, 16);
        this.imageView.setVisible(DEFAULT_SHOW_ICON);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object node, Sequence.Tree.Path path, int rowIndex, TreeView treeView, boolean expanded, boolean selected, TreeView.NodeCheckState checkState, boolean highlighted, boolean disabled) {
        if (node != null) {
            Image icon = null;
            String text = null;
            if (node instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)node;
                if (expanded && treeNode instanceof TreeBranch) {
                    TreeBranch treeBranch = (TreeBranch)treeNode;
                    icon = treeBranch.getExpandedIcon();
                    if (icon == null) {
                        icon = treeBranch.getIcon();
                    }
                } else {
                    icon = treeNode.getIcon();
                }
                text = treeNode.getText();
            } else if (node instanceof Image) {
                icon = (Image)node;
            } else {
                text = node.toString();
            }
            this.imageView.setImage(icon);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(treeView.isEnabled() && !disabled ? 1.0f : 0.5f));
            this.label.setText(text != null ? text : "");
            if (text == null) {
                this.label.setVisible(false);
            } else {
                this.label.setVisible(true);
                Font font = (Font)treeView.getStyles().get("font");
                this.label.getStyles().put("font", (Object)font);
                Color color = treeView.isEnabled() && !disabled ? (selected ? (treeView.isFocused() ? (Color)treeView.getStyles().get("selectionColor") : (Color)treeView.getStyles().get("inactiveSelectionColor")) : (Color)treeView.getStyles().get("color")) : (Color)treeView.getStyles().get("disabledColor");
                this.label.getStyles().put("color", (Object)color);
            }
        }
    }

    @Override
    public String toString(Object node) {
        String string = null;
        if (node instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)node;
            string = treeNode.getText();
        } else if (node != null) {
            string = node.toString();
        }
        return string;
    }

    public int getIconWidth() {
        return this.imageView.getPreferredWidth(-1);
    }

    public void setIconWidth(int iconWidth) {
        if (iconWidth == -1) {
            throw new IllegalArgumentException();
        }
        this.imageView.setPreferredWidth(iconWidth);
    }

    public int getIconHeight() {
        return this.imageView.getPreferredHeight(-1);
    }

    public void setIconHeight(int iconHeight) {
        if (iconHeight == -1) {
            throw new IllegalArgumentException();
        }
        this.imageView.setPreferredHeight(iconHeight);
    }

    public boolean getShowIcon() {
        return this.imageView.isVisible();
    }

    public void setShowIcon(boolean showIcon) {
        this.imageView.setVisible(showIcon);
    }

    public boolean getFillIcon() {
        return (Boolean)this.imageView.getStyles().get("fill");
    }

    public void setFillIcon(boolean fillIcon) {
        this.imageView.getStyles().put("fill", (Object)fillIcon);
    }

    public Bounds getTextBounds() {
        return this.label.isVisible() ? this.label.getBounds() : null;
    }
}

