/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuBarItemSkin
extends ButtonSkin
implements MenuBar.ItemListener {
    protected MenuPopup menuPopup = new MenuPopup();
    private boolean closeMenuPopup = false;
    private ComponentKeyListener menuPopupComponentKeyListener = new ComponentKeyListener.Adapter(){

        @Override
        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            MenuBar.Item menuBarItem = (MenuBar.Item)MenuBarItemSkin.this.getComponent();
            MenuBar menuBar = (MenuBar)menuBarItem.getParent();
            if (keyCode == 37 || keyCode == 9 && Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                menuBar.activatePreviousItem();
                consumed = true;
            } else if (keyCode == 39 || keyCode == 9) {
                menuBar.activateNextItem();
                consumed = true;
            }
            return consumed;
        }
    };
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuBarItemSkin.this.displayMouseListener);
        }

        @Override
        public void windowClosed(Window window, Display display, Window owner) {
            Window menuBarWindow;
            MenuBar.Item menuBarItem = (MenuBar.Item)MenuBarItemSkin.this.getComponent();
            menuBarItem.setActive(false);
            MenuBar menuBar = (MenuBar)menuBarItem.getParent();
            if (menuBar.getActiveItem() == null && (menuBarWindow = menuBar.getWindow()).isOpen()) {
                menuBarWindow.moveToFront();
            }
            display.getContainerMouseListeners().remove((Object)MenuBarItemSkin.this.displayMouseListener);
            MenuBarItemSkin.this.closeMenuPopup = false;
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!MenuBarItemSkin.this.menuPopup.isAncestor(descendant) && descendant != MenuBarItemSkin.this.getComponent()) {
                MenuBarItemSkin.this.menuPopup.close(descendant instanceof Display || !MenuBarItemSkin.this.menuPopup.isOwner(descendant.getWindow()));
            }
            return false;
        }
    };

    public MenuBarItemSkin() {
        this.menuPopup.getComponentKeyListeners().add((Object)this.menuPopupComponentKeyListener);
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        MenuBar.Item menuBarItem = (MenuBar.Item)component;
        menuBarItem.getItemListeners().add((Object)this);
        this.menuPopup.setMenu(menuBarItem.getMenu());
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void mouseOver(Component component) {
        super.mouseOver(component);
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        MenuBar menuBar = (MenuBar)menuBarItem.getParent();
        if (menuBar.getActiveItem() != null) {
            menuBarItem.setActive(true);
        }
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        this.closeMenuPopup = menuBarItem.isActive();
        menuBarItem.setActive(true);
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (this.closeMenuPopup) {
            this.menuPopup.close();
        }
        return consumed;
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        MenuBar.Item menuBarItem = (MenuBar.Item)this.getComponent();
        menuBarItem.press();
        return consumed;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.menuPopup.close(true);
    }

    @Override
    public void menuChanged(MenuBar.Item menuBarItem, Menu previousMenu) {
        this.menuPopup.setMenu(menuBarItem.getMenu());
        this.repaintComponent();
    }

    @Override
    public void activeChanged(MenuBar.Item menuBarItem) {
        if (menuBarItem.isActive()) {
            Display display = menuBarItem.getDisplay();
            Point menuBarItemLocation = menuBarItem.mapPointToAncestor(display, 0, this.getHeight());
            this.menuPopup.setLocation(menuBarItemLocation.x, menuBarItemLocation.y);
            this.menuPopup.open(menuBarItem.getWindow());
            this.menuPopup.requestFocus();
        } else {
            this.menuPopup.close(true);
        }
        this.repaintComponent();
    }
}

