/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuButton;
import org.apache.pivot.wtk.MenuButtonListener;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MenuPopupStateListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.skin.ButtonSkin;

public abstract class MenuButtonSkin
extends ButtonSkin
implements MenuButton.Skin,
MenuButtonListener {
    protected boolean pressed = false;
    protected MenuPopup menuPopup = new MenuPopup();
    private WindowStateListener menuPopupWindowStateListener = new WindowStateListener.Adapter(){

        @Override
        public void windowOpened(Window window) {
            Display display = window.getDisplay();
            display.getContainerMouseListeners().add((Object)MenuButtonSkin.this.displayMouseListener);
            window.requestFocus();
        }

        @Override
        public void windowClosed(Window window, Display display, Window owner) {
            display.getContainerMouseListeners().remove((Object)MenuButtonSkin.this.displayMouseListener);
            Window componentWindow = MenuButtonSkin.this.getComponent().getWindow();
            if (componentWindow != null && componentWindow.isOpen() && !componentWindow.isClosing()) {
                componentWindow.moveToFront();
            }
            MenuButtonSkin.this.pressed = false;
            MenuButtonSkin.this.repaintComponent();
        }
    };
    private MenuPopupStateListener menuPopupStateListener = new MenuPopupStateListener.Adapter(){

        @Override
        public Vote previewMenuPopupClose(MenuPopup menuPopupArgument, boolean immediate) {
            if (menuPopupArgument.containsFocus()) {
                MenuButtonSkin.this.getComponent().requestFocus();
            }
            return Vote.APPROVE;
        }

        @Override
        public void menuPopupCloseVetoed(MenuPopup menuPopupArgument, Vote reason) {
            if (reason == Vote.DENY) {
                menuPopupArgument.requestFocus();
            }
        }
    };
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!MenuButtonSkin.this.menuPopup.isAncestor(descendant) && descendant != MenuButtonSkin.this.getComponent()) {
                MenuButtonSkin.this.menuPopup.close();
            }
            return false;
        }
    };

    @Override
    public void install(Component component) {
        super.install(component);
        MenuButton menuButton = (MenuButton)this.getComponent();
        menuButton.getMenuButtonListeners().add((Object)this);
        this.menuPopup.setMenu(menuButton.getMenu());
        this.menuPopup.getWindowStateListeners().add((Object)this.menuPopupWindowStateListener);
        this.menuPopup.getMenuPopupStateListeners().add((Object)this.menuPopupStateListener);
    }

    @Override
    public Window getMenuPopup() {
        return this.menuPopup;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        if (!component.isEnabled()) {
            this.pressed = false;
        }
        this.repaintComponent();
        this.menuPopup.close();
    }

    @Override
    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.pressed = false;
        this.repaintComponent();
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        this.pressed = true;
        this.repaintComponent();
        if (this.menuPopup.isOpen()) {
            this.menuPopup.close();
        } else {
            this.menuPopup.open(component.getWindow());
        }
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        this.pressed = false;
        this.repaintComponent();
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (keyCode == 32) {
            this.pressed = true;
            this.repaintComponent();
            if (this.menuPopup.isOpen()) {
                this.menuPopup.close();
            } else {
                this.menuPopup.open(component.getWindow());
            }
            consumed = true;
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        MenuButton menuButton = (MenuButton)this.getComponent();
        if (keyCode == 32) {
            this.pressed = false;
            this.repaintComponent();
            menuButton.press();
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }

    @Override
    public void menuChanged(MenuButton menuButton, Menu previousMenu) {
        this.menuPopup.setMenu(menuButton.getMenu());
    }
}

