/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DesktopApplicationContext;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.ScrollPaneListener;
import org.apache.pivot.wtk.Viewport;
import org.apache.pivot.wtk.ViewportListener;
import org.apache.pivot.wtk.skin.ContainerSkin;

public class ScrollPaneSkin
extends ContainerSkin
implements Viewport.Skin,
ScrollPaneListener,
ViewportListener,
ScrollBarValueListener {
    private ScrollBar horizontalScrollBar = new ScrollBar(Orientation.HORIZONTAL);
    private ScrollBar verticalScrollBar = new ScrollBar(Orientation.VERTICAL);
    private ScrollPane.Corner topLeftCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.TOP_LEFT);
    private ScrollPane.Corner bottomLeftCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.BOTTOM_LEFT);
    private ScrollPane.Corner bottomRightCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.BOTTOM_RIGHT);
    private ScrollPane.Corner topRightCorner = new ScrollPane.Corner(ScrollPane.Corner.Placement.TOP_RIGHT);
    private int horizontalReveal = 30;
    private int verticalReveal = 30;
    private int cachedHorizontalScrollBarHeight = 0;
    private int cachedVerticalScrollBarWidth = 0;
    private boolean optimizeScrolling = true;
    private static final int DEFAULT_HORIZONTAL_INCREMENT = 10;
    private static final int DEFAULT_VERTICAL_INCREMENT = 10;

    public ScrollPaneSkin() {
        this.setBackgroundPaint(Color.WHITE);
        this.horizontalScrollBar.setUnitIncrement(10);
        this.verticalScrollBar.setUnitIncrement(10);
    }

    @Override
    public void install(Component component) {
        super.install(component);
        ScrollPane scrollPane = (ScrollPane)component;
        scrollPane.getViewportListeners().add((Object)this);
        scrollPane.getScrollPaneListeners().add((Object)this);
        scrollPane.add(this.horizontalScrollBar);
        scrollPane.add(this.verticalScrollBar);
        scrollPane.add(this.topLeftCorner);
        scrollPane.add(this.bottomLeftCorner);
        scrollPane.add(this.bottomRightCorner);
        scrollPane.add(this.topRightCorner);
        this.horizontalScrollBar.getScrollBarValueListeners().add((Object)this);
        this.verticalScrollBar.getScrollBarValueListeners().add((Object)this);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        if (view != null) {
            ScrollPane.ScrollBarPolicy verticalPolicy;
            int preferredRowHeaderWidth = 0;
            Component rowHeader = scrollPane.getRowHeader();
            if (rowHeader != null) {
                preferredRowHeaderWidth = rowHeader.getPreferredWidth(-1);
            }
            int preferredColumnHeaderHeight = 0;
            Component columnHeader = scrollPane.getColumnHeader();
            if (columnHeader != null) {
                preferredColumnHeaderHeight = columnHeader.getPreferredHeight(-1);
            }
            if ((verticalPolicy = scrollPane.getVerticalScrollBarPolicy()) != ScrollPane.ScrollBarPolicy.FILL) {
                Dimensions preferredViewSize = view.getPreferredSize();
                if (verticalPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
                    int preferredHeight;
                    verticalPolicy = height < 0 ? ScrollPane.ScrollBarPolicy.AUTO : ((preferredHeight = preferredViewSize.height + preferredColumnHeaderHeight) < height ? ScrollPane.ScrollBarPolicy.FILL : ScrollPane.ScrollBarPolicy.AUTO);
                }
                if (verticalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || verticalPolicy == ScrollPane.ScrollBarPolicy.NEVER || verticalPolicy == ScrollPane.ScrollBarPolicy.AUTO) {
                    preferredWidth = preferredViewSize.width + preferredRowHeaderWidth;
                    if (verticalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || verticalPolicy == ScrollPane.ScrollBarPolicy.AUTO && height > 0 && preferredViewSize.height + preferredColumnHeaderHeight > height) {
                        preferredWidth += this.verticalScrollBar.getPreferredWidth(-1);
                    }
                }
            }
            if (verticalPolicy == ScrollPane.ScrollBarPolicy.FILL) {
                int heightUpdated = height;
                if (heightUpdated >= 0) {
                    heightUpdated = Math.max(heightUpdated - preferredColumnHeaderHeight, 0);
                }
                preferredWidth = view.getPreferredWidth(heightUpdated) + preferredRowHeaderWidth;
            }
        }
        return preferredWidth;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        if (view != null) {
            ScrollPane.ScrollBarPolicy horizontalPolicy;
            int preferredRowHeaderWidth = 0;
            Component rowHeader = scrollPane.getRowHeader();
            if (rowHeader != null) {
                preferredRowHeaderWidth = rowHeader.getPreferredWidth(-1);
            }
            int preferredColumnHeaderHeight = 0;
            Component columnHeader = scrollPane.getColumnHeader();
            if (columnHeader != null) {
                preferredColumnHeaderHeight = columnHeader.getPreferredHeight(-1);
            }
            if ((horizontalPolicy = scrollPane.getHorizontalScrollBarPolicy()) != ScrollPane.ScrollBarPolicy.FILL) {
                Dimensions preferredViewSize = view.getPreferredSize();
                if (horizontalPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
                    int preferredWidth;
                    horizontalPolicy = width < 0 ? ScrollPane.ScrollBarPolicy.AUTO : ((preferredWidth = preferredViewSize.width + preferredRowHeaderWidth) < width ? ScrollPane.ScrollBarPolicy.FILL : ScrollPane.ScrollBarPolicy.AUTO);
                }
                if (horizontalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || horizontalPolicy == ScrollPane.ScrollBarPolicy.NEVER || horizontalPolicy == ScrollPane.ScrollBarPolicy.AUTO) {
                    preferredHeight = preferredViewSize.height + preferredColumnHeaderHeight;
                    if (horizontalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || horizontalPolicy == ScrollPane.ScrollBarPolicy.AUTO && width > 0 && preferredViewSize.width + preferredRowHeaderWidth > width) {
                        preferredHeight += this.horizontalScrollBar.getPreferredHeight(-1);
                    }
                }
            }
            if (horizontalPolicy == ScrollPane.ScrollBarPolicy.FILL) {
                int widthUpdated = width;
                if (widthUpdated >= 0) {
                    widthUpdated = Math.max(widthUpdated - preferredRowHeaderWidth, 0);
                }
                preferredHeight = view.getPreferredHeight(widthUpdated) + preferredColumnHeaderHeight;
            }
        }
        return preferredHeight;
    }

    @Override
    public Dimensions getPreferredSize() {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int preferredWidth = 0;
        int preferredHeight = 0;
        Component view = scrollPane.getView();
        if (view != null) {
            Component columnHeader;
            Dimensions preferredViewSize = view.getPreferredSize();
            preferredWidth += preferredViewSize.width;
            preferredHeight += preferredViewSize.height;
            Component rowHeader = scrollPane.getRowHeader();
            if (rowHeader != null) {
                preferredWidth += rowHeader.getPreferredWidth(-1);
            }
            if ((columnHeader = scrollPane.getColumnHeader()) != null) {
                preferredHeight += columnHeader.getPreferredHeight(-1);
            }
            if (scrollPane.getHorizontalScrollBarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                preferredHeight += this.horizontalScrollBar.getPreferredHeight(-1);
            }
            if (scrollPane.getVerticalScrollBarPolicy() == ScrollPane.ScrollBarPolicy.ALWAYS) {
                preferredWidth += this.verticalScrollBar.getPreferredWidth(-1);
            }
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    @Override
    public int getBaseline(int width, int height) {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        Component rowHeader = scrollPane.getRowHeader();
        Component columnHeader = scrollPane.getColumnHeader();
        int baseline = -1;
        int clientWidth = width;
        int clientHeight = height;
        int rowHeaderWidth = 0;
        if (rowHeader != null) {
            rowHeaderWidth = rowHeader.getPreferredWidth(-1);
            clientWidth -= rowHeaderWidth;
        }
        int columnHeaderHeight = 0;
        if (columnHeader != null) {
            columnHeaderHeight = columnHeader.getPreferredHeight(-1);
            clientHeight -= columnHeaderHeight;
            baseline = columnHeader.getBaseline(clientWidth, columnHeaderHeight);
        }
        if (baseline == -1 && rowHeader != null && (baseline = rowHeader.getBaseline(rowHeaderWidth, clientHeight)) != -1) {
            baseline += columnHeaderHeight;
        }
        if (baseline == -1 && view != null && (baseline = view.getBaseline(clientWidth, clientHeight)) != -1) {
            baseline += columnHeaderHeight;
        }
        return baseline;
    }

    @Override
    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        boolean consumed = false;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        if (view != null) {
            if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                int previousScrollLeft = scrollPane.getScrollLeft();
                int newScrollLeft = previousScrollLeft + scrollAmount * wheelRotation * this.horizontalScrollBar.getUnitIncrement();
                if (wheelRotation > 0) {
                    int maxScrollLeft = this.getMaxScrollLeft();
                    newScrollLeft = Math.min(newScrollLeft, maxScrollLeft);
                    if (previousScrollLeft < maxScrollLeft) {
                        consumed = true;
                    }
                } else {
                    newScrollLeft = Math.max(newScrollLeft, 0);
                    if (previousScrollLeft > 0) {
                        consumed = true;
                    }
                }
                scrollPane.setScrollLeft(newScrollLeft);
            } else {
                int previousScrollTop = scrollPane.getScrollTop();
                int newScrollTop = previousScrollTop + scrollAmount * wheelRotation * this.verticalScrollBar.getUnitIncrement();
                if (wheelRotation > 0) {
                    int maxScrollTop = this.getMaxScrollTop();
                    newScrollTop = Math.min(newScrollTop, maxScrollTop);
                    if (previousScrollTop < maxScrollTop) {
                        consumed = true;
                    }
                } else {
                    newScrollTop = Math.max(newScrollTop, 0);
                    if (previousScrollTop > 0) {
                        consumed = true;
                    }
                }
                scrollPane.setScrollTop(newScrollTop);
            }
        }
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        if (!consumed) {
            ScrollPane scrollPane = (ScrollPane)this.getComponent();
            int scrollTop = scrollPane.getScrollTop();
            int scrollLeft = scrollPane.getScrollLeft();
            if (keyCode == 38) {
                int newScrollTop = Math.max(scrollTop - this.verticalScrollBar.getUnitIncrement(), 0);
                scrollPane.setScrollTop(newScrollTop);
                consumed = newScrollTop != scrollTop;
            } else if (keyCode == 40) {
                int newScrollTop = Math.min(scrollTop + this.verticalScrollBar.getUnitIncrement(), this.getMaxScrollTop());
                scrollPane.setScrollTop(newScrollTop);
                consumed = newScrollTop != scrollTop;
            } else if (keyCode == 37) {
                int newScrollLeft = Math.max(scrollLeft - this.horizontalScrollBar.getUnitIncrement(), 0);
                scrollPane.setScrollLeft(newScrollLeft);
                consumed = newScrollLeft != scrollLeft;
            } else if (keyCode == 39) {
                int newScrollLeft = Math.min(scrollLeft + this.horizontalScrollBar.getUnitIncrement(), this.getMaxScrollLeft());
                scrollPane.setScrollLeft(newScrollLeft);
                consumed = newScrollLeft != scrollLeft;
            } else if (keyCode == 33) {
                int increment = this.verticalScrollBar.getBlockIncrement();
                int newScrollTop = Math.max(scrollTop - increment, 0);
                scrollPane.setScrollTop(newScrollTop);
                consumed = newScrollTop != scrollTop;
            } else if (keyCode == 34) {
                int increment = this.verticalScrollBar.getBlockIncrement();
                int newScrollTop = Math.min(scrollTop + increment, this.getMaxScrollTop());
                scrollPane.setScrollTop(newScrollTop);
                consumed = newScrollTop != scrollTop;
            }
        }
        return consumed;
    }

    private int getMaxScrollTop() {
        int maxScrollTop = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        if (view != null) {
            int viewHeight = view.getHeight();
            int columnHeaderHeight = 0;
            int horizontalScrollBarHeight = 0;
            int height = this.getHeight();
            Component columnHeader = scrollPane.getColumnHeader();
            if (columnHeader != null) {
                columnHeaderHeight = columnHeader.getHeight();
            }
            if (this.horizontalScrollBar.isVisible()) {
                horizontalScrollBarHeight = this.horizontalScrollBar.getHeight();
            }
            maxScrollTop = Math.max(viewHeight + columnHeaderHeight + horizontalScrollBarHeight - height, 0);
        }
        return maxScrollTop;
    }

    private int getMaxScrollLeft() {
        int maxScrollLeft = 0;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component view = scrollPane.getView();
        if (view != null) {
            int viewWidth = view.getWidth();
            int rowHeaderWidth = 0;
            int verticalScrollBarWidth = 0;
            int width = this.getWidth();
            Component rowHeader = scrollPane.getRowHeader();
            if (rowHeader != null) {
                rowHeaderWidth = rowHeader.getWidth();
            }
            if (this.verticalScrollBar.isVisible()) {
                verticalScrollBarWidth = this.verticalScrollBar.getWidth();
            }
            maxScrollLeft = Math.max(viewWidth + rowHeaderWidth + verticalScrollBarWidth - width, 0);
        }
        return maxScrollLeft;
    }

    @Override
    public void layout() {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        ScrollPane.ScrollBarPolicy horizontalPolicy = scrollPane.getHorizontalScrollBarPolicy();
        ScrollPane.ScrollBarPolicy verticalPolicy = scrollPane.getVerticalScrollBarPolicy();
        boolean fillWidthToCapacity = false;
        boolean fillHeightToCapacity = false;
        if (horizontalPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
            horizontalPolicy = ScrollPane.ScrollBarPolicy.AUTO;
            fillWidthToCapacity = true;
        }
        if (verticalPolicy == ScrollPane.ScrollBarPolicy.FILL_TO_CAPACITY) {
            verticalPolicy = ScrollPane.ScrollBarPolicy.AUTO;
            fillHeightToCapacity = true;
        }
        this.layoutHelper(horizontalPolicy, verticalPolicy);
        Component view = scrollPane.getView();
        if (view != null && (fillWidthToCapacity || fillHeightToCapacity)) {
            boolean adjustWidth = false;
            boolean adjustHeight = false;
            if (fillWidthToCapacity) {
                Component rowHeader = scrollPane.getRowHeader();
                int rowHeaderWidth = rowHeader != null ? rowHeader.getWidth() : 0;
                int verticalScrollBarWidth = this.verticalScrollBar.isVisible() ? this.verticalScrollBar.getWidth() : 0;
                int minViewWidth = this.getWidth() - rowHeaderWidth - verticalScrollBarWidth;
                if (view.getWidth() < minViewWidth) {
                    horizontalPolicy = ScrollPane.ScrollBarPolicy.FILL;
                    adjustWidth = true;
                }
            }
            if (fillHeightToCapacity) {
                Component columnHeader = scrollPane.getColumnHeader();
                int columnHeaderHeight = columnHeader != null ? columnHeader.getHeight() : 0;
                int horizontalScrollBarHeight = this.horizontalScrollBar.isVisible() ? this.horizontalScrollBar.getHeight() : 0;
                int minViewHeight = this.getHeight() - columnHeaderHeight - horizontalScrollBarHeight;
                if (view.getHeight() < minViewHeight) {
                    verticalPolicy = ScrollPane.ScrollBarPolicy.FILL;
                    adjustHeight = true;
                }
            }
            if (adjustWidth || adjustHeight) {
                this.layoutHelper(horizontalPolicy, verticalPolicy);
            }
        }
        this.cachedHorizontalScrollBarHeight = this.horizontalScrollBar.getHeight();
        this.cachedVerticalScrollBarWidth = this.verticalScrollBar.getWidth();
    }

    private void layoutHelper(ScrollPane.ScrollBarPolicy horizontalPolicy, ScrollPane.ScrollBarPolicy verticalPolicy) {
        int maxScrollLeft;
        int previousVerticalScrollBarWidth;
        int previousHorizontalScrollBarHeight;
        int previousViewHeight;
        int previousViewWidth;
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean constrainWidth = horizontalPolicy == ScrollPane.ScrollBarPolicy.FILL;
        boolean constrainHeight = verticalPolicy == ScrollPane.ScrollBarPolicy.FILL;
        Component view = scrollPane.getView();
        Component columnHeader = scrollPane.getColumnHeader();
        Component rowHeader = scrollPane.getRowHeader();
        Component corner = scrollPane.getCorner();
        int rowHeaderWidth = 0;
        if (rowHeader != null) {
            rowHeaderWidth = rowHeader.getPreferredWidth(-1);
        }
        int columnHeaderHeight = 0;
        if (columnHeader != null) {
            columnHeaderHeight = columnHeader.getPreferredHeight(-1);
        }
        int viewWidth = 0;
        int viewHeight = 0;
        int horizontalScrollBarHeight = this.cachedHorizontalScrollBarHeight;
        int verticalScrollBarWidth = this.cachedVerticalScrollBarWidth;
        int i = 0;
        do {
            previousViewWidth = viewWidth;
            previousViewHeight = viewHeight;
            previousHorizontalScrollBarHeight = horizontalScrollBarHeight;
            previousVerticalScrollBarWidth = verticalScrollBarWidth;
            if (view != null) {
                if (constrainWidth && constrainHeight) {
                    viewWidth = Math.max(width - rowHeaderWidth - verticalScrollBarWidth, 0);
                    viewHeight = Math.max(height - columnHeaderHeight - horizontalScrollBarHeight, 0);
                } else if (constrainWidth) {
                    viewWidth = Math.max(width - rowHeaderWidth - verticalScrollBarWidth, 0);
                    viewHeight = view.getPreferredHeight(viewWidth);
                } else if (constrainHeight) {
                    viewHeight = Math.max(height - columnHeaderHeight - horizontalScrollBarHeight, 0);
                    viewWidth = view.getPreferredWidth(viewHeight);
                } else {
                    Dimensions viewPreferredSize = view.getPreferredSize();
                    viewWidth = viewPreferredSize.width;
                    viewHeight = viewPreferredSize.height;
                }
            }
            horizontalScrollBarHeight = horizontalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || horizontalPolicy == ScrollPane.ScrollBarPolicy.AUTO && viewWidth > width - rowHeaderWidth - verticalScrollBarWidth ? this.horizontalScrollBar.getPreferredHeight(-1) : 0;
            verticalScrollBarWidth = verticalPolicy == ScrollPane.ScrollBarPolicy.ALWAYS || verticalPolicy == ScrollPane.ScrollBarPolicy.AUTO && viewHeight > height - columnHeaderHeight - horizontalScrollBarHeight ? this.verticalScrollBar.getPreferredWidth(-1) : 0;
            if (++i <= 4) continue;
            System.err.println("Breaking out of potential infinite loop");
            break;
        } while (viewWidth != previousViewWidth || viewHeight != previousViewHeight || horizontalScrollBarHeight != previousHorizontalScrollBarHeight || verticalScrollBarWidth != previousVerticalScrollBarWidth);
        int scrollTop = scrollPane.getScrollTop();
        int scrollLeft = scrollPane.getScrollLeft();
        if (view != null) {
            view.setSize(viewWidth, viewHeight);
            view.setLocation(rowHeaderWidth - scrollLeft, columnHeaderHeight - scrollTop);
        }
        if (columnHeader != null) {
            columnHeader.setSize(viewWidth, columnHeaderHeight);
            columnHeader.setLocation(rowHeaderWidth - scrollLeft, 0);
        }
        if (rowHeader != null) {
            rowHeader.setSize(rowHeaderWidth, viewHeight);
            rowHeader.setLocation(0, columnHeaderHeight - scrollTop);
        }
        if (horizontalScrollBarHeight > 0) {
            this.horizontalScrollBar.setVisible(true);
            int horizontalScrollBarWidth = Math.max(width - rowHeaderWidth - verticalScrollBarWidth, 0);
            this.horizontalScrollBar.setSize(horizontalScrollBarWidth, horizontalScrollBarHeight);
            this.horizontalScrollBar.setLocation(rowHeaderWidth, height - horizontalScrollBarHeight);
        } else {
            this.horizontalScrollBar.setVisible(false);
        }
        if (verticalScrollBarWidth > 0) {
            this.verticalScrollBar.setVisible(true);
            int verticalScrollBarHeight = Math.max(height - columnHeaderHeight - horizontalScrollBarHeight, 0);
            this.verticalScrollBar.setSize(verticalScrollBarWidth, verticalScrollBarHeight);
            this.verticalScrollBar.setLocation(width - verticalScrollBarWidth, columnHeaderHeight);
        } else {
            this.verticalScrollBar.setVisible(false);
        }
        if (columnHeaderHeight > 0 && rowHeaderWidth > 0) {
            if (corner != null) {
                corner.setVisible(true);
                corner.setSize(rowHeaderWidth, columnHeaderHeight);
                corner.setLocation(0, 0);
                this.topLeftCorner.setVisible(false);
            } else {
                this.topLeftCorner.setVisible(true);
                this.topLeftCorner.setSize(rowHeaderWidth, columnHeaderHeight);
                this.topLeftCorner.setLocation(0, 0);
            }
        } else {
            if (corner != null) {
                corner.setVisible(false);
            }
            this.topLeftCorner.setVisible(false);
        }
        if (rowHeaderWidth > 0 && horizontalScrollBarHeight > 0) {
            this.bottomLeftCorner.setVisible(true);
            this.bottomLeftCorner.setSize(rowHeaderWidth, horizontalScrollBarHeight);
            this.bottomLeftCorner.setLocation(0, height - horizontalScrollBarHeight);
        } else {
            this.bottomLeftCorner.setVisible(false);
        }
        if (verticalScrollBarWidth > 0 && horizontalScrollBarHeight > 0) {
            this.bottomRightCorner.setVisible(true);
            this.bottomRightCorner.setSize(verticalScrollBarWidth, horizontalScrollBarHeight);
            this.bottomRightCorner.setLocation(width - verticalScrollBarWidth, height - horizontalScrollBarHeight);
        } else {
            this.bottomRightCorner.setVisible(false);
        }
        if (columnHeaderHeight > 0 && verticalScrollBarWidth > 0) {
            this.topRightCorner.setVisible(true);
            this.topRightCorner.setSize(verticalScrollBarWidth, columnHeaderHeight);
            this.topRightCorner.setLocation(width - verticalScrollBarWidth, 0);
        } else {
            this.topRightCorner.setVisible(false);
        }
        int maxScrollTop = this.getMaxScrollTop();
        if (scrollTop > maxScrollTop) {
            scrollPane.setScrollTop(maxScrollTop);
        }
        if (scrollLeft > (maxScrollLeft = this.getMaxScrollLeft())) {
            scrollPane.setScrollLeft(maxScrollLeft);
        }
        int viewportWidth = Math.max(width - rowHeaderWidth - verticalScrollBarWidth, 0);
        this.horizontalScrollBar.setScope(0, viewWidth, Math.min(viewWidth, viewportWidth));
        this.horizontalScrollBar.setBlockIncrement(Math.max(1, viewportWidth - this.horizontalReveal));
        int viewportHeight = Math.max(height - columnHeaderHeight - horizontalScrollBarHeight, 0);
        this.verticalScrollBar.setScope(0, viewHeight, Math.min(viewHeight, viewportHeight));
        this.verticalScrollBar.setBlockIncrement(Math.max(1, viewportHeight - this.verticalReveal));
    }

    @Override
    public void setBackgroundPaint(Paint backgroundPaint) {
        super.setBackgroundPaint(backgroundPaint);
        this.optimizeScrolling = backgroundPaint != null && backgroundPaint.getTransparency() == 1;
    }

    public int getHorizontalIncrement() {
        return this.horizontalScrollBar.getUnitIncrement();
    }

    public void setHorizontalIncrement(int horizontalIncrement) {
        this.horizontalScrollBar.setUnitIncrement(horizontalIncrement);
    }

    public int getVerticalIncrement() {
        return this.verticalScrollBar.getUnitIncrement();
    }

    public void setVerticalIncrement(int verticalIncrement) {
        this.verticalScrollBar.setUnitIncrement(verticalIncrement);
    }

    public int getHorizontalReveal() {
        return this.horizontalReveal;
    }

    public void setHorizontalReveal(int horizontalReveal) {
        this.horizontalReveal = horizontalReveal;
    }

    public int getVerticalReveal() {
        return this.verticalReveal;
    }

    public void setVerticalReveal(int verticalReveal) {
        this.verticalReveal = verticalReveal;
    }

    private boolean isOptimizeScrolling() {
        boolean optimizeScrollingLocal = this.optimizeScrolling;
        if (optimizeScrollingLocal) {
            ScrollPane scrollPane = (ScrollPane)this.getComponent();
            ApplicationContext.DisplayHost displayHost = scrollPane.getDisplay().getDisplayHost();
            optimizeScrollingLocal = displayHost.getScale() == 1.0 && DesktopApplicationContext.isActive() && displayHost.isDisplayable();
        }
        return optimizeScrollingLocal;
    }

    @Override
    public Bounds getViewportBounds() {
        Component columnHeader;
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        Component rowHeader = scrollPane.getRowHeader();
        if (rowHeader != null) {
            int rowHeaderWidth = rowHeader.getWidth();
            x += rowHeaderWidth;
            width -= rowHeaderWidth;
        }
        if ((columnHeader = scrollPane.getColumnHeader()) != null) {
            int columnHeaderHeight = columnHeader.getHeight();
            y += columnHeaderHeight;
            height -= columnHeaderHeight;
        }
        if (this.horizontalScrollBar.isVisible()) {
            height -= this.horizontalScrollBar.getHeight();
        }
        if (this.verticalScrollBar.isVisible()) {
            width -= this.verticalScrollBar.getWidth();
        }
        return new Bounds(x, y, width, height);
    }

    @Override
    public void horizontalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollPane.ScrollBarPolicy previousHorizontalScrollBarPolicy) {
        this.invalidateComponent();
    }

    @Override
    public void verticalScrollBarPolicyChanged(ScrollPane scrollPane, ScrollPane.ScrollBarPolicy previousVerticalScrollBarPolicy) {
        this.invalidateComponent();
    }

    @Override
    public void rowHeaderChanged(ScrollPane scrollPane, Component previousRowHeader) {
        this.invalidateComponent();
    }

    @Override
    public void columnHeaderChanged(ScrollPane scrollPane, Component previousColumnHeader) {
        this.invalidateComponent();
    }

    @Override
    public void cornerChanged(ScrollPane scrollPane, Component previousCorner) {
        this.invalidateComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollTopChanged(Viewport viewport, int previousScrollTop) {
        ScrollPane scrollPane = (ScrollPane)viewport;
        Component view = scrollPane.getView();
        Component rowHeader = scrollPane.getRowHeader();
        Component columnHeader = scrollPane.getColumnHeader();
        int columnHeaderHeight = 0;
        if (columnHeader != null) {
            columnHeaderHeight = columnHeader.getHeight();
        }
        int scrollTop = scrollPane.getScrollTop();
        if (view != null && view.isShowing() && this.isOptimizeScrolling()) {
            Bounds blitArea = view.getVisibleArea();
            int blitX = blitArea.x + view.getX();
            int blitY = blitArea.y + view.getY();
            int blitWidth = blitArea.width;
            int blitHeight = blitArea.height;
            if (rowHeader != null) {
                int rowHeaderWidth = rowHeader.getWidth();
                blitX -= rowHeaderWidth;
                blitWidth += rowHeaderWidth;
            }
            int deltaScrollTop = scrollTop - previousScrollTop;
            Graphics2D graphics = scrollPane.getGraphics();
            graphics.copyArea(blitX, blitY += Math.max(deltaScrollTop, 0), blitWidth, blitHeight -= Math.abs(deltaScrollTop), 0, -deltaScrollTop);
            scrollPane.setConsumeRepaint(true);
            try {
                view.setLocation(view.getX(), columnHeaderHeight - scrollTop);
                if (rowHeader != null) {
                    rowHeader.setLocation(0, columnHeaderHeight - scrollTop);
                }
            }
            finally {
                scrollPane.setConsumeRepaint(false);
            }
            boolean repaintAllViewport = scrollPane.isRepaintAllViewport();
            if (!repaintAllViewport) {
                scrollPane.repaint(blitX, columnHeaderHeight + (deltaScrollTop > 0 ? blitHeight : 0), blitWidth, Math.abs(deltaScrollTop), true);
            } else {
                Bounds viewportBounds = this.getViewportBounds();
                scrollPane.repaint(viewportBounds.x, viewportBounds.y, viewportBounds.width, viewportBounds.height, true);
            }
        } else {
            if (view != null) {
                view.setLocation(view.getX(), columnHeaderHeight - scrollTop);
            }
            if (rowHeader != null) {
                rowHeader.setLocation(0, columnHeaderHeight - scrollTop);
            }
        }
        if (scrollTop >= 0 && scrollTop <= this.getMaxScrollTop()) {
            this.verticalScrollBar.setValue(scrollTop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scrollLeftChanged(Viewport viewport, int previousScrollLeft) {
        ScrollPane scrollPane = (ScrollPane)viewport;
        Component view = scrollPane.getView();
        Component rowHeader = scrollPane.getRowHeader();
        Component columnHeader = scrollPane.getColumnHeader();
        int rowHeaderWidth = 0;
        if (rowHeader != null) {
            rowHeaderWidth = rowHeader.getWidth();
        }
        int scrollLeft = scrollPane.getScrollLeft();
        if (view != null && view.isShowing() && this.isOptimizeScrolling()) {
            Bounds blitArea = view.getVisibleArea();
            int blitX = blitArea.x + view.getX();
            int blitY = blitArea.y + view.getY();
            int blitWidth = blitArea.width;
            int blitHeight = blitArea.height;
            if (columnHeader != null) {
                int columnHeaderHeight = columnHeader.getHeight();
                blitY -= columnHeaderHeight;
                blitHeight += columnHeaderHeight;
            }
            int deltaScrollLeft = scrollLeft - previousScrollLeft;
            Graphics2D graphics = scrollPane.getGraphics();
            graphics.copyArea(blitX += Math.max(deltaScrollLeft, 0), blitY, blitWidth -= Math.abs(deltaScrollLeft), blitHeight, -deltaScrollLeft, 0);
            scrollPane.setConsumeRepaint(true);
            try {
                view.setLocation(rowHeaderWidth - scrollLeft, view.getY());
                if (columnHeader != null) {
                    columnHeader.setLocation(rowHeaderWidth - scrollLeft, 0);
                }
            }
            finally {
                scrollPane.setConsumeRepaint(false);
            }
            scrollPane.repaint(rowHeaderWidth + (deltaScrollLeft > 0 ? blitWidth : 0), blitY, Math.abs(deltaScrollLeft), blitHeight, true);
        } else {
            if (view != null) {
                view.setLocation(rowHeaderWidth - scrollLeft, view.getY());
            }
            if (columnHeader != null) {
                columnHeader.setLocation(rowHeaderWidth - scrollLeft, 0);
            }
        }
        if (scrollLeft >= 0 && scrollLeft <= this.getMaxScrollLeft()) {
            this.horizontalScrollBar.setValue(scrollLeft);
        }
    }

    @Override
    public void viewChanged(Viewport viewport, Component previousView) {
        this.invalidateComponent();
    }

    @Override
    public void valueChanged(ScrollBar scrollBar, int previousValue) {
        ScrollPane scrollPane = (ScrollPane)this.getComponent();
        int value = scrollBar.getValue();
        if (scrollBar == this.horizontalScrollBar) {
            scrollPane.setScrollLeft(value);
        } else {
            scrollPane.setScrollTop(value);
        }
    }
}

