/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.TextPane;
import org.apache.pivot.wtk.skin.TextPaneSkinElementView;
import org.apache.pivot.wtk.skin.TextPaneSkinNodeView;
import org.apache.pivot.wtk.text.Element;

abstract class TextPaneSkinVerticalElementView
extends TextPaneSkinElementView {
    public TextPaneSkinVerticalElementView(Element element) {
        super(element);
    }

    @Override
    protected void childLayout(int breakWidth) {
        int width = 0;
        int height = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.layout(breakWidth);
            nodeView.setLocation(0, height);
            width = Math.max(width, nodeView.getWidth());
            height += nodeView.getHeight();
        }
        this.setSize(width, height);
    }

    @Override
    public Dimensions getPreferredSize(int breakWidth) {
        int width = 0;
        int height = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            Dimensions childDimensions = nodeView.getPreferredSize(breakWidth);
            width = Math.max(width, childDimensions.width);
            height += childDimensions.height;
        }
        return new Dimensions(width, height);
    }

    @Override
    protected void setSkinLocation(int skinX, int skinY) {
        super.setSkinLocation(skinX, skinY);
        for (TextPaneSkinNodeView nodeView : this) {
            nodeView.setSkinLocation(skinX, skinY + nodeView.getY());
        }
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        int offset = -1;
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            TextPaneSkinNodeView nodeView = this.get(i);
            Bounds nodeViewBounds = nodeView.getBounds();
            if (y < nodeViewBounds.y || y >= nodeViewBounds.y + nodeViewBounds.height) continue;
            offset = nodeView.getInsertionPoint(x - nodeView.getX(), y - nodeView.getY()) + nodeView.getOffset();
            break;
        }
        return offset;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextPane.ScrollDirection direction) {
        int offset = -1;
        if (this.getLength() > 0) {
            if (from == -1) {
                int i = direction == TextPane.ScrollDirection.DOWN ? 0 : this.getLength() - 1;
                TextPaneSkinNodeView nodeView = this.get(i);
                offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), -1, direction);
                if (offset != -1) {
                    offset += nodeView.getOffset();
                }
            } else {
                TextPaneSkinNodeView nodeView;
                int i;
                int n = this.getLength();
                for (i = 0; i < n; ++i) {
                    nodeView = this.get(i);
                    int nodeViewOffset = nodeView.getOffset();
                    int characterCount = nodeView.getCharacterCount();
                    if (from >= nodeViewOffset && from < nodeViewOffset + characterCount) break;
                }
                if (i < n) {
                    nodeView = this.get(i);
                    offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), from - nodeView.getOffset(), direction);
                    if (offset == -1) {
                        if (direction == TextPane.ScrollDirection.DOWN) {
                            nodeView = i < n - 1 ? this.get(i + 1) : null;
                        } else {
                            TextPaneSkinNodeView textPaneSkinNodeView = nodeView = i > 0 ? this.get(i - 1) : null;
                        }
                        if (nodeView != null) {
                            offset = nodeView.getNextInsertionPoint(x - nodeView.getX(), -1, direction);
                        }
                    }
                    if (offset != -1 && nodeView != null) {
                        offset += nodeView.getOffset();
                    }
                }
            }
        }
        return offset;
    }

    @Override
    public int getRowAt(int offset) {
        int rowIndex = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            int nodeViewOffset = nodeView.getOffset();
            int characterCount = nodeView.getCharacterCount();
            if (offset >= nodeViewOffset && offset < nodeViewOffset + characterCount) {
                rowIndex += nodeView.getRowAt(offset - nodeView.getOffset());
                break;
            }
            rowIndex += nodeView.getRowCount();
        }
        return rowIndex;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        for (TextPaneSkinNodeView nodeView : this) {
            rowCount += nodeView.getRowCount();
        }
        return rowCount;
    }
}

