/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.awt.Color;
import java.awt.Font;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.text.ElementListener;
import org.apache.pivot.wtk.text.Node;

public abstract class Element
extends Node
implements Sequence<Node>,
Iterable<Node> {
    private int characterCount = 0;
    private ArrayList<Node> nodes = new ArrayList();
    private Font font;
    private Color foregroundColor;
    private Color backgroundColor;
    private boolean underline;
    private boolean strikethrough;
    private ElementListenerList elementListeners = new ElementListenerList();

    public Element() {
    }

    public Element(Element element, boolean recursive) {
        this.font = element.getFont();
        this.foregroundColor = element.getForegroundColor();
        this.backgroundColor = element.getBackgroundColor();
        this.underline = element.isUnderline();
        this.strikethrough = element.isStrikethrough();
        if (recursive) {
            for (Node node : element) {
                this.add(node.duplicate(true));
            }
        }
    }

    @Override
    public void insertRange(Node range, int offset) {
        if (!(range instanceof Element)) {
            throw new IllegalArgumentException("range is not an element.");
        }
        if (offset < 0 || offset > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        Element element = (Element)range;
        int n = element.getLength();
        if (n > 0) {
            Sequence<Node> nodesLocal = element.remove(0, n);
            if (offset == this.characterCount) {
                for (int i = 0; i < n; ++i) {
                    this.add((Node)nodesLocal.get(i));
                }
            } else {
                Node trailingSegment;
                int index = this.getNodeAt(offset);
                Node leadingSegment = this.get(index);
                int spliceOffset = offset - leadingSegment.getOffset();
                if (spliceOffset > 0) {
                    trailingSegment = leadingSegment.removeRange(spliceOffset, leadingSegment.getCharacterCount() - spliceOffset);
                    ++index;
                } else {
                    trailingSegment = null;
                }
                for (int i = 0; i < n; ++i) {
                    this.insert((Node)nodesLocal.get(i), index + i);
                }
                if (trailingSegment != null) {
                    this.insert(trailingSegment, index + n);
                }
            }
        }
    }

    @Override
    public Node removeRange(int offset, int characterCountArgument) {
        if (characterCountArgument < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (offset < 0 || offset + characterCountArgument > this.characterCount) {
            throw new IndexOutOfBoundsException();
        }
        Element range = this.duplicate(false);
        if (characterCountArgument > 0) {
            int end;
            Element element = range;
            int start = this.getNodeAt(offset);
            if (start == (end = this.getNodeAt(offset + characterCountArgument - 1))) {
                Node segment;
                Node node = this.get(start);
                int nodeOffset = node.getOffset();
                int nodeCharacterCount = node.getCharacterCount();
                if (offset == nodeOffset && characterCountArgument == nodeCharacterCount) {
                    segment = node;
                    this.remove(start, 1);
                } else {
                    segment = node.removeRange(offset - node.getOffset(), characterCountArgument);
                }
                element.add(segment);
            } else {
                Node startNode = this.get(start);
                int leadingSegmentOffset = offset - startNode.getOffset();
                Node endNode = this.get(end);
                int trailingSegmentCharacterCount = offset + characterCountArgument - endNode.getOffset();
                Node leadingSegment = null;
                if (leadingSegmentOffset > 0) {
                    leadingSegment = startNode.removeRange(leadingSegmentOffset, startNode.getCharacterCount() - leadingSegmentOffset);
                    ++start;
                }
                Node trailingSegment = null;
                if (trailingSegmentCharacterCount < endNode.getCharacterCount()) {
                    trailingSegment = endNode.removeRange(0, trailingSegmentCharacterCount);
                    --end;
                }
                int count = end - start + 1;
                Sequence<Node> removed = this.remove(start, count);
                if (leadingSegment != null && leadingSegment.getCharacterCount() > 0) {
                    element.add(leadingSegment);
                }
                int n = removed.getLength();
                for (int i = 0; i < n; ++i) {
                    element.add((Node)removed.get(i));
                }
                if (trailingSegment != null && trailingSegment.getCharacterCount() > 0) {
                    element.add(trailingSegment);
                }
            }
        }
        return range;
    }

    @Override
    public Element getRange(int offset, int characterCountArgument) {
        if (characterCountArgument < 0) {
            throw new IllegalArgumentException("characterCount is negative.");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset < 0, offset=" + offset);
        }
        if (offset + characterCountArgument > this.characterCount) {
            throw new IndexOutOfBoundsException("offset+characterCount>this.characterCount offset=" + offset + " characterCount=" + characterCountArgument + " this.characterCount=" + this.characterCount);
        }
        Element range = this.duplicate(false);
        if (characterCountArgument > 0) {
            int end;
            int start = this.getNodeAt(offset);
            if (start == (end = this.getNodeAt(offset + characterCountArgument - 1))) {
                Node node = this.get(start);
                Node segment = node.getRange(offset - node.getOffset(), characterCountArgument);
                range.add(segment);
            } else {
                Node leadingSegment = null;
                if (start < 0) {
                    start = -(start + 1);
                } else {
                    Node startNode = this.get(start);
                    int leadingSegmentOffset = offset - startNode.getOffset();
                    leadingSegment = startNode.getRange(leadingSegmentOffset, startNode.getCharacterCount() - leadingSegmentOffset);
                }
                Node trailingSegment = null;
                if (end < 0) {
                    end = -(end + 1);
                } else {
                    Node endNode = this.get(end);
                    int trailingSegmentCharacterCount = offset + characterCountArgument - endNode.getOffset();
                    trailingSegment = endNode.getRange(0, trailingSegmentCharacterCount);
                }
                if (leadingSegment != null && leadingSegment.getCharacterCount() > 0) {
                    range.add(leadingSegment);
                    ++start;
                }
                for (int i = start; i < end; ++i) {
                    range.add(this.get(i).duplicate(true));
                }
                if (trailingSegment != null && trailingSegment.getCharacterCount() > 0) {
                    range.add(trailingSegment);
                }
            }
        }
        return range;
    }

    @Override
    public abstract Element duplicate(boolean var1);

    @Override
    public char getCharacterAt(int offset) {
        Node node = (Node)this.nodes.get(this.getNodeAt(offset));
        return node.getCharacterAt(offset - node.getOffset());
    }

    @Override
    public int getCharacterCount() {
        return this.characterCount;
    }

    public int add(Node node) {
        int index = this.nodes.getLength();
        this.insert(node, index);
        return index;
    }

    public void insert(Node node, int index) {
        if (index < 0 || index > this.nodes.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (node == null) {
            throw new IllegalArgumentException("node is null.");
        }
        if (node.getParent() != null) {
            throw new IllegalArgumentException("node already has a parent.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add an element to itself.");
        }
        node.setParent(this);
        this.nodes.insert((Object)node, index);
        int nodeCharacterCount = node.getCharacterCount();
        this.characterCount += nodeCharacterCount;
        if (index == 0) {
            node.setOffset(0);
        } else {
            Node previousNode = (Node)this.nodes.get(index - 1);
            node.setOffset(previousNode.getOffset() + previousNode.getCharacterCount());
        }
        int n = this.nodes.getLength();
        for (int i = index + 1; i < n; ++i) {
            Node nextNode = (Node)this.nodes.get(i);
            nextNode.setOffset(nextNode.getOffset() + nodeCharacterCount);
        }
        super.rangeInserted(node.getOffset(), nodeCharacterCount);
        super.nodeInserted(node.getOffset());
        this.elementListeners.nodeInserted(this, index);
    }

    public Node update(int index, Node node) {
        throw new UnsupportedOperationException();
    }

    public int remove(Node node) {
        int index = this.indexOf(node);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    public Sequence<Node> remove(int index, int count) {
        if (index < 0 || index + count > this.nodes.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence removed = this.nodes.remove(index, count);
        if ((count = removed.getLength()) > 0) {
            int offset;
            int removedCharacterCount = 0;
            for (int i = 0; i < count; ++i) {
                Node node = (Node)removed.get(i);
                node.setParent(null);
                removedCharacterCount += node.getCharacterCount();
            }
            this.characterCount -= removedCharacterCount;
            int n = this.nodes.getLength();
            for (int i = index; i < n; ++i) {
                Node nextNode = (Node)this.nodes.get(i);
                nextNode.setOffset(nextNode.getOffset() - removedCharacterCount);
            }
            if (index < n) {
                Node node = this.get(index);
                offset = node.getOffset();
            } else {
                offset = this.characterCount;
            }
            super.rangeRemoved(offset, removedCharacterCount);
            super.nodesRemoved((Sequence<Node>)removed, offset);
            this.elementListeners.nodesRemoved(this, index, (Sequence<Node>)removed);
        }
        return removed;
    }

    public Node get(int index) {
        if (index < 0 || index > this.nodes.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (Node)this.nodes.get(index);
    }

    public int indexOf(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null.");
        }
        return this.nodes.indexOf((Object)node);
    }

    public int getLength() {
        return this.nodes.getLength();
    }

    public int getNodeAt(int offset) {
        if (offset < 0 || offset >= this.characterCount) {
            throw new IndexOutOfBoundsException("offset " + offset + " out of range [0," + this.characterCount + "]");
        }
        int i = this.nodes.getLength() - 1;
        Node node = (Node)this.nodes.get(i);
        while (node.getOffset() > offset) {
            node = (Node)this.nodes.get(--i);
        }
        return i;
    }

    public Sequence<Integer> getPathAt(int offset) {
        Sequence<Integer> path;
        int index = this.getNodeAt(offset);
        Node node = this.get(index);
        if (node instanceof Element) {
            Element element = (Element)node;
            path = element.getPathAt(offset - element.getOffset());
        } else {
            path = new Sequence<Integer>();
        }
        path.insert((Object)index, 0);
        return path;
    }

    public Node getDescendantAt(int offset) {
        Node descendant = (Node)this.nodes.get(this.getNodeAt(offset));
        if (descendant instanceof Element) {
            Element element = (Element)descendant;
            descendant = element.getDescendantAt(offset - element.getOffset());
        }
        return descendant;
    }

    @Override
    protected void rangeInserted(int offset, int characterCountArgument) {
        this.characterCount += characterCountArgument;
        int index = this.getNodeAt(offset);
        int n = this.nodes.getLength();
        for (int i = index + 1; i < n; ++i) {
            Node node = (Node)this.nodes.get(i);
            node.setOffset(node.getOffset() + characterCountArgument);
        }
        super.rangeInserted(offset, characterCountArgument);
    }

    @Override
    protected void rangeRemoved(int offset, int characterCountArgument) {
        this.characterCount -= characterCountArgument;
        if (offset < this.characterCount) {
            int index = this.getNodeAt(offset);
            int n = this.nodes.getLength();
            for (int i = index + 1; i < n; ++i) {
                Node node = (Node)this.nodes.get(i);
                node.setOffset(node.getOffset() - characterCountArgument);
            }
        }
        super.rangeRemoved(offset, characterCountArgument);
    }

    @Override
    public Iterator<Node> iterator() {
        return new ImmutableIterator((Iterator)this.nodes.iterator());
    }

    public void dumpOffsets() {
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = this.get(i);
            System.out.println("[" + i + "] " + node.getOffset() + ":" + node.getCharacterCount());
        }
        System.out.println();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        Font previousFont = this.font;
        if (previousFont != font) {
            this.font = font;
            this.elementListeners.fontChanged(this, previousFont);
        }
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        if (font.startsWith("{")) {
            try {
                this.setFont(Theme.deriveFont(JSONSerializer.parseMap((String)font)));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            this.setFont(Font.decode(font));
        }
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        Color previousForegroundColor = this.foregroundColor;
        if (foregroundColor != previousForegroundColor) {
            this.foregroundColor = foregroundColor;
            this.elementListeners.foregroundColorChanged(this, previousForegroundColor);
        }
    }

    public void setForegroundColor(String foregroundColor) {
        if (foregroundColor == null) {
            throw new IllegalArgumentException("foregroundColor is null.");
        }
        this.setForegroundColor(GraphicsUtilities.decodeColor(foregroundColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        Color previousBackgroundColor = this.backgroundColor;
        if (backgroundColor != previousBackgroundColor) {
            this.backgroundColor = backgroundColor;
            this.elementListeners.backgroundColorChanged(this, previousBackgroundColor);
        }
    }

    public void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        boolean previousUnderline = this.underline;
        if (previousUnderline != underline) {
            this.underline = underline;
            this.elementListeners.underlineChanged(this);
        }
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(boolean strikethrough) {
        boolean previousStrikethrough = this.strikethrough;
        if (previousStrikethrough != strikethrough) {
            this.strikethrough = strikethrough;
            this.elementListeners.strikethroughChanged(this);
        }
    }

    public ListenerList<ElementListener> getElementListeners() {
        return this.elementListeners;
    }

    private static class ElementListenerList
    extends ListenerList<ElementListener>
    implements ElementListener {
        private ElementListenerList() {
        }

        @Override
        public void nodeInserted(Element element, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.nodeInserted(element, index);
            }
        }

        @Override
        public void nodesRemoved(Element element, int index, Sequence<Node> nodes) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.nodesRemoved(element, index, nodes);
            }
        }

        @Override
        public void fontChanged(Element element, Font previousFont) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.fontChanged(element, previousFont);
            }
        }

        @Override
        public void backgroundColorChanged(Element element, Color previousBackgroundColor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.backgroundColorChanged(element, previousBackgroundColor);
            }
        }

        @Override
        public void foregroundColorChanged(Element element, Color previousForegroundColor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.foregroundColorChanged(element, previousForegroundColor);
            }
        }

        @Override
        public void underlineChanged(Element element) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.underlineChanged(element);
            }
        }

        @Override
        public void strikethroughChanged(Element element) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ElementListener listener = (ElementListener)i$.next();
                listener.strikethroughChanged(element);
            }
        }
    }
}

