/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.validation;

import java.util.Locale;
import org.apache.pivot.wtk.validation.DoubleValidator;

public class DoubleRangeValidator
extends DoubleValidator {
    private double minValue;
    private double maxValue;

    public DoubleRangeValidator() {
        this.minValue = -4.9E-324;
        this.maxValue = Double.MAX_VALUE;
    }

    public DoubleRangeValidator(Locale locale) {
        super(locale);
        this.minValue = -1.7976931348623157E308;
        this.maxValue = Double.MAX_VALUE;
    }

    public DoubleRangeValidator(double minValue, double maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public DoubleRangeValidator(Locale locale, double minValue, double maxValue) {
        super(locale);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public double getMinimum() {
        return this.minValue;
    }

    public void setMinimum(double minValue) {
        this.minValue = minValue;
    }

    public double getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public boolean isValid(String text) {
        boolean valid = false;
        if (super.isValid(text)) {
            double f = this.textToObject(text);
            valid = f >= this.minValue && f <= this.maxValue;
        }
        return valid;
    }

    private final Double textToObject(String text) {
        return this.parseNumber(text).doubleValue();
    }
}

