/*
 * Decompiled with CFR 0.152.
 */
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class InsecureHttpClientFactory {
    DefaultHttpClient hc;
    protected Logger log = Logger.getLogger(this.getClass());

    public DefaultHttpClient buildHttpClient() {
        this.hc = new DefaultHttpClient();
        this.configureCookieStore();
        this.configureSSLHandling();
        return this.hc;
    }

    private void configureProxy() {
        HttpHost proxy = new HttpHost("proxy.example.org", 3182);
        this.hc.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    private void configureCookieStore() {
        BasicCookieStore cStore = new BasicCookieStore();
        this.hc.setCookieStore((CookieStore)cStore);
    }

    private void configureSSLHandling() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        SSLSocketFactory sf = this.buildSSLSocketFactory();
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)sf);
        SchemeRegistry sr = this.hc.getConnectionManager().getSchemeRegistry();
        sr.register(http);
        sr.register(https);
    }

    private SSLSocketFactory buildSSLSocketFactory() {
        TrustStrategy ts = new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                return true;
            }
        };
        SSLSocketFactory sf = null;
        try {
            sf = new SSLSocketFactory(ts, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyManagementException e) {
            this.log.error((Object)"Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (KeyStoreException e) {
            this.log.error((Object)"Failed to initialize SSL handling.", (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            this.log.error((Object)"Failed to initialize SSL handling.", (Throwable)e);
        }
        return sf;
    }
}

