/*
 * Decompiled with CFR 0.152.
 */
package controller;

import app.FXSmartCardVerify;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.tasks.OpenIDLoginVerificationTask;

public class FXSMARTCARDUIController
implements Initializable {
    private String webparams;
    private Stage stage;
    private static final Logger logger = Logger.getLogger(FXSMARTCARDUIController.class);
    @FXML
    private Parent root;
    @FXML
    private PasswordField tfPin;
    @FXML
    private ProgressIndicator pbLogin;
    @FXML
    private Button btnVerification;

    public void initialize(URL url, ResourceBundle rb) {
        this.pbLogin.setVisible(false);
        this.btnVerification.setDisable(true);
        this.tfPin.setEditable(true);
    }

    public Parent getRoot() {
        return this.root;
    }

    public void setRoot(Parent root) {
        this.root = root;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public String getWebparams() {
        return this.webparams;
    }

    public void setWebparams(String webparams) {
        this.webparams = webparams;
    }

    private void showMsg(String message, String title, int msgicon) {
        MessageBox.show((Window)this.stage, (String)message, (String)title, (int)msgicon);
    }

    @FXML
    private void doVerifySmartCard(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbLogin.setProgress(-1.0);
        String password = this.tfPin.getText();
        logger.debug((Object)("\u8f38\u5165\u7684PIN\u78bc\u662f:\n" + password));
        final OpenIDLoginVerificationTask task = new OpenIDLoginVerificationTask(password);
        task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXSMARTCARDUIController.this.btnVerification.setDisable(true);
                FXSMARTCARDUIController.this.pbLogin.setVisible(true);
                FXSMARTCARDUIController.this.tfPin.setEditable(false);
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXSMARTCARDUIController.this.pbLogin.setVisible(false);
                JSONObject result = (JSONObject)task.getValue();
                FXSMARTCARDUIController.this.btnVerification.setDisable(false);
                FXSMARTCARDUIController.this.tfPin.setEditable(true);
                if (logger.isDebugEnabled()) {
                    TCCertUtil.listJson(result);
                }
                try {
                    if (result.getString("cardtype").equals("NULL")) {
                        MESSAGE msg = (MESSAGE)((Object)result.get("result"));
                        FXSMARTCARDUIController.this.showMsg(TCCertUtil.getMessage(msg), "\u6191\u8b49\u9a57\u8b49\u932f\u8aa4", 0x2000000);
                    } else {
                        String post = "setForm('" + StringEscapeUtils.unescapeEcmaScript((String)result.toString()) + "')";
                        logger.debug((Object)("\u547c\u53eb\u7684JS:\n" + post));
                        FXSmartCardVerify.getInstance().testJS(post);
                    }
                }
                catch (JSONException ex) {
                    logger.error((Object)ex);
                }
            }
        });
        task.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXSMARTCARDUIController.this.pbLogin.setVisible(false);
                JSONObject result = (JSONObject)task.getValue();
                FXSMARTCARDUIController.this.btnVerification.setDisable(true);
                FXSMARTCARDUIController.this.tfPin.setEditable(true);
                if (result == null) {
                    FXSMARTCARDUIController.this.showMsg("\u6191\u8b49\u9a57\u8b49\u5931\u6557", "\u9a57\u8b49\u5931\u6557", 0x1000000);
                }
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }

    @FXML
    private void enableVerify(KeyEvent event) {
        if (this.tfPin.getText().isEmpty()) {
            this.btnVerification.setDisable(true);
        } else {
            this.btnVerification.setDisable(false);
        }
    }
}

