/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import utils.HandheldStudMoveInSchema;
import utils.TCCertUtil;

public class testHandheldAppsRestClient {
    public static void main(String[] args) throws UnsupportedEncodingException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost request = new HttpPost("https://oidc.tc.edu.tw/handheld/stud-move-in-data");
        request.setHeader("Authorization", TCCertUtil.authorizationHeader("api", "oidcuser"));
        HandheldStudMoveInSchema schema = testHandheldAppsRestClient.getPostData();
        JSONObject obj = new JSONObject((Object)schema);
        System.out.println(obj.toString());
        StringEntity input = new StringEntity(obj.toString(), "UTF-8");
        input.setContentType("application/json");
        request.setEntity((HttpEntity)input);
        CloseableHttpResponse response = client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() != 200) {
            System.out.println("Failed : HTTP error code : " + response.getStatusLine().getStatusCode());
        } else {
            String output;
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
            System.out.println("Output from Server .... \n");
            while ((output = br.readLine()) != null) {
                System.out.println(output);
            }
        }
    }

    private static HandheldStudMoveInSchema getPostData() {
        HandheldStudMoveInSchema schema = new HandheldStudMoveInSchema();
        schema.setClientid("D1371694DEDB4D28A09133DCF90545E5");
        String jodatime = TCCertUtil.getCurrentDateTime();
        schema.setRequesttime(jodatime);
        schema.setYear("101");
        schema.setSemester("2");
        schema.setUserid("front713");
        schema.setUserpassword("dragon2k9");
        ArrayList<String> datas = new ArrayList<String>();
        datas.add(schema.getClientid());
        datas.add(schema.getYear());
        datas.add(schema.getSemester());
        datas.add(schema.getUserid());
        datas.add(schema.getUserpassword());
        String digest = TCCertUtil.getHandheldDigest(jodatime, datas);
        System.out.println(digest);
        schema.setDigest(digest);
        return schema;
    }
}

