/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import utils.ExchangeKey;
import utils.ExchangeKeyTypes;
import utils.TCCertUtil;
import utils.TrustStoreFromClient;

public abstract class EncryptedContent {
    private static final Logger logger = Logger.getLogger(EncryptedContent.class);
    private Map<ExchangeKeyTypes, Object> mapserverdhkey;
    private DHParameterSpec servParamSpec;
    private final String postUrl;
    private String phppk;
    private KeyPair servKP;
    private String servPub;
    private String content;
    private byte[] servSecret;
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient asyncClient;
    private String sessionid;
    private String cookie_sch_id;
    private String useragent;
    private HttpPost httpPost;
    private String aeskey;

    public String getCookie_sch_id() {
        return this.cookie_sch_id;
    }

    public void setCookie_sch_id(String cookie_sch_id) {
        this.cookie_sch_id = cookie_sch_id;
    }

    public String getPostUrl() {
        return this.postUrl;
    }

    public Map<ExchangeKeyTypes, Object> getMapserverdhkey() {
        return this.mapserverdhkey;
    }

    public void setMapserverdhkey(Map<ExchangeKeyTypes, Object> mapserverdhkey) {
        this.mapserverdhkey = mapserverdhkey;
    }

    public DHParameterSpec getServParamSpec() {
        return this.servParamSpec;
    }

    public void setServParamSpec(DHParameterSpec servParamSpec) {
        this.servParamSpec = servParamSpec;
    }

    public String getPhppk() {
        return this.phppk;
    }

    public void setPhppk(String phppk) {
        this.phppk = phppk;
    }

    public KeyPair getServKP() {
        return this.servKP;
    }

    public void setServKP(KeyPair servKP) {
        this.servKP = servKP;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getServPub() {
        return this.servPub;
    }

    public void setServPub(String servPub) {
        this.servPub = servPub;
    }

    public byte[] getServSecret() {
        return this.servSecret;
    }

    public void setServSecret(byte[] servSecret) {
        this.servSecret = servSecret;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpAsyncClient getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(CloseableHttpAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public String getAeskey() {
        return this.aeskey;
    }

    public void setAeskey(String aeskey) {
        this.aeskey = aeskey;
    }

    public HttpPost getHttpPost() {
        return this.httpPost;
    }

    public void setHttpPost(HttpPost httpPost) {
        this.httpPost = httpPost;
    }

    public EncryptedContent(String url, String sessionid, String useragent, String cookie_sch_id) {
        this.postUrl = url;
        this.sessionid = sessionid;
        this.useragent = useragent;
        this.cookie_sch_id = cookie_sch_id;
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String path = AccessController.doPrivileged(new TrustStoreFromClient());
            logger.info((Object)("Trust Store : " + path));
            trustStore.load(new FileInputStream(path), "changeit".toCharArray());
            HttpClientBuilder builder = HttpClientBuilder.create();
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("default").setConnectTimeout(3600).setConnectionRequestTimeout(360000).setSocketTimeout(360000).build();
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie session_cookie = new BasicClientCookie("PHPSESSID", sessionid);
            session_cookie.setDomain(TCCertUtil.getDomainName(this.postUrl));
            session_cookie.setPath("/");
            BasicClientCookie schoolid_cookie = new BasicClientCookie("cookie_sch_id", cookie_sch_id);
            schoolid_cookie.setDomain(TCCertUtil.getDomainName(this.postUrl));
            schoolid_cookie.setPath("/");
            cookieStore.addCookie((Cookie)session_cookie);
            cookieStore.addCookie((Cookie)schoolid_cookie);
            this.setHttpClient(builder.setSslcontext(sslcontext).setSSLHostnameVerifier((HostnameVerifier)new NullHostnameVerifier()).setDefaultRequestConfig(globalConfig).setDefaultCookieStore((CookieStore)cookieStore).build());
            HttpAsyncClientBuilder asyncBuilder = HttpAsyncClientBuilder.create();
            SSLIOSessionStrategy sslSessionStrategy = new SSLIOSessionStrategy(sslcontext, (HostnameVerifier)new NullHostnameVerifier());
            ConnectionConfig connConfig = ConnectionConfig.custom().setBufferSize(0x100000).build();
            this.setAsyncClient(asyncBuilder.setSSLStrategy((SchemeIOSessionStrategy)sslSessionStrategy).setDefaultRequestConfig(globalConfig).setDefaultConnectionConfig(connConfig).setDefaultCookieStore((CookieStore)cookieStore).setMaxConnPerRoute(1).setMaxConnTotal(1).build());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            logger.debug((Object)ex);
        }
        this.httpPost = new HttpPost(this.postUrl);
        this.httpPost.setHeader("User-Agent", useragent);
    }

    public void setSessionid(String sessionid) {
        this.sessionid = sessionid;
    }

    public String getSessionid() {
        return this.sessionid;
    }

    public byte[] getSecretKey() {
        return this.servSecret;
    }

    protected abstract void init();

    protected void getDHKey() {
        try {
            this.mapserverdhkey = ExchangeKey.generateServerDHKey();
            this.servParamSpec = (DHParameterSpec)this.mapserverdhkey.get((Object)ExchangeKeyTypes.DHParameterSpec);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String performKeyExchangePost() {
        String responseString = null;
        BigInteger servp = this.servParamSpec.getP();
        BigInteger servg = this.servParamSpec.getG();
        this.servKP = (KeyPair)this.mapserverdhkey.get((Object)ExchangeKeyTypes.ServerPublicKeyPair);
        this.servPub = (String)this.mapserverdhkey.get((Object)ExchangeKeyTypes.ServerPublicKey);
        ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
        pairList.add(new BasicNameValuePair("sid", this.sessionid));
        pairList.add(new BasicNameValuePair("getkey", "true"));
        pairList.add(new BasicNameValuePair("serverp", servp.toString()));
        pairList.add(new BasicNameValuePair("serverg", servg.toString()));
        pairList.add(new BasicNameValuePair("serverpk", this.servPub));
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairList, "UTF-8");
            this.httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.httpPost);
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            logger.debug((Object)("PHP Response : " + responseString));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex);
        }
        finally {
            return responseString;
        }
    }

    private class NullHostnameVerifier
    implements HostnameVerifier {
        private NullHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    }
}

