/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import utils.ExchangeKeyTypes;

public class ExchangeKey {
    private static final Logger logger = Logger.getLogger(ExchangeKey.class);

    public static Map<ExchangeKeyTypes, Object> generateServerDHKey() throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException {
        HashMap<ExchangeKeyTypes, Object> dhkeyspecs = new HashMap<ExchangeKeyTypes, Object>();
        AlgorithmParameterGenerator servAPG = AlgorithmParameterGenerator.getInstance("DH");
        servAPG.init(1024);
        DHParameterSpec servParamSpec = servAPG.generateParameters().getParameterSpec(DHParameterSpec.class);
        BigInteger servp = servParamSpec.getP();
        BigInteger servg = servParamSpec.getG();
        logger.debug((Object)("\nServer P : " + servp.toString() + "\nServer G : " + servg.toString()));
        KeyPairGenerator servKPG = KeyPairGenerator.getInstance("DH");
        servKPG.initialize(servParamSpec);
        KeyPair servKP = servKPG.generateKeyPair();
        String servPub = new String(Base64.encodeBase64(((DHPublicKey)servKP.getPublic()).getY().toByteArray()));
        logger.debug((Object)("\nServer Public Key : " + servPub));
        dhkeyspecs.put(ExchangeKeyTypes.DHParameterSpec, servParamSpec);
        dhkeyspecs.put(ExchangeKeyTypes.ServerPublicKey, servPub);
        dhkeyspecs.put(ExchangeKeyTypes.ServerPublicKeyPair, servKP);
        return dhkeyspecs;
    }

    public static byte[] generateShareKey(String phpresponsestring, DHParameterSpec servParamSpec, KeyPair servKP) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] phppk = Base64.decodeBase64(phpresponsestring);
        logger.debug((Object)("PHP Public Key : " + phpresponsestring));
        BigInteger y = new BigInteger(phppk);
        BigInteger serverp = servParamSpec.getP();
        BigInteger serverg = servParamSpec.getG();
        DHPublicKeySpec dhPublicKeySpec = new DHPublicKeySpec(y, serverp, serverg);
        DHPublicKey servCliPub = (DHPublicKey)KeyFactory.getInstance("DH").generatePublic(dhPublicKeySpec);
        KeyAgreement servKA = KeyAgreement.getInstance("DH");
        servKA.init((Key)servKP.getPrivate(), servParamSpec);
        servKA.doPhase(servCliPub, true);
        byte[] servSecret = servKA.generateSecret();
        logger.debug((Object)("Server Secret Key:" + Base64.encodeBase64String(servSecret)));
        return servSecret;
    }

    public static String generateAESKey(byte[] dhsecretkey) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(Base64.encodeBase64(dhsecretkey));
        byte[] aes = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < aes.length; ++i) {
            String hex = Integer.toHexString(0xFF & aes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String aeskey = hexString.toString();
        logger.debug((Object)("AES Key : " + aeskey));
        return aeskey;
    }

    public static String generateDecryptedContent(String encryptedphpresponsestring, byte[] aeskey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SecretKeySpec skey = new SecretKeySpec(aeskey, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, skey);
        byte[] output = cipher.doFinal(Base64.decodeBase64(encryptedphpresponsestring));
        logger.debug((Object)("\u660e\u78bc\u4ea4\u63db\u6a94\u6848\u3000: " + new String(output, "UTF-8")));
        return new String(output, "UTF-8");
    }
}

