/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import utils.EncryptedContent;
import utils.ExchangeKey;
import utils.ExchangeKeyTypes;

public class SFS3EncryptedStudMove
extends EncryptedContent
implements PrivilegedAction<Map<ExchangeKeyTypes, String>> {
    private static final Logger logger = Logger.getLogger(SFS3EncryptedStudMove.class);
    private String currseme;
    private String submit_ip;
    private String upload_id;

    public SFS3EncryptedStudMove(String url, String sessionid, String useragent, String currseme, String submit_ip, String upload_id) {
        super(url, sessionid, useragent, "DEFAULT");
        this.currseme = currseme;
        this.submit_ip = submit_ip;
        this.upload_id = upload_id;
        this.init();
    }

    public String getSubmit_ip() {
        return this.submit_ip;
    }

    public void setSubmit_ip(String submit_ip) {
        this.submit_ip = submit_ip;
    }

    public String getUpload_id() {
        return this.upload_id;
    }

    public void setUpload_id(String upload_id) {
        this.upload_id = upload_id;
    }

    public void setCurrseme(String seme) {
        this.currseme = seme;
    }

    public String getCurrseme() {
        return this.currseme;
    }

    @Override
    protected final void init() {
        this.getDHKey();
        this.setPhppk(this.performKeyExchangePost());
        this.performPostXML(this.currseme);
    }

    private void performPostXML(String curr_seme) {
        String output = null;
        try {
            byte[] servSecret = ExchangeKey.generateShareKey(this.getPhppk(), this.getServParamSpec(), this.getServKP());
            logger.debug((Object)("Server Secret Key:" + Base64.encodeBase64String(servSecret)));
            ArrayList<BasicNameValuePair> pair = new ArrayList<BasicNameValuePair>();
            pair.add(new BasicNameValuePair("sid", this.getSessionid()));
            pair.add(new BasicNameValuePair("getkey", "false"));
            pair.add(new BasicNameValuePair("curr_seme", curr_seme));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pair, "UTF-8");
            HttpPost httpPost = this.getHttpPost();
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpClient demo = this.getHttpClient();
            CloseableHttpResponse response = demo.execute((HttpUriRequest)httpPost);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            this.setContent(responseString);
            logger.info((Object)("PHP Response 2 :" + this.getContent()));
            this.setAeskey(ExchangeKey.generateAESKey(servSecret));
            String aeskey = this.getAeskey();
            if (logger.isDebugEnabled()) {
                output = ExchangeKey.generateDecryptedContent(responseString, aeskey.getBytes());
                logger.debug((Object)("\u89e3\u78bc\u5f8c : " + output));
            }
        }
        catch (InvalidKeyException ex) {
            logger.error((Object)ex);
            this.init();
        }
        catch (Exception ex) {
            logger.info((Object)ex);
        }
    }

    @Override
    public Map<ExchangeKeyTypes, String> run() {
        EnumMap<ExchangeKeyTypes, String> cypher = new EnumMap<ExchangeKeyTypes, String>(ExchangeKeyTypes.class);
        cypher.put(ExchangeKeyTypes.ShareAESKey, this.getAeskey());
        logger.debug((Object)("Return EncryptedXML : " + this.getContent()));
        cypher.put(ExchangeKeyTypes.EncryptedContent, this.getContent());
        return cypher;
    }
}

