/*
 * Decompiled with CFR 0.152.
 */
package security;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import security.ExchangeKeyTypes;

public class ExchangeKey {
    private static final Logger a = Logger.getLogger(ExchangeKey.class);

    public static Map generateServerDHKey() throws NoSuchAlgorithmException, InvalidParameterSpecException, InvalidAlgorithmParameterException {
        HashMap<ExchangeKeyTypes, Object> hashMap = new HashMap<ExchangeKeyTypes, Object>();
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("DH");
        algorithmParameterGenerator.init(1024);
        DHParameterSpec dHParameterSpec = algorithmParameterGenerator.generateParameters().getParameterSpec(DHParameterSpec.class);
        BigInteger bigInteger = dHParameterSpec.getP();
        BigInteger bigInteger2 = dHParameterSpec.getG();
        a.debug((Object)("\nServer P : " + bigInteger.toString() + "\nServer G : " + bigInteger2.toString()));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
        keyPairGenerator.initialize(dHParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String string = Base64.encodeBase64String((byte[])((DHPublicKey)keyPair.getPublic()).getY().toByteArray());
        a.debug((Object)("\nServer Public Key : " + string));
        hashMap.put(ExchangeKeyTypes.DHParameterSpec, dHParameterSpec);
        hashMap.put(ExchangeKeyTypes.PublicKey, string);
        hashMap.put(ExchangeKeyTypes.PublicKeyPair, keyPair);
        hashMap.put(ExchangeKeyTypes.P, bigInteger.toString());
        hashMap.put(ExchangeKeyTypes.G, bigInteger2.toString());
        return hashMap;
    }

    public static Map generateClientDHKey(String string, String string2, String string3) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        HashMap<ExchangeKeyTypes, Object> hashMap = new HashMap<ExchangeKeyTypes, Object>();
        BigInteger bigInteger = new BigInteger(Base64.decodeBase64((String)string3));
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        BigInteger bigInteger2 = new BigInteger(string);
        BigInteger bigInteger3 = new BigInteger(string2);
        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, bigInteger2, bigInteger3);
        DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
        a.debug((Object)("Server Public Key from client :\n" + Base64.encodeBase64String((byte[])dHPublicKey.getY().toByteArray())));
        a.debug((Object)("\nServer P : " + bigInteger2.toString() + "\nServer G : " + bigInteger3.toString()));
        DHParameterSpec dHParameterSpec = new DHParameterSpec(bigInteger2, bigInteger3);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
        keyPairGenerator.initialize(dHParameterSpec);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String string4 = Base64.encodeBase64String((byte[])((DHPublicKey)keyPair.getPublic()).getY().toByteArray());
        a.debug((Object)("\nClient Public Key : " + string4));
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init((Key)keyPair.getPrivate(), dHParameterSpec);
        keyAgreement.doPhase(dHPublicKey, true);
        byte[] byArray = keyAgreement.generateSecret();
        a.debug((Object)("Sahred Secret Key:\n" + Base64.encodeBase64String((byte[])byArray)));
        hashMap.put(ExchangeKeyTypes.DHParameterSpec, dHParameterSpec);
        hashMap.put(ExchangeKeyTypes.PublicKey, string4);
        hashMap.put(ExchangeKeyTypes.PublicKeyPair, keyPair);
        hashMap.put(ExchangeKeyTypes.ShareSecretKey, Base64.encodeBase64String((byte[])byArray));
        hashMap.put(ExchangeKeyTypes.ShareAESKey, ExchangeKey.generateAESKey(byArray));
        return hashMap;
    }

    public static byte[] generateShareKey(String string, DHParameterSpec dHParameterSpec, KeyPair keyPair) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, InvalidAlgorithmParameterException {
        BigInteger bigInteger = new BigInteger(Base64.decodeBase64((String)string));
        KeyFactory keyFactory = KeyFactory.getInstance("DH");
        DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(bigInteger, dHParameterSpec.getP(), dHParameterSpec.getG());
        DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(dHPublicKeySpec);
        a.debug((Object)("Client Public Key from server :\n" + Base64.encodeBase64String((byte[])dHPublicKey.getY().toByteArray())));
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init((Key)keyPair.getPrivate(), dHParameterSpec);
        keyAgreement.doPhase(dHPublicKey, true);
        byte[] byArray = keyAgreement.generateSecret();
        a.debug((Object)("Shared Secret Key:\n" + Base64.encodeBase64String((byte[])byArray)));
        return byArray;
    }

    public static String generateAESKey(byte[] byArray, String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        messageDigest.update(Base64.encodeBase64((byte[])byArray));
        byte[] byArray2 = messageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray2.length; ++i) {
            String string2 = Integer.toHexString(0xFF & byArray2[i]);
            if (string2.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        String string3 = stringBuilder.toString();
        a.debug((Object)("AES Key : " + string3));
        return string3;
    }

    public static String generateAESKey(byte[] byArray) throws NoSuchAlgorithmException {
        return ExchangeKey.generateAESKey(byArray, "MD5");
    }

    public static String generateAESKey(String string) throws NoSuchAlgorithmException {
        byte[] byArray = Base64.decodeBase64((String)string);
        return ExchangeKey.generateAESKey(byArray);
    }

    public static String generateAESKey(String string, String string2) throws NoSuchAlgorithmException {
        byte[] byArray = Base64.decodeBase64((String)string);
        return ExchangeKey.generateAESKey(byArray, string2);
    }

    public static String generateDecryptedContent(String string, byte[] byArray) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, secretKeySpec);
        byte[] byArray2 = cipher.doFinal(Base64.decodeBase64((String)string));
        a.debug((Object)("Plain text\u3000: " + new String(byArray2, "UTF-8")));
        return new String(byArray2, "UTF-8");
    }
}

