/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import utils.TrustStoreFromClient;

public class testRestClient {
    private static String url = "https://oidc.tc.edu.tw/api/SrDb";
    private static final Logger logger = Logger.getLogger(testRestClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (CloseableHttpClient demo = null;){
            HttpGet httpget = new HttpGet(url);
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                String path = AccessController.doPrivileged(new TrustStoreFromClient());
                logger.debug((Object)("Trust Store : " + path));
                trustStore.load(new FileInputStream(path), "changeit".toCharArray());
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                StrictHostnameVerifier shv = new StrictHostnameVerifier();
                String[] cns = new String[]{"oidc.tc.edu.tw"};
                shv.verify("oidc.tc.edu.tw", cns, cns);
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                RequestConfig globalConfig = RequestConfig.custom().setCookieSpec("compatibility").build();
                demo = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultRequestConfig(globalConfig).build();
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                logger.debug((Object)ex);
            }
            System.out.println("Executing request " + httpget.getRequestLine());
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String responseBody = (String)demo.execute((HttpUriRequest)httpget, (ResponseHandler)responseHandler);
            System.out.println("----------------------------------------");
            System.out.println(responseBody);
        }
    }
}

