/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.json.JSONException;
import org.json.JSONObject;
import sun.security.provider.certpath.OCSP;
import utils.CertificateDN;
import utils.MESSAGE;

public class TCCertUtil {
    public static final String CERTTPEXCA = "XCA";
    public static final String CERTYPEMOICA = "MOICA";
    public static final String CERTYPEGCA = "GCA";
    public static final String ERROR_NULL = "NULL";
    public static final String XCA_DOWNLOAD_URL = "http://xca.nat.gov.tw/PEXE_XCA/DownLoadCert.CEXE?CertNo=";
    public static final String GCA_DOWNLOAD_URL = "http://gca.nat.gov.tw/PEXE_GCA4/DownLoadCert.CEXE?CertNo=";
    public static final String MOICA_DOWNLOAD_URL = "http://moica.nat.gov.tw/PEXE_MOICA/DownLoadCert.CEXE?CertNo=";
    public static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss").withZone(DateTimeZone.forID((String)"Asia/Taipei"));
    public static final String STUD_MOVE_UPLOAD_JSON_API_URL = "https://oidc.tc.edu.tw/api/stud-move-upload";
    public static final String STUD_GRADE_UPLOAD_JSON_API_URL = "https://oidc.tc.edu.tw/api/stud-grade-upload";
    public static final String STUD_BASE_UPLOAD_JSON_API_URL = "https://oidc.tc.edu.tw/api/stud-base-upload";
    public static final String ADDRESS_CHANGER_UPLOAD_JSON_API_URL = "https://oidc.tc.edu.tw/sr/household-add-address-changer";
    public static final String STUD_MOVE_SR_UPLOAD_JSON_API_URL = "https://oidc.tc.edu.tw/sr/sr-import-studmove";
    public static final String HANDHELD_CLIENT_SECRET = "{EFCDCDBCF4AA4956BA69AE3EDFE1B9A2}";
    public static final String HANDHELD_CLIENT_ID = "D1371694DEDB4D28A09133DCF90545E5";
    private static final Logger logger = Logger.getLogger(TCCertUtil.class);
    public static final String BYPASS_CERT_NOT_REG = "000000";
    public static final String BROWSE_STUDENT = "\u5b78\u7c4d\u8cc7\u6599\u700f\u89bd";
    public static final String BROWSE_STUDMOVE = "\u7570\u52d5\u8cc7\u6599\u700f\u89bd";
    public static final String BROWSE_CHASE = "\u8ffd\u8e64\u8a18\u9304\u700f\u89bd";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(String url) {
        String domainname = "";
        try {
            URI uri = new URI(url);
            String domain = uri.getHost();
            domainname = domain.startsWith("www.") ? domain.substring(4) : domain;
            return domainname;
        }
        catch (URISyntaxException ex) {
            logger.error((Object)ex);
        }
        finally {
            return domainname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHandheldDigest(String jodatime, List<String> datas) {
        String digest = null;
        try {
            String rawdata = TCCertUtil.generateSignData(jodatime, datas);
            logger.debug((Object)("HANDHELD RAWDATA : " + rawdata));
            String aeskey = TCCertUtil.generateAESKey(HANDHELD_CLIENT_SECRET);
            logger.debug((Object)("HANDHELD AESKEY : " + aeskey));
            String encrypted = TCCertUtil.AESEncrypt(rawdata, aeskey);
            logger.debug((Object)("HANDHELD ENCRYPTED : " + encrypted));
            digest = TCCertUtil.generateSignDataDigest(encrypted);
            logger.debug((Object)("HANDHELD ENCRYPTED DIGEST : " + digest));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            logger.error((Object)ex);
        }
        finally {
            return digest;
        }
    }

    public static String generateAESKey(String sharedsceret) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(sharedsceret.getBytes("UTF-8"));
        byte[] aes = md.digest();
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < aes.length; ++i) {
            String hex = Integer.toHexString(0xFF & aes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        String aeskey = hexString.toString();
        logger.debug((Object)("AES Key : " + aeskey));
        return aeskey;
    }

    public static String AESEncrypt(String input, String key) {
        byte[] crypted = null;
        try {
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, skey);
            crypted = cipher.doFinal(input.getBytes("UTF-8"));
            logger.debug((Object)("\u539f\u59cb : " + input + " -- \u52a0\u5bc6\u5f8c : " + Base64.encodeBase64String(crypted)));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Object)e.toString());
        }
        return Base64.encodeBase64String(crypted);
    }

    public static String AESDecrypt(String base64input, String key) {
        byte[] output = null;
        String decrypted = "";
        try {
            logger.debug((Object)("Secret Key (AES Key) : " + key));
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skey);
            output = cipher.doFinal(Base64.decodeBase64(base64input));
            logger.debug((Object)("Input : " + base64input + " \n->(decrypt)->\n" + new String(output, "UTF-8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            logger.error((Object)e);
        }
        try {
            decrypted = new String(output, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            logger.error((Object)ex);
        }
        return decrypted;
    }

    public static String getSerialNumberFromHex(byte[] raw) {
        logger.debug((Object)("RAW SMARTCARD BASE64 CARDNUMBER:" + Base64.encodeBase64String(raw)));
        if (raw == null) {
            return null;
        }
        String HEXES = "0123456789ABCDEF";
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append("0123456789ABCDEF".charAt((b & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(b & 0xF));
        }
        String signserial = hex.toString();
        if (signserial.startsWith("00")) {
            signserial = signserial.substring(2);
        }
        return signserial;
    }

    public static void listJson(JSONObject json) {
        Iterator it = json.keys();
        while (it.hasNext()) {
            String key = it.next().toString();
            try {
                logger.debug((Object)("key : " + key + " ; value : " + json.getString(key)));
            }
            catch (JSONException ex) {
                try {
                    logger.debug((Object)("key : " + key + " ; value : " + (Object)((Object)((MESSAGE)((Object)json.get(key))))));
                }
                catch (JSONException ex1) {
                    logger.error((Object)ex1);
                }
            }
        }
    }

    public static String getMessage(MESSAGE msg) {
        String result = "";
        switch (msg) {
            case CERTERROR_READER_NOT_EXIST: {
                result = "\u8acb\u78ba\u8a8d\u8b80\u5361\u6a5f\u5df2\u63d2\u5165\u3002";
                break;
            }
            case CERTERROR_CARD_NOT_EXIST: {
                result = "\u8acb\u78ba\u8a8d\u5df2\u63d2\u5165\u5361\u7247\u3002";
                break;
            }
            case CERT_CHECK_SUCCESS: {
                result = "\u6191\u8b49\u5df2\u78ba\u8a8d\u6210\u529f\u3002";
                break;
            }
            case CERTERROR_EXCEPTION: {
                result = "\u767c\u751f\u5176\u4ed6\u4f8b\u5916\u72c0\u6cc1\u3002";
                break;
            }
            case CERTERROR_NOT_XCA: {
                result = "\u8acb\u78ba\u8a8d\u60a8\u63d2\u5165\u7684\u662fXCA\u5361\u7247\u3002";
                break;
            }
            case CERTERROR_NOT_REG_XCA: {
                result = "\u6b64\u5361\u7247\u975e\u4ea4\u63db\u5e73\u53f0\u4e0a\u6240\u8a3b\u518a\u7684\u5361\u7247\u3002";
                break;
            }
            case CERTERROR_OCSP_VERIFY_FAILED: {
                result = "OCSP\u67e5\u6838\u7d50\u679c\u986f\u793a\u672c\u5361\u7247\u5df2\u5931\u6548\uff01";
                break;
            }
            case CERTERROR_OCSP_SERVER_CONNECT_FAILED: {
                result = "OCSP\u4e3b\u6a5f\u76ee\u524d\u7121\u6cd5\u9023\u7dda\uff0c\u8acb\u7a0d\u5f8c\u518d\u8a66\u3002";
                break;
            }
            case CERTERROR_PINCODE_ERROR: {
                result = "\u60a8\u6240\u8f38\u5165\u7684PIN\u78bc\u932f\u8aa4\uff01";
                break;
            }
            case STUDGRADE_UPLOAD_API_ERROR: 
            case STUDBASE_UPLOAD_API_ERROR: 
            case STUDMOVE_UPLOAD_API_ERROR: {
                result = "\u547c\u53ebWeb API\u767c\u751f\u932f\u8aa4\uff01";
                break;
            }
            case STUDMOVE_UPLOAD_COMPLETED: {
                result = "\u5b78\u751f\u7570\u52d5\u8cc7\u6599\u4e0a\u50b3\u5b8c\u6210\uff01";
                break;
            }
            case STUDGRADE_UPLOAD_COMPLETED: {
                result = "\u7562\u696d\u751f\u8cc7\u6599\u4e0a\u50b3\u5b8c\u6210\uff01";
                break;
            }
            case STUDBASE_UPLOAD_COMPLETED: {
                result = "\u5168\u6821\u5728\u7c4d\u751f\u8cc7\u6599\u4e0a\u50b3\u5b8c\u6210\uff01";
                break;
            }
            case ERROR_UPLOAD_IP: {
                result = "\u8cb4\u6821\u5b78\u52d9\u7cfb\u7d71\u672a\u5c0d\r\nhttps://oidc.tc.edu.tw\r\n\u958b\u653e80\u8207443\u57e0\uff01";
                break;
            }
            case XCA_EXCHANGE_TEST_OK: {
                result = "XCA\u5168\u81ea\u52d5\u4ea4\u63db\u6e2c\u8a66\u6210\u529f\uff01";
                break;
            }
            case XCA_EXCHANGE_TEST_ERROR: {
                result = "XCA\u5168\u81ea\u52d5\u4ea4\u63db\u6e2c\u8a66\u5931\u6557\uff01\u53ef\u80fd\u662f\r\nSFS3\u4e3b\u6a5f\u5c1a\u672a\u5b89\u88ddPHP\u5b89\u5168\u6027\u5957\u4ef6\uff01";
            }
        }
        return result;
    }

    public static void checkSignature(String url, String b64, String rawtext) {
        try {
            int n;
            logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49\u4e0b\u8f09\u4f4d\u5740:\n" + url));
            URL website = new URL(url);
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream bais = new ByteArrayOutputStream();
            InputStream is = website.openStream();
            while ((n = is.read(buffer)) > 0) {
                bais.write(buffer, 0, n);
            }
            bais.flush();
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bais.toByteArray()));
            logger.debug((Object)("Issuer DN : " + cert.getIssuerDN().toString()));
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(cert.getPublicKey());
            sig.update(rawtext.getBytes("UTF-8"));
            logger.info((Object)("Java\u539f\u751f\u51fd\u5f0f\u9a57\u7c3d\u7d50\u679c: " + sig.verify(Base64.decodeBase64(b64))));
        }
        catch (MalformedURLException ex) {
            logger.error((Object)ex);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | CertificateException ex) {
            logger.error((Object)ex);
        }
    }

    public static void checkMOICASignature(X509Certificate cert, String b64, String rawtext) {
        try {
            Signature sig = Signature.getInstance("SHA256withRSA");
            sig.initVerify(cert.getPublicKey());
            logger.debug((Object)("MOICA Issuer DN : " + cert.getIssuerDN().toString()));
            sig.update(rawtext.getBytes("UTF-8"));
            logger.info((Object)("Java\u539f\u751f\u51fd\u5f0fMOICA\u9a57\u7c3d\u7d50\u679c: " + sig.verify(Base64.decodeBase64(b64))));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            logger.error((Object)ex);
        }
    }

    public static String compress(String string) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
        GZIPOutputStream gos = new GZIPOutputStream(os);
        gos.write(string.getBytes());
        gos.close();
        byte[] compressed = os.toByteArray();
        os.close();
        return Base64.encodeBase64String(compressed);
    }

    public static String decompress(String b64string) throws IOException {
        int bytesRead;
        int BUFFER_SIZE = 32;
        byte[] compressed = Base64.decodeBase64(b64string);
        ByteArrayInputStream is = new ByteArrayInputStream(compressed);
        GZIPInputStream gis = new GZIPInputStream((InputStream)is, 32);
        StringBuilder string = new StringBuilder();
        byte[] data = new byte[32];
        while ((bytesRead = gis.read(data)) != -1) {
            string.append(new String(data, 0, bytesRead));
        }
        gis.close();
        is.close();
        return string.toString();
    }

    public static String getCurrentDateTime() {
        DateTime dt = new DateTime();
        String taipei = TCCertUtil.showDateTime(dt);
        logger.debug((Object)("Current Taipei Time : " + taipei));
        return taipei;
    }

    private static String showDateTime(DateTime dt) {
        return formatter.print((ReadableInstant)dt);
    }

    public static String getJODATIME(String datetime) {
        DateTime dt = formatter.parseDateTime(datetime);
        String parsedTime = TCCertUtil.showDateTime(dt);
        logger.debug((Object)("Parse Date Time : " + parsedTime));
        return parsedTime;
    }

    public static String generateSignData(List<String> datas) {
        String data = null;
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = datas.iterator();
        sb.append(TCCertUtil.getCurrentDateTime());
        while (it.hasNext()) {
            sb.append("@");
            sb.append(it.next());
        }
        data = sb.toString();
        logger.debug((Object)("Data To Be Signed : " + data));
        return data;
    }

    public static String generateSignData(String jodatime, List<String> datas) {
        String data = null;
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = datas.iterator();
        sb.append(jodatime);
        while (it.hasNext()) {
            sb.append("@");
            sb.append(it.next());
        }
        data = sb.toString();
        logger.debug((Object)("Data To Be Signed : " + data));
        return data;
    }

    public static String generateSignDataDigest(String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String digest = null;
        MessageDigest md = MessageDigest.getInstance("MD5");
        logger.debug((Object)("Data To Be Signed :\n" + data));
        md.update(data.getBytes("UTF-8"));
        digest = Base64.encodeBase64String(md.digest());
        logger.debug((Object)("BASE64 To Be Signed Data : " + digest));
        return digest;
    }

    public static String generateSignDataDigest(String jodatime, List<String> datas) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String data = TCCertUtil.generateSignData(jodatime, datas);
        String digest = TCCertUtil.generateSignDataDigest(data);
        logger.debug((Object)("To Be Signed Data : " + data + " : " + digest));
        return digest;
    }

    public static String generateSignDataDigest(List<String> datas) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String data = TCCertUtil.generateSignData(datas);
        String digest = TCCertUtil.generateSignDataDigest(data);
        logger.debug((Object)("To Be Signed Data : " + data + " : " + digest));
        return digest;
    }

    public static JSONObject generateUploadStudMoveData(String signserial, String datetime, String zipori, String currseme, String submit_ip, String upload_id, String md5, String signedmd5, String schoolid, String schoolname) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("signserial", signserial);
        result.put("datetime", datetime);
        result.put("stud_move", zipori);
        result.put("curr_seme", currseme);
        result.put("submit_ip", submit_ip);
        result.put("upload_id", upload_id);
        result.put("md5", md5);
        result.put("signedmd5", signedmd5);
        result.put("schoolid", schoolid);
        result.put("schoolname", schoolname);
        JSONObject json = new JSONObject(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u6b32\u4e0a\u50b3\u7684\u5b78\u751f\u7570\u52d5\u8cc7\u6599:");
            TCCertUtil.listJson(json);
        }
        return json;
    }

    public static JSONObject generateUploadStudGradeData(String signserial, String datetime, String zipori, String currseme, String submit_ip, String upload_id, String md5, String signedmd5, String schoolid, String schoolname) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("signserial", signserial);
        result.put("datetime", datetime);
        result.put("stud_grade", zipori);
        result.put("curr_seme", currseme);
        result.put("submit_ip", submit_ip);
        result.put("upload_id", upload_id);
        result.put("md5", md5);
        result.put("signedmd5", signedmd5);
        result.put("schoolid", schoolid);
        result.put("schoolname", schoolname);
        JSONObject json = new JSONObject(result);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u6b32\u4e0a\u50b3\u7684\u7562\u696d\u751f\u8cc7\u6599:");
            TCCertUtil.listJson(json);
        }
        return json;
    }

    public static JSONObject generateUploadStudBaseData(String signserial, String datetime, String zipori, String currseme, String submit_ip, String upload_id, String md5, String signedmd5, String schoolid, String schoolname) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("signserial", signserial);
        result.put("datetime", datetime);
        result.put("stud_base", zipori);
        result.put("curr_seme", currseme);
        result.put("submit_ip", submit_ip);
        result.put("upload_id", upload_id);
        result.put("md5", md5);
        result.put("signedmd5", signedmd5);
        result.put("schoolid", schoolid);
        result.put("schoolname", schoolname);
        JSONObject json = new JSONObject(result);
        TCCertUtil.listJson(json);
        return json;
    }

    public static X509Certificate generateX509FromPEM(String b64pem) throws CertificateException {
        logger.debug((Object)("PEM\n" + b64pem));
        byte[] rawcert = Base64.decodeBase64(b64pem);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(rawcert));
        return cert;
    }

    public static String authorizationHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64(auth.getBytes(Charset.forName("US-ASCII")));
        String authHeader = "Basic " + new String(encodedAuth);
        return authHeader;
    }

    public static InputStream fullStreamFromJar(InputStream ins) throws IOException {
        DataInputStream dis = new DataInputStream(ins);
        byte[] bytes = new byte[dis.available()];
        dis.readFully(bytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return bais;
    }

    public static X509Certificate getCertFromInputStream(InputStream in) {
        X509Certificate cert = null;
        try {
            DataInputStream dis = new DataInputStream(in);
            byte[] bytes = new byte[dis.available()];
            dis.readFully(bytes);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            cert = (X509Certificate)cf.generateCertificate(bais);
        }
        catch (Exception e) {
            logger.error((Object)("Can't construct X509 Certificate. " + e.getMessage()));
        }
        return cert;
    }

    public static OCSP.RevocationStatus.CertStatus verifyXCA2FromOCSP(X509Certificate xca, X509Certificate issuer) throws IOException, CertPathValidatorException {
        return OCSP.check((X509Certificate)xca, (X509Certificate)issuer).getCertStatus();
    }

    public static String parseDN(String dn, CertificateDN type) {
        logger.debug((Object)("DN:\n" + dn));
        String[] dns = dn.split(",");
        String result = "";
        if (dn.contains("\u9644\u5c6c")) {
            String ou = dns[0];
            ou = ou.substring(ou.indexOf("=") + 1);
            String o = dns[1];
            o = o.substring(o.indexOf("=") + 1);
            String schoolname = o + ";" + ou;
            logger.debug((Object)("\u9644\u4e2d:" + schoolname));
            result = schoolname;
        } else if (dn.contains("\u6cd5\u4eba")) {
            String schoolname = dns[0];
            result = schoolname.substring(schoolname.indexOf("=") + 1) + ";" + "\u6cd5\u4eba";
        } else {
            String schoolname = dns[0];
            String district = dns[1];
            String city = dns[2];
            if (logger.isDebugEnabled()) {
                String s = "\u5b78\u6821\u5168\u929c : " + schoolname.substring(schoolname.indexOf("=") + 1) + ";" + district.substring(district.indexOf("=") + 1) + ";" + city.substring(city.indexOf("=") + 1) + ";" + schoolname.substring(schoolname.indexOf("\u570b"));
                logger.debug((Object)s);
            }
            switch (type) {
                case CITY: {
                    result = city.substring(city.indexOf("=") + 1);
                    break;
                }
                case DISTRICT: {
                    result = district.substring(district.indexOf("=") + 1);
                    break;
                }
                case SCHOOL: {
                    result = schoolname.substring(schoolname.indexOf("=") + 1);
                    break;
                }
                case VERIFICATION: {
                    result = schoolname.substring(schoolname.indexOf("=") + 1).concat(";").concat(district.substring(district.indexOf("=") + 1));
                }
            }
        }
        logger.debug((Object)("DN Parsed : " + (Object)((Object)type) + ":" + result));
        return result;
    }
}

