/*
 * Decompiled with CFR 0.152.
 */
package utils.tasks;

import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javafx.concurrent.Task;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.log4j.Logger;
import utils.ExchangeKey;
import utils.ExchangeKeyTypes;
import utils.privileged.SFS3EncryptedStudMove;

public class StudMoveUploadSrTask
extends Task<Boolean> {
    private String sessionid;
    private String currseme;
    private String useragent;
    private String submit_ip;
    private String upload_id;
    private final String postUrl;
    private String ori;
    private static final Logger logger = Logger.getLogger(StudMoveUploadSrTask.class);

    public StudMoveUploadSrTask(String url, String sessionid, String useragent, String currseme) {
        this.postUrl = url;
        this.sessionid = sessionid;
        this.currseme = currseme;
        this.useragent = useragent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean call() throws Exception {
        boolean isUploadSuccess = false;
        Map<ExchangeKeyTypes, String> cypher = AccessController.doPrivileged(new SFS3EncryptedStudMove(this.postUrl, this.sessionid, this.useragent, this.currseme, this.submit_ip, this.upload_id));
        logger.debug((Object)("\u52a0\u5bc6\u5f8c\u5167\u5bb9:" + cypher.get((Object)ExchangeKeyTypes.EncryptedContent)));
        try {
            this.ori = ExchangeKey.generateDecryptedContent(cypher.get((Object)ExchangeKeyTypes.EncryptedContent), cypher.get((Object)ExchangeKeyTypes.ShareAESKey).getBytes());
            return this.ori;
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            logger.error((Object)ex.getMessage());
        }
        finally {
            return isUploadSuccess;
        }
    }
}

