/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.tasks.StudGradeUploadTask;

public class FXStudGradeUploadController
implements Initializable {
    private String webparams;
    private Stage stage;
    private static final Logger logger = Logger.getLogger(FXStudGradeUploadController.class);
    private String session_id;
    private String curr_seme;
    private String useragent;
    private String targetpage;
    private String upload_id;
    private String submit_ip;
    @FXML
    private AnchorPane root;
    @FXML
    private PasswordField tfPin;
    @FXML
    private ProgressIndicator pbStudGradeUpload;
    @FXML
    private Button btnStudGradeUpload;

    public String getCurr_seme() {
        return this.curr_seme;
    }

    public void setCurr_seme(String curr_seme) {
        this.curr_seme = curr_seme;
    }

    public String getWebparams() {
        return this.webparams;
    }

    public void setWebparams(String webparams) {
        this.webparams = webparams;
        logger.debug((Object)webparams);
        this.parseWebParams();
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public String getSession_id() {
        return this.session_id;
    }

    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public String getTargetpage() {
        return this.targetpage;
    }

    public void setTargetpage(String targetpage) {
        this.targetpage = targetpage;
    }

    public String getUpload_id() {
        return this.upload_id;
    }

    public void setUpload_id(String upload_id) {
        this.upload_id = upload_id;
    }

    public String getSubmit_ip() {
        return this.submit_ip;
    }

    public void setSubmit_ip(String submit_ip) {
        this.submit_ip = submit_ip;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.pbStudGradeUpload.setVisible(false);
        this.btnStudGradeUpload.setDisable(true);
        this.tfPin.setEditable(true);
    }

    private void parseWebParams() {
        try {
            JSONObject json = new JSONObject(this.webparams);
            this.curr_seme = json.getString("curr_seme");
            this.session_id = json.getString("session_id");
            this.useragent = json.getString("useragent");
            this.targetpage = json.getString("target_page");
            this.upload_id = json.getString("upload_id");
            this.submit_ip = json.getString("submit_ip");
            logger.debug((Object)("\ncurr_seme:" + this.curr_seme + "\nsession_id:" + this.session_id + "\nuseragent:" + this.useragent + "\ntargetpage:" + this.targetpage + "\nsubmit_ip: " + this.submit_ip + "\nupload_id:" + this.upload_id));
        }
        catch (JSONException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    private void showMsg(String message, String title, int msgicon) {
        MessageBox.show((Window)this.stage, (String)message, (String)title, (int)msgicon);
    }

    @FXML
    private void enableVerify(KeyEvent event) {
        if (this.tfPin.getText().isEmpty()) {
            this.btnStudGradeUpload.setDisable(true);
        } else {
            this.btnStudGradeUpload.setDisable(false);
        }
    }

    @FXML
    private void doVerifySmartCard(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbStudGradeUpload.setProgress(-1.0);
        String password = this.tfPin.getText();
        logger.debug((Object)("\u8f38\u5165\u7684PIN\u78bc\u662f:\n" + password));
        final StudGradeUploadTask task = new StudGradeUploadTask(this.targetpage, this.session_id, this.useragent, this.curr_seme, this.submit_ip, this.upload_id, password);
        task.setOnScheduled((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXStudGradeUploadController.this.pbStudGradeUpload.setVisible(true);
                FXStudGradeUploadController.this.btnStudGradeUpload.setDisable(true);
                FXStudGradeUploadController.this.tfPin.setEditable(false);
            }
        });
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXStudGradeUploadController.this.pbStudGradeUpload.setVisible(false);
                FXStudGradeUploadController.this.btnStudGradeUpload.setDisable(false);
                FXStudGradeUploadController.this.tfPin.setEditable(true);
                MESSAGE message = (MESSAGE)((Object)task.getValue());
                logger.info((Object)("\u57f7\u884c\u7d50\u679c:" + (Object)((Object)message)));
                FXStudGradeUploadController.this.showMsg(TCCertUtil.getMessage(message), "\u7562\u696d\u751f\u8cc7\u6599\u4e0a\u50b3\u7d50\u679c", 0x4000000);
            }
        });
        task.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXStudGradeUploadController.this.pbStudGradeUpload.setVisible(false);
                FXStudGradeUploadController.this.btnStudGradeUpload.setDisable(false);
                FXStudGradeUploadController.this.tfPin.setEditable(true);
                MESSAGE result = (MESSAGE)((Object)task.getValue());
                if (result == null) {
                    FXStudGradeUploadController.this.showMsg("\u7562\u696d\u751f\u8cc7\u6599\u4e0a\u50b3\u5931\u6557", "\u4e0a\u50b3\u5931\u6557", 0x1000000);
                }
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }
}

