/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javafx.stage.Window;
import jfx.messagebox.MessageBox;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.tasks.XCAExchangeTestTask;

public class FXXCAExchangeTestSuitController
implements Initializable {
    private String webparams;
    private Stage stage;
    private String session_id;
    private String cookie_sch_id;
    private String useragent;
    private String targetpage;
    private static final Logger logger = Logger.getLogger(FXXCAExchangeTestSuitController.class);
    @FXML
    private Parent root;
    @FXML
    private PasswordField tfPin;
    @FXML
    private ProgressIndicator pbTestExchange;
    @FXML
    private Button btnTestExchange;

    public void initialize(URL url, ResourceBundle rb) {
        this.pbTestExchange.setVisible(false);
        this.btnTestExchange.setDisable(true);
        this.tfPin.setEditable(true);
    }

    @FXML
    private void enableTestEXchange(KeyEvent event) {
        if (this.tfPin.getText().isEmpty()) {
            this.btnTestExchange.setDisable(true);
        } else {
            this.btnTestExchange.setDisable(false);
        }
    }

    @FXML
    private void doTestExchange(ActionEvent event) {
        this.stage = (Stage)this.root.getScene().getWindow();
        this.pbTestExchange.setProgress(-1.0);
        String password = this.tfPin.getText();
        logger.info((Object)("\u8f38\u5165\u7684PIN\u78bc\u662f:\n" + password));
        final XCAExchangeTestTask task = new XCAExchangeTestTask(this.targetpage, this.session_id, this.useragent, password, this.cookie_sch_id);
        task.setOnScheduled(t -> {
            this.pbTestExchange.setVisible(true);
            this.btnTestExchange.setDisable(true);
            this.tfPin.setEditable(false);
        });
        task.setOnSucceeded(t -> {
            this.pbTestExchange.setVisible(false);
            this.btnTestExchange.setDisable(false);
            this.tfPin.setEditable(true);
            MESSAGE message = (MESSAGE)((Object)((Object)task.getValue()));
            this.showMsg(TCCertUtil.getMessage(message), "XCA\u5168\u81ea\u52d5\u4ea4\u63db\u6e2c\u8a66\u7d50\u679c", 0x4000000);
        });
        task.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                FXXCAExchangeTestSuitController.this.pbTestExchange.setVisible(false);
                FXXCAExchangeTestSuitController.this.btnTestExchange.setDisable(false);
                FXXCAExchangeTestSuitController.this.tfPin.setEditable(true);
                MESSAGE result = (MESSAGE)((Object)task.getValue());
                if (result == null) {
                    FXXCAExchangeTestSuitController.this.showMsg("XCA\u5168\u81ea\u52d5\u4ea4\u63db\u7121\u6cd5\u9032\u884c\u6e2c\u8a66\uff01", "XCA\u5168\u81ea\u52d5\u4ea4\u63db\u6e2c\u8a66\u7d50\u679c", 0x1000000);
                }
            }
        });
        new Thread((Runnable)((Object)task)).start();
    }

    public String getSession_id() {
        return this.session_id;
    }

    public void setSession_id(String session_id) {
        this.session_id = session_id;
    }

    public String getCookie_sch_id() {
        return this.cookie_sch_id;
    }

    public void setCookie_sch_id(String cookie_sch_id) {
        this.cookie_sch_id = cookie_sch_id;
    }

    public String getUseragent() {
        return this.useragent;
    }

    public void setUseragent(String useragent) {
        this.useragent = useragent;
    }

    public String getTargetpage() {
        return this.targetpage;
    }

    public void setTargetpage(String targetpage) {
        this.targetpage = targetpage;
    }

    public Parent getRoot() {
        return this.root;
    }

    public void setRoot(Parent root) {
        this.root = root;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public String getWebparams() {
        return this.webparams;
    }

    public void setWebparams(String webparams) {
        this.webparams = webparams;
        logger.debug((Object)webparams);
        this.parseWebParams();
    }

    private void parseWebParams() {
        try {
            JSONObject json = new JSONObject(this.webparams);
            this.session_id = json.getString("session_id");
            this.cookie_sch_id = json.getString("cookie_sch_id");
            this.useragent = json.getString("useragent");
            this.targetpage = json.getString("target_page");
            logger.debug((Object)("\nsession_id:" + this.session_id + "\nuseragent:" + this.useragent + "\ntargetpage:" + this.targetpage + "\ncookie_sch_id: " + this.cookie_sch_id));
        }
        catch (JSONException ex) {
            logger.error((Object)ex.getMessage());
        }
    }

    private void showMsg(String message, String title, int msgicon) {
        MessageBox.show((Window)this.stage, (String)message, (String)title, (int)msgicon);
    }
}

