/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Future;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import sun.security.provider.certpath.OCSP;
import tw.com.chttl.CertUtil;
import tw.com.chttl.Module;
import tw.com.chttl.OCSP;
import tw.com.chttl.Token;
import utils.EncryptedContent;
import utils.ExchangeKey;
import utils.ExchangeKeyTypes;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.exchange.soap.Xcaexchange;
import utils.exchange.soap.Xcaexchange_Service;

public class StudBaseUpload
extends EncryptedContent
implements PrivilegedAction<MESSAGE> {
    private static final Logger logger = Logger.getLogger(StudBaseUpload.class);
    private String currseme;
    private String submit_ip;
    private String upload_id;
    private final String password;
    private String schoolid;
    private String schoolname;
    private MESSAGE message;
    private String signserial;
    private String md5;
    private String signedmd5;
    private String datetime;

    public StudBaseUpload(String url, String sessionid, String useragent, String currseme, String submit_ip, String upload_id, String password) {
        super(url, sessionid, useragent, "DEFAULT");
        this.currseme = currseme;
        this.submit_ip = submit_ip;
        this.upload_id = upload_id;
        this.password = password;
    }

    public String getCurrseme() {
        return this.currseme;
    }

    public void setCurrseme(String currseme) {
        this.currseme = currseme;
    }

    public String getSubmit_ip() {
        return this.submit_ip;
    }

    public void setSubmit_ip(String submit_ip) {
        this.submit_ip = submit_ip;
    }

    public String getUpload_id() {
        return this.upload_id;
    }

    public void setUpload_id(String upload_id) {
        this.upload_id = upload_id;
    }

    public String getSchoolid() {
        return this.schoolid;
    }

    public void setSchoolid(String schoolid) {
        this.schoolid = schoolid;
    }

    public String getSchoolname() {
        return this.schoolname;
    }

    public void setSchoolname(String schoolname) {
        this.schoolname = schoolname;
    }

    public MESSAGE getMessage() {
        return this.message;
    }

    public void setMessage(MESSAGE message) {
        this.message = message;
    }

    public String getSignserial() {
        return this.signserial;
    }

    public void setSignserial(String signserial) {
        this.signserial = signserial;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSignedmd5() {
        return this.signedmd5;
    }

    public void setSignedmd5(String signedmd5) {
        this.signedmd5 = signedmd5;
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    @Override
    protected void init() {
        this.getDHKey();
        this.setPhppk(this.performKeyExchangePost());
        this.performPostXML();
    }

    private void performPostXML() {
        Object output = null;
        try {
            byte[] servSecret = ExchangeKey.generateShareKey(this.getPhppk(), this.getServParamSpec(), this.getServKP());
            logger.info((Object)("Server Secret Key:" + Base64.encodeBase64String((byte[])servSecret)));
            ArrayList<BasicNameValuePair> pair = new ArrayList<BasicNameValuePair>();
            pair.add(new BasicNameValuePair("sid", this.getSessionid()));
            pair.add(new BasicNameValuePair("getkey", "false"));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pair, "UTF-8");
            CloseableHttpAsyncClient client = this.getAsyncClient();
            HttpPost httpPost = this.getHttpPost();
            httpPost.setEntity((HttpEntity)entity);
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            httpPost.setHeader("Connection", "close");
            client.start();
            Future future = client.execute((HttpUriRequest)httpPost, null);
            HttpResponse response = (HttpResponse)future.get();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            this.setContent(responseString);
            logger.info((Object)("SFS Response :" + this.getContent()));
            this.setAeskey(ExchangeKey.generateAESKey(servSecret));
            String string = this.getAeskey();
        }
        catch (InvalidKeyException ex) {
            logger.error((Object)ex);
            this.init();
        }
        catch (Exception ex) {
            logger.info((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MESSAGE run() {
        EnumMap<ExchangeKeyTypes, String> cypher = new EnumMap<ExchangeKeyTypes, String>(ExchangeKeyTypes.class);
        Token token = null;
        try {
            boolean init = Module.initialize();
            if (init) {
                Module module = Module.getInstance();
                int[] tokIDs = module.getTokens();
                if (tokIDs.length != 0) {
                    X509Certificate smartcard = null;
                    token = module.getToken(tokIDs[0]);
                    String cardnumber = token.getSerialNumber();
                    logger.info((Object)("\u5361\u865f : " + cardnumber));
                    smartcard = token.getCert(Token.ID_SIGN);
                    String signpem = Base64.encodeBase64String((byte[])smartcard.getEncoded());
                    logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49 :\n" + signpem));
                    String cardtype = CertUtil.getCertType(smartcard);
                    logger.debug((Object)("\u5361\u7247\u985e\u578b : " + cardtype));
                    logger.debug((Object)("OCSP : " + CertUtil.getOCSP(smartcard)));
                    this.signserial = TCCertUtil.getSerialNumberFromHex(smartcard.getSerialNumber().toByteArray());
                    logger.debug((Object)("\u7c3d\u7ae0\u6191\u8b49\u5e8f\u865f : " + this.signserial));
                    if (cardtype.equals("XCA")) {
                        int ocsp = OCSP.checkStatus(smartcard);
                        if (ocsp == 14) {
                            OCSP.RevocationStatus.CertStatus ocspv2 = TCCertUtil.verifyXCA2FromOCSP(smartcard, TCCertUtil.getCertFromInputStream(this.getClass().getResourceAsStream("/utils/certificates/XCA2.cer")));
                            logger.debug((Object)("XCA2 OCSP Primitive : " + (Object)((Object)ocspv2)));
                            if (ocspv2 == OCSP.RevocationStatus.CertStatus.GOOD) {
                                logger.debug((Object)("XCA2 OCSP SUN OCSP Chech : " + (Object)((Object)ocspv2)));
                                ocsp = 0;
                            }
                        }
                        if (ocsp == 0) {
                            if (token.login(this.password)) {
                                List<String> schoolinfo = StudBaseUpload.doQuerySchoolid(cardnumber);
                                if (schoolinfo == null || schoolinfo.isEmpty()) {
                                    logger.debug((Object)("\u4ea4\u63db\u5e73\u53f0\u672a\u8a3b\u518a\u6b64\u5361\u865f:" + cardnumber));
                                    this.message = MESSAGE.CERTERROR_NOT_REG_XCA;
                                }
                                this.schoolid = schoolinfo.get(0);
                                this.schoolname = schoolinfo.get(1);
                                logger.info((Object)("\u6559\u80b2\u90e8\u4ee3\u78bc:" + this.schoolid + ";\u5b78\u6821\u540d\u7a31:" + this.schoolname));
                                this.init();
                                cypher.put(ExchangeKeyTypes.ShareAESKey, this.getAeskey());
                                cypher.put(ExchangeKeyTypes.EncryptedContent, this.getContent());
                                try {
                                    String ori = ExchangeKey.generateDecryptedContent((String)cypher.get((Object)ExchangeKeyTypes.EncryptedContent), ((String)cypher.get((Object)ExchangeKeyTypes.ShareAESKey)).getBytes());
                                    logger.debug((Object)("\u89e3\u78bc\u5f8c\u5167\u5bb9:" + ori));
                                    String zipori = TCCertUtil.compress(ori);
                                    logger.debug((Object)("\u58d3\u7e2e\u5f8c\u8cc7\u6599:\n" + zipori));
                                    if (logger.isDebugEnabled()) {
                                        logger.info((Object)("\u89e3\u58d3\u7e2e\u5f8c\u8cc7\u6599:\n" + TCCertUtil.decompress(zipori)));
                                    }
                                    this.datetime = TCCertUtil.getCurrentDateTime();
                                    logger.info((Object)("\u76ee\u524d\u6642\u9593:\n" + this.datetime));
                                    ArrayList<String> datas = new ArrayList<String>();
                                    datas.add(zipori);
                                    datas.add(this.currseme);
                                    datas.add(this.submit_ip);
                                    datas.add(this.upload_id);
                                    datas.add(this.schoolid);
                                    datas.add(this.schoolname);
                                    logger.debug((Object)("Signed Data :\n" + TCCertUtil.generateSignData(this.datetime, datas)));
                                    this.md5 = TCCertUtil.generateSignDataDigest(this.datetime, datas);
                                    byte[] bparams = this.md5.getBytes("UTF-8");
                                    byte[] sbparams = token.sign(Token.ID_SIGN, bparams, "SHA256withRSA");
                                    String b64 = Base64.encodeBase64String((byte[])sbparams);
                                    logger.info((Object)"\u6578\u4f4d\u7c3d\u7ae0\u5b8c\u6210");
                                    logger.debug((Object)("\u7c3d\u7ae0\u904e\u5f8c\u5b57\u4e32BASE64:\n" + b64));
                                    this.signedmd5 = b64;
                                    JSONObject json = TCCertUtil.generateUploadStudBaseData(this.signserial, this.datetime, zipori, this.currseme, this.submit_ip, this.upload_id, this.md5, this.signedmd5, this.schoolid, this.schoolname);
                                    CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                                    HttpPost postRequest = new HttpPost("https://oidc.tc.edu.tw/api/stud-base-upload");
                                    postRequest.setHeader("Authorization", TCCertUtil.authorizationHeader("api", "oidcuser"));
                                    StringEntity input = new StringEntity(json.toString(), "UTF-8");
                                    input.setContentType("application/json");
                                    postRequest.setEntity((HttpEntity)input);
                                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)postRequest);
                                    if (response.getStatusLine().getStatusCode() != 200) {
                                        logger.error((Object)("Failed : HTTP error code : " + response.getStatusLine().getStatusCode()));
                                        this.message = MESSAGE.STUDBASE_UPLOAD_API_ERROR;
                                    } else {
                                        if (logger.isDebugEnabled()) {
                                            String output;
                                            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
                                            logger.debug((Object)"Output from Server .... \n");
                                            while ((output = br.readLine()) != null) {
                                                logger.debug((Object)output);
                                            }
                                        }
                                        this.message = MESSAGE.STUDBASE_UPLOAD_COMPLETED;
                                    }
                                    httpClient.close();
                                }
                                catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
                                    logger.error((Object)ex.getMessage());
                                }
                            }
                            logger.debug((Object)"PIN ERROR!");
                            this.message = MESSAGE.CERTERROR_PINCODE_ERROR;
                        }
                        logger.debug((Object)"OCSP FAILED");
                        this.message = MESSAGE.CERTERROR_OCSP_VERIFY_FAILED;
                    }
                    logger.debug((Object)"NOT XCA CARD");
                    this.message = MESSAGE.CERTERROR_NOT_XCA;
                }
                logger.debug((Object)"CARD NOT EXIST");
                this.message = MESSAGE.CERTERROR_CARD_NOT_EXIST;
            }
            logger.debug((Object)"READER NOT EXIST");
            this.message = MESSAGE.CERTERROR_READER_NOT_EXIST;
            return this.message;
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage());
            this.message = MESSAGE.CERTERROR_EXCEPTION;
            return this.message;
        }
        finally {
            if (token != null) {
                token.logout();
            }
            return this.message;
        }
    }

    private static List<String> doQuerySchoolid(String xcaSerial) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQuerySchoolid(xcaSerial);
    }
}

