/*
 * Decompiled with CFR 0.152.
 */
package utils.privileged;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import sun.security.provider.certpath.OCSP;
import tw.com.chttl.CertUtil;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Module;
import tw.com.chttl.OCSP;
import tw.com.chttl.Token;
import utils.EncryptedContent;
import utils.ExchangeKey;
import utils.MESSAGE;
import utils.TCCertUtil;
import utils.exchange.soap.Xcaexchange;
import utils.exchange.soap.Xcaexchange_Service;

public class XCAExchangeTest
extends EncryptedContent
implements PrivilegedAction<MESSAGE> {
    private final String password;
    private String cookie_sch_id;
    private String signserial;
    private MESSAGE message;
    private String schoolid;
    private String schoolname;
    private static final Logger logger = Logger.getLogger(XCAExchangeTest.class);

    public XCAExchangeTest(String url, String sessionid, String useragent, String password, String cookie_sch_id) {
        super(url, sessionid, useragent, cookie_sch_id);
        this.password = password;
    }

    @Override
    protected void init() {
        this.getDHKey();
        this.setPhppk(this.performKeyExchangePost());
        this.performPostXML();
    }

    private void performPostXML() {
        String output = null;
        try {
            byte[] servSecret = ExchangeKey.generateShareKey(this.getPhppk(), this.getServParamSpec(), this.getServKP());
            logger.info((Object)("Server Secret Key:\n" + Base64.encodeBase64String((byte[])servSecret)));
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
            Calendar calobj = Calendar.getInstance();
            String postmsg = df.format(calobj.getTime());
            logger.info((Object)("Applet\u9001\u51fa\u81f3SFS3\u7684\u8a0a\u606f :\n" + postmsg));
            ArrayList<BasicNameValuePair> pair = new ArrayList<BasicNameValuePair>();
            pair.add(new BasicNameValuePair("sid", this.getSessionid()));
            pair.add(new BasicNameValuePair("getkey", "false"));
            pair.add(new BasicNameValuePair("xcaexchangemsg", postmsg));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pair, "UTF-8");
            CloseableHttpAsyncClient client = this.getAsyncClient();
            HttpPost httpPost = this.getHttpPost();
            httpPost.setEntity((HttpEntity)entity);
            HttpClientContext clientContext = HttpClientContext.create();
            clientContext.setAttribute("http.protocol.content-charset", (Object)"UTF-8");
            client.start();
            Future future = client.execute((HttpUriRequest)httpPost, null);
            HttpResponse response = (HttpResponse)future.get();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            this.setContent(responseString);
            logger.info((Object)("SFS3\u56de\u61c9\u52a0\u5bc6\u5f8c\u7684\u503c :\n" + responseString));
            this.setAeskey(ExchangeKey.generateAESKey(servSecret));
            String aeskey = this.getAeskey();
            output = ExchangeKey.generateDecryptedContent(responseString, aeskey.getBytes());
            logger.info((Object)("SFS3\u56de\u61c9\u503c\u7d93\u89e3\u5bc6\u5f8c\u7684\u503c :\n" + output));
        }
        catch (InvalidKeyException ex) {
            logger.error((Object)ex);
            this.init();
        }
        catch (Exception ex) {
            logger.info((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MESSAGE run() {
        Token token = null;
        this.message = MESSAGE.XCA_EXCHANGE_TEST_ERROR;
        try {
            boolean init = Module.initialize();
            if (!init) {
                logger.debug((Object)"READER NOT EXIST");
                this.message = MESSAGE.CERTERROR_READER_NOT_EXIST;
                return this.message;
            }
            Module module = Module.getInstance();
            int[] tokIDs = module.getTokens();
            if (tokIDs.length == 0) {
                logger.debug((Object)"CARD NOT EXIST");
                this.message = MESSAGE.CERTERROR_CARD_NOT_EXIST;
            }
            X509Certificate smartcard = null;
            X509Certificate encryptcert = null;
            token = module.getToken(tokIDs[0]);
            String cardnumber = token.getSerialNumber();
            logger.info((Object)("\u6191\u8b49\u5361\u865f :\n" + cardnumber));
            smartcard = token.getCert(Token.ID_SIGN);
            encryptcert = token.getCert(Token.ID_ENCRYPT);
            String signpem = Base64.encodeBase64String((byte[])smartcard.getEncoded());
            logger.info((Object)("\u7c3d\u7ae0\u6191\u8b49 :\n" + signpem));
            logger.info((Object)("\u52a0\u5bc6\u6191\u8b49 :\n" + Base64.encodeBase64String((byte[])encryptcert.getEncoded())));
            String cardtype = CertUtil.getCertType(smartcard);
            logger.info((Object)("\u5361\u7247\u985e\u578b :\n" + cardtype));
            logger.info((Object)("OCSP :\n" + CertUtil.getOCSP(smartcard)));
            this.signserial = TCCertUtil.getSerialNumberFromHex(smartcard.getSerialNumber().toByteArray());
            logger.info((Object)("\u7c3d\u7ae0\u6191\u8b49\u5e8f\u865f :\n" + this.signserial));
            logger.info((Object)("\u52a0\u5bc6\u6191\u8b49\u5e8f\u865f :\n" + TCCertUtil.getSerialNumberFromHex(encryptcert.getSerialNumber().toByteArray())));
            if (!cardtype.equals("XCA")) {
                logger.debug((Object)"NOT XCA CARD");
                this.message = MESSAGE.CERTERROR_NOT_XCA;
            }
            int ocsp = OCSP.checkStatus(smartcard);
            if (ocsp == 14) {
                OCSP.RevocationStatus.CertStatus ocspv2 = TCCertUtil.verifyXCA2FromOCSP(smartcard, TCCertUtil.getCertFromInputStream(this.getClass().getResourceAsStream("/utils/certificates/XCA2.cer")));
                logger.debug((Object)("XCA2 OCSP Primitive : " + (Object)((Object)ocspv2)));
                if (ocspv2 == OCSP.RevocationStatus.CertStatus.GOOD) {
                    logger.debug((Object)("XCA2 OCSP SUN OCSP Chech : " + (Object)((Object)ocspv2)));
                    ocsp = 0;
                }
            }
            if (ocsp != 0) {
                logger.debug((Object)"OCSP FAILED");
                this.message = MESSAGE.CERTERROR_OCSP_VERIFY_FAILED;
            }
            if (!token.login(this.password)) {
                logger.debug((Object)"PIN ERROR!");
                this.message = MESSAGE.CERTERROR_PINCODE_ERROR;
            }
            List<String> schoolinfo = XCAExchangeTest.doQuerySchoolid(cardnumber);
            if (schoolinfo == null || schoolinfo.isEmpty()) {
                logger.info((Object)("\u4ea4\u63db\u5e73\u53f0\u672a\u8a3b\u518a\u6b64\u5361\u865f :\n" + cardnumber));
                this.message = MESSAGE.CERTERROR_NOT_REG_XCA;
            }
            this.schoolid = schoolinfo.get(0);
            this.schoolname = schoolinfo.get(1);
            logger.info((Object)("\u4ea4\u63db\u5e73\u53f0\u4e0a\u8a3b\u8a18\u672c\u5361\u8cc7\u8a0a:\n\u8cb4\u6821\u6559\u80b2\u90e8\u4ee3\u78bc\uff1a" + this.schoolid + "\uff1b\u5b78\u6821\u540d\u7a31:" + this.schoolname));
            this.init();
            try {
                String aeskey = this.getAeskey();
                byte[] baeskey = CryptoUtil.wrap(encryptcert, aeskey.getBytes());
                String b64aeskey = Base64.encodeBase64String((byte[])baeskey);
                logger.info((Object)("AES KEY\u539f\u59cb\u5167\u5bb9:\n" + aeskey));
                logger.info((Object)("\u4ee5XCA\u6191\u8b49\u52a0\u5bc6AES KEY\u5f8c\u5167\u5bb9:\n" + b64aeskey));
                String content = this.getContent();
                byte[] sbparams = token.sign(Token.ID_SIGN, content.getBytes(), "SHA256withRSA");
                String b64content = Base64.encodeBase64String((byte[])sbparams);
                logger.info((Object)("\u539f\u59cbSFS3\u56de\u61c9\u5167\u5bb9:\n" + content));
                logger.info((Object)("XCA\u6191\u8b49\u52a0\u7c3d\u7d50\u679c:\n" + b64content));
                logger.info((Object)("XCA\u6191\u8b49\u8cc7\u6599\u9a57\u7c3d\u7d50\u679c:\n" + CryptoUtil.verifySHA256(smartcard, content.getBytes(), sbparams)));
                if (this.getContent() != null) {
                    this.message = MESSAGE.XCA_EXCHANGE_TEST_OK;
                }
            }
            catch (NoSuchAlgorithmException ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage());
            this.message = MESSAGE.CERTERROR_EXCEPTION;
            return this.message;
        }
        finally {
            if (token == null) return this.message;
            token.logout();
            return this.message;
        }
    }

    private static List<String> doQuerySchoolid(String xcaSerial) {
        Xcaexchange_Service service = new Xcaexchange_Service();
        Xcaexchange port = service.getXcaexchangePort();
        return port.doQuerySchoolid(xcaSerial);
    }
}

