/*
 * Decompiled with CFR 0.152.
 */
package jfx.messagebox;

import javafx.scene.Group;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Light;
import javafx.scene.effect.Lighting;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;

class MessageIconBuilder {
    MessageIconBuilder() {
    }

    public static Group drawErrorIcon(int zoomRate) {
        Group root = new Group();
        Circle circle = new Circle((double)(5 * zoomRate), (double)(5 * zoomRate), (double)(5 * zoomRate));
        root.getChildren().add((Object)circle);
        circle.setFill((Paint)Color.RED);
        Light.Spot light = new Light.Spot();
        light.setX(0.0);
        light.setY(0.0);
        light.setZ((double)(10 * zoomRate));
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        circle.setEffect((Effect)lighting);
        Line line = new Line((double)(3 * zoomRate), (double)(3 * zoomRate), (double)(7 * zoomRate), (double)(7 * zoomRate));
        line.setFill(null);
        line.setStroke((Paint)Color.WHITE);
        line.setStrokeWidth(1.2 * (double)zoomRate);
        root.getChildren().add((Object)line);
        line = new Line((double)(7 * zoomRate), (double)(3 * zoomRate), (double)(3 * zoomRate), (double)(7 * zoomRate));
        line.setFill(null);
        line.setStroke((Paint)Color.WHITE);
        line.setStrokeWidth(1.2 * (double)zoomRate);
        root.getChildren().add((Object)line);
        return root;
    }

    public static Group drawWarningIcon(int zoomRate) {
        Group root = new Group();
        Path pathTriangle = new Path();
        root.getChildren().add((Object)pathTriangle);
        pathTriangle.getElements().addAll((Object[])new PathElement[]{new MoveTo(4.5 * (double)zoomRate, 0.5 * (double)zoomRate), new CubicCurveTo(4.5 * (double)zoomRate, 0.5 * (double)zoomRate, (double)(5 * zoomRate), (double)(0 * zoomRate), 5.5 * (double)zoomRate, 0.5 * (double)zoomRate), new LineTo((double)(10 * zoomRate), (double)(9 * zoomRate)), new CubicCurveTo((double)(10 * zoomRate), (double)(9 * zoomRate), (double)(10 * zoomRate), (double)(10 * zoomRate), (double)(9 * zoomRate), (double)(10 * zoomRate)), new LineTo((double)(1 * zoomRate), (double)(10 * zoomRate)), new CubicCurveTo((double)(1 * zoomRate), (double)(10 * zoomRate), (double)(0 * zoomRate), (double)(10 * zoomRate), (double)(0 * zoomRate), (double)(9 * zoomRate)), new ClosePath()});
        pathTriangle.setStrokeWidth(0.0);
        pathTriangle.setFill((Paint)Color.YELLOW);
        Light.Spot light = new Light.Spot();
        light.setX(0.0);
        light.setY(0.0);
        light.setZ((double)(15 * zoomRate));
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        pathTriangle.setEffect((Effect)lighting);
        Circle circle = new Circle((double)(5 * zoomRate), 3.8 * (double)zoomRate, 0.8 * (double)zoomRate);
        root.getChildren().add((Object)circle);
        circle.setFill((Paint)Color.BLACK);
        Path path = new Path();
        root.getChildren().add((Object)path);
        path.getElements().addAll((Object[])new PathElement[]{new MoveTo(5.8 * (double)zoomRate, 3.8 * (double)zoomRate), new LineTo((double)(5 * zoomRate), 7.5 * (double)zoomRate), new LineTo(4.2 * (double)zoomRate, 3.8 * (double)zoomRate), new ClosePath()});
        path.setStrokeWidth(0.0);
        path.setFill((Paint)Color.BLACK);
        circle = new Circle((double)(5 * zoomRate), 8.5 * (double)zoomRate, 0.7 * (double)zoomRate);
        root.getChildren().add((Object)circle);
        circle.setFill((Paint)Color.BLACK);
        return root;
    }

    public static Group drawInformationIcon(int zoomRate) {
        Group root = new Group();
        Color baseColor = Color.rgb((int)30, (int)30, (int)255);
        Color backColor = Color.rgb((int)120, (int)140, (int)255);
        Path path = new Path();
        root.getChildren().add((Object)path);
        path.getElements().addAll((Object[])new PathElement[]{new MoveTo((double)(5 * zoomRate), 0.0), new CubicCurveTo((double)(5 * zoomRate), 0.0, 0.0, 0.0, 0.0, (double)(4 * zoomRate)), new CubicCurveTo(0.0, (double)(4 * zoomRate), 0.0, (double)(8 * zoomRate), (double)(4 * zoomRate), (double)(8 * zoomRate)), new CubicCurveTo((double)(4 * zoomRate), (double)(8 * zoomRate), (double)(4 * zoomRate), (double)(10 * zoomRate), (double)(6 * zoomRate), (double)(10 * zoomRate)), new CubicCurveTo((double)(6 * zoomRate), (double)(10 * zoomRate), (double)(5 * zoomRate), (double)(10 * zoomRate), 5.5 * (double)zoomRate, (double)(8 * zoomRate)), new CubicCurveTo(5.5 * (double)zoomRate, (double)(8 * zoomRate), (double)(10 * zoomRate), 8.6 * (double)zoomRate, (double)(10 * zoomRate), (double)(4 * zoomRate)), new CubicCurveTo((double)(10 * zoomRate), (double)(4 * zoomRate), (double)(10 * zoomRate), 0.0, (double)(4 * zoomRate), 0.0)});
        path.setStrokeWidth(0.0);
        path.setFill((Paint)backColor);
        path.setOpacity(0.6);
        Light.Spot light = new Light.Spot();
        light.setX(0.0);
        light.setY(0.0);
        light.setZ((double)(10 * zoomRate));
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        path.setEffect((Effect)lighting);
        Circle circle = new Circle(5.0 * (double)zoomRate, 1.5 * (double)zoomRate, 0.7 * (double)zoomRate);
        root.getChildren().add((Object)circle);
        circle.setFill((Paint)baseColor);
        Line line = new Line((double)(5 * zoomRate), 3.5 * (double)zoomRate, (double)(5 * zoomRate), (double)(6 * zoomRate));
        root.getChildren().add((Object)line);
        line.setStrokeWidth(1.2 * (double)zoomRate);
        line.setStroke((Paint)baseColor);
        line = new Line(3.8 * (double)zoomRate, (double)(3 * zoomRate), 5.4 * (double)zoomRate, (double)(3 * zoomRate));
        root.getChildren().add((Object)line);
        line.setStrokeWidth(0.4 * (double)zoomRate);
        line.setStroke((Paint)baseColor);
        line = new Line(3.8 * (double)zoomRate, 6.8 * (double)zoomRate, 6.2 * (double)zoomRate, 6.8 * (double)zoomRate);
        root.getChildren().add((Object)line);
        line.setStrokeWidth(0.4 * (double)zoomRate);
        line.setStroke((Paint)baseColor);
        return root;
    }

    public static Group drawQuestionIcon(int zoomRate) {
        Group root = new Group();
        Color baseColor = Color.rgb((int)0, (int)64, (int)0);
        Color backColor = Color.rgb((int)120, (int)255, (int)140);
        Path pathBalloon = new Path();
        root.getChildren().add((Object)pathBalloon);
        pathBalloon.getElements().addAll((Object[])new PathElement[]{new MoveTo((double)(5 * zoomRate), 0.0), new CubicCurveTo((double)(5 * zoomRate), 0.0, 0.0, 0.0, 0.0, (double)(4 * zoomRate)), new CubicCurveTo(0.0, (double)(4 * zoomRate), 0.0, (double)(8 * zoomRate), (double)(4 * zoomRate), (double)(8 * zoomRate)), new CubicCurveTo((double)(4 * zoomRate), (double)(8 * zoomRate), (double)(4 * zoomRate), (double)(10 * zoomRate), (double)(6 * zoomRate), (double)(10 * zoomRate)), new CubicCurveTo((double)(6 * zoomRate), (double)(10 * zoomRate), (double)(5 * zoomRate), (double)(10 * zoomRate), 5.5 * (double)zoomRate, (double)(8 * zoomRate)), new CubicCurveTo(5.5 * (double)zoomRate, (double)(8 * zoomRate), (double)(10 * zoomRate), 8.6 * (double)zoomRate, (double)(10 * zoomRate), (double)(4 * zoomRate)), new CubicCurveTo((double)(10 * zoomRate), (double)(4 * zoomRate), (double)(10 * zoomRate), 0.0, (double)(4 * zoomRate), 0.0)});
        pathBalloon.setStrokeWidth(0.0);
        pathBalloon.setFill((Paint)backColor);
        pathBalloon.setOpacity(0.6);
        Light.Spot light = new Light.Spot();
        light.setX(0.0);
        light.setY(0.0);
        light.setZ((double)(10 * zoomRate));
        Lighting lighting = new Lighting();
        lighting.setLight((Light)light);
        pathBalloon.setEffect((Effect)lighting);
        Circle circle = new Circle((double)(5 * zoomRate), 6.5 * (double)zoomRate, 0.7 * (double)zoomRate);
        root.getChildren().add((Object)circle);
        circle.setFill((Paint)baseColor);
        Path path = new Path();
        root.getChildren().add((Object)path);
        path.getElements().addAll((Object[])new PathElement[]{new MoveTo((double)(3 * zoomRate), (double)(3 * zoomRate)), new CubicCurveTo((double)(3 * zoomRate), (double)(3 * zoomRate), (double)(3 * zoomRate), (double)(1 * zoomRate), (double)(5 * zoomRate), (double)(1 * zoomRate)), new CubicCurveTo((double)(5 * zoomRate), (double)(1 * zoomRate), (double)(7 * zoomRate), (double)(1 * zoomRate), (double)(7 * zoomRate), (double)(3 * zoomRate)), new CubicCurveTo((double)(7 * zoomRate), (double)(3 * zoomRate), 6.5 * (double)zoomRate, (double)(4 * zoomRate), 5.5 * (double)zoomRate, (double)(4 * zoomRate)), new CubicCurveTo(5.5 * (double)zoomRate, (double)(4 * zoomRate), (double)(5 * zoomRate), (double)(4 * zoomRate), (double)(5 * zoomRate), 5.5 * (double)zoomRate), new CubicCurveTo((double)(5 * zoomRate), (double)(5 * zoomRate), 4.5 * (double)zoomRate, 4.5 * (double)zoomRate, (double)(5 * zoomRate), 3.5 * (double)zoomRate), new CubicCurveTo((double)(5 * zoomRate), 3.5 * (double)zoomRate, 6.5 * (double)zoomRate, 3.5 * (double)zoomRate, 6.2 * (double)zoomRate, 2.5 * (double)zoomRate), new CubicCurveTo(6.2 * (double)zoomRate, 2.5 * (double)zoomRate, 6.6 * (double)zoomRate, (double)(2 * zoomRate), (double)(5 * zoomRate), 1.5 * (double)zoomRate), new CubicCurveTo((double)(5 * zoomRate), 1.5 * (double)zoomRate, (double)(3 * zoomRate), 1.5 * (double)zoomRate, (double)(4 * zoomRate), (double)(3 * zoomRate)), new CubicCurveTo((double)(4 * zoomRate), (double)(3 * zoomRate), 3.5 * (double)zoomRate, (double)(4 * zoomRate), (double)(3 * zoomRate), (double)(3 * zoomRate))});
        path.setStrokeWidth(0.0);
        path.setFill((Paint)baseColor);
        return root;
    }
}

