/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.beans;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.pivot.beans.BXML;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.beans.BindException;
import org.apache.pivot.beans.Bindable;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.beans.IDProperty;
import org.apache.pivot.beans.NamespaceBinding;
import org.apache.pivot.beans.Resolvable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.BinarySerializer;
import org.apache.pivot.serialization.ByteArraySerializer;
import org.apache.pivot.serialization.CSVSerializer;
import org.apache.pivot.serialization.PropertiesSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.util.Vote;

public class BXMLSerializer
implements Serializer<Object>,
Resolvable {
    private XMLInputFactory xmlInputFactory;
    private ScriptEngineManager scriptEngineManager;
    private org.apache.pivot.collections.Map<String, Object> namespace = new HashMap<String, Object>();
    private URL location = null;
    private Resources resources = null;
    private XMLStreamReader xmlStreamReader = null;
    private Element element = null;
    private Object root = null;
    private String language = null;
    private int nextID = 0;
    private LinkedList<Attribute> namespaceBindingAttributes = new LinkedList();
    private static HashMap<String, String> fileExtensions = new HashMap();
    private static HashMap<String, Class<? extends Serializer<?>>> mimeTypes = new HashMap();
    public static final char URL_PREFIX = '@';
    public static final char RESOURCE_KEY_PREFIX = '%';
    public static final char OBJECT_REFERENCE_PREFIX = '$';
    public static final String NAMESPACE_BINDING_PREFIX = "${";
    public static final String NAMESPACE_BINDING_SUFFIX = "}";
    public static final String BIND_MAPPING_DELIMITER = ":";
    public static final String INTERNAL_ID_PREFIX = "$";
    public static final String LANGUAGE_PROCESSING_INSTRUCTION = "language";
    public static final String BXML_PREFIX = "bxml";
    public static final String BXML_EXTENSION = "bxml";
    public static final String ID_ATTRIBUTE = "id";
    public static final String INCLUDE_TAG = "include";
    public static final String INCLUDE_SRC_ATTRIBUTE = "src";
    public static final String INCLUDE_RESOURCES_ATTRIBUTE = "resources";
    public static final String INCLUDE_MIME_TYPE_ATTRIBUTE = "mimeType";
    public static final String INCLUDE_INLINE_ATTRIBUTE = "inline";
    public static final String SCRIPT_TAG = "script";
    public static final String SCRIPT_SRC_ATTRIBUTE = "src";
    public static final String DEFINE_TAG = "define";
    public static final String REFERENCE_TAG = "reference";
    public static final String REFERENCE_ID_ATTRIBUTE = "id";
    public static final String DEFAULT_LANGUAGE = "javascript";
    public static final String MIME_TYPE = "application/bxml";

    public BXMLSerializer() {
        this.xmlInputFactory = XMLInputFactory.newInstance();
        this.xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        this.scriptEngineManager = new ScriptEngineManager();
        this.scriptEngineManager.setBindings(new Bindings(){

            @Override
            public Object get(Object key) {
                return BXMLSerializer.this.namespace.get(key.toString());
            }

            @Override
            public Object put(String key, Object value) {
                return BXMLSerializer.this.namespace.put(key, value);
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> map) {
                for (String string : map.keySet()) {
                    this.put(string, map.get(string));
                }
            }

            @Override
            public Object remove(Object key) {
                return BXMLSerializer.this.namespace.remove(key.toString());
            }

            @Override
            public void clear() {
                BXMLSerializer.this.namespace.clear();
            }

            @Override
            public boolean containsKey(Object key) {
                return BXMLSerializer.this.namespace.containsKey(key.toString());
            }

            @Override
            public boolean containsValue(Object value) {
                boolean contains = false;
                for (String key : BXMLSerializer.this.namespace) {
                    if (!BXMLSerializer.this.namespace.get(key).equals(value)) continue;
                    contains = true;
                    break;
                }
                return contains;
            }

            @Override
            public boolean isEmpty() {
                return BXMLSerializer.this.namespace.isEmpty();
            }

            @Override
            public Set<String> keySet() {
                HashSet<String> keySet = new HashSet<String>();
                for (String key : BXMLSerializer.this.namespace) {
                    keySet.add(key);
                }
                return keySet;
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                java.util.HashMap hashMap = new java.util.HashMap();
                for (String key : BXMLSerializer.this.namespace) {
                    hashMap.put(key, BXMLSerializer.this.namespace.get(key));
                }
                return hashMap.entrySet();
            }

            @Override
            public int size() {
                return BXMLSerializer.this.namespace.getCount();
            }

            @Override
            public Collection<Object> values() {
                ArrayList<Object> values = new ArrayList<Object>();
                for (String key : BXMLSerializer.this.namespace) {
                    values.add(BXMLSerializer.this.namespace.get(key));
                }
                return values;
            }
        });
    }

    @Deprecated
    public BXMLSerializer(ClassLoader classLoader) {
        throw new UnsupportedOperationException("https://issues.apache.org/jira/browse/PIVOT-742");
    }

    @Override
    public Object readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        this.root = null;
        this.language = null;
        try {
            try {
                this.xmlStreamReader = this.xmlInputFactory.createXMLStreamReader(inputStream);
                while (this.xmlStreamReader.hasNext()) {
                    int event = this.xmlStreamReader.next();
                    switch (event) {
                        case 3: {
                            this.processProcessingInstruction();
                            break;
                        }
                        case 4: {
                            this.processCharacters();
                            break;
                        }
                        case 1: {
                            this.processStartElement();
                            break;
                        }
                        case 2: {
                            this.processEndElement();
                            break;
                        }
                    }
                }
            }
            catch (XMLStreamException exception) {
                throw new SerializationException(exception);
            }
        }
        catch (IOException exception) {
            this.logException();
            throw exception;
        }
        catch (SerializationException exception) {
            this.logException();
            throw exception;
        }
        catch (RuntimeException exception) {
            this.logException();
            throw exception;
        }
        this.xmlStreamReader = null;
        for (Attribute attribute : this.namespaceBindingAttributes) {
            ScriptBindMapping bindMapping;
            Element elementLocal = attribute.element;
            String sourcePath = (String)attribute.value;
            int i = sourcePath.indexOf(BIND_MAPPING_DELIMITER);
            if (i == -1) {
                bindMapping = null;
            } else {
                String bindFunction = sourcePath.substring(0, i);
                sourcePath = sourcePath.substring(i + 1);
                bindMapping = new ScriptBindMapping(this.scriptEngineManager.getEngineByName(this.language), bindFunction);
            }
            switch (elementLocal.type) {
                case INSTANCE: 
                case INCLUDE: {
                    if (elementLocal.id == null) {
                        elementLocal.id = INTERNAL_ID_PREFIX + Integer.toString(this.nextID++);
                        this.namespace.put(elementLocal.id, elementLocal.value);
                    }
                    String targetPath = elementLocal.id + "." + attribute.name;
                    NamespaceBinding namespaceBinding = new NamespaceBinding(this.namespace, sourcePath, targetPath, bindMapping);
                    namespaceBinding.bind();
                    break;
                }
                case READ_ONLY_PROPERTY: {
                    if (elementLocal.parent.id == null) {
                        elementLocal.parent.id = INTERNAL_ID_PREFIX + Integer.toString(this.nextID++);
                        this.namespace.put(elementLocal.parent.id, elementLocal.parent.value);
                    }
                    String targetPath = elementLocal.parent.id + "." + elementLocal.name + "." + attribute.name;
                    NamespaceBinding namespaceBinding = new NamespaceBinding(this.namespace, sourcePath, targetPath, bindMapping);
                    namespaceBinding.bind();
                    break;
                }
            }
        }
        this.namespaceBindingAttributes.clear();
        if (this.root instanceof Bindable) {
            Class<?> type = this.root.getClass();
            while (Bindable.class.isAssignableFrom(type)) {
                this.bind(this.root, type);
                type = type.getSuperclass();
            }
            Bindable bindable = (Bindable)this.root;
            bindable.initialize(this.namespace, this.location, this.resources);
        }
        return this.root;
    }

    public final Object readObject(Class<?> baseType, String resourceName) throws IOException, SerializationException {
        return this.readObject(baseType, resourceName, false);
    }

    public final Object readObject(Class<?> baseType, String resourceName, boolean localize) throws IOException, SerializationException {
        if (baseType == null) {
            throw new IllegalArgumentException("baseType is null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName is null.");
        }
        URL locationLocal = baseType.getResource(resourceName);
        if (locationLocal == null) {
            throw new IllegalArgumentException("could not find resource \"" + resourceName + "\".");
        }
        return this.readObject(locationLocal, localize ? new Resources(baseType.getName()) : null);
    }

    public final Object readObject(URL locationArgument) throws IOException, SerializationException {
        return this.readObject(locationArgument, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readObject(URL locationArgument, Resources resourcesArgument) throws IOException, SerializationException {
        Object object;
        if (locationArgument == null) {
            throw new IllegalArgumentException("location is null.");
        }
        this.location = locationArgument;
        this.resources = resourcesArgument;
        BufferedInputStream inputStream = new BufferedInputStream(locationArgument.openStream());
        try {
            object = this.readObject(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        this.location = null;
        this.resources = null;
        return object;
    }

    private void processProcessingInstruction() throws SerializationException {
        String piTarget = this.xmlStreamReader.getPITarget();
        String piData = this.xmlStreamReader.getPIData();
        if (piTarget.equals(LANGUAGE_PROCESSING_INSTRUCTION)) {
            if (this.language != null) {
                throw new SerializationException("language already set.");
            }
            this.language = piData;
        }
    }

    private void processCharacters() throws SerializationException {
        if (!this.xmlStreamReader.isWhiteSpace()) {
            String text = this.xmlStreamReader.getText();
            switch (this.element.type) {
                case INSTANCE: {
                    if (!(this.element.value instanceof Sequence)) break;
                    Sequence sequence = (Sequence)this.element.value;
                    try {
                        Method addMethod = sequence.getClass().getMethod("add", String.class);
                        addMethod.invoke((Object)sequence, text);
                        break;
                    }
                    catch (NoSuchMethodException exception) {
                        throw new SerializationException("Text content cannot be added to " + sequence.getClass().getName() + ": \"" + text + "\"", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new SerializationException(exception);
                    }
                    catch (IllegalAccessException exception) {
                        throw new SerializationException(exception);
                    }
                }
                case WRITABLE_PROPERTY: 
                case LISTENER_LIST_PROPERTY: 
                case SCRIPT: {
                    this.element.value = text;
                    break;
                }
                default: {
                    throw new SerializationException("Unexpected characters in " + (Object)((Object)this.element.type) + " element.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStartElement() throws IOException, SerializationException {
        String name;
        Element.Type elementType;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.language == null) {
            this.language = DEFAULT_LANGUAGE;
        }
        String namespaceURI = this.xmlStreamReader.getNamespaceURI();
        String prefix = this.xmlStreamReader.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        String localName = this.xmlStreamReader.getLocalName();
        Class<?> propertyClass = null;
        Object value = null;
        if (prefix != null && prefix.equals("bxml")) {
            if (this.element == null) {
                throw new SerializationException("Invalid root element.");
            }
            if (localName.equals(INCLUDE_TAG)) {
                elementType = Element.Type.INCLUDE;
            } else if (localName.equals(SCRIPT_TAG)) {
                elementType = Element.Type.SCRIPT;
            } else if (localName.equals(DEFINE_TAG)) {
                elementType = Element.Type.DEFINE;
            } else if (localName.equals(REFERENCE_TAG)) {
                elementType = Element.Type.REFERENCE;
            } else {
                throw new SerializationException("Invalid element.");
            }
            name = "<" + prefix + BIND_MAPPING_DELIMITER + localName + ">";
        } else if (Character.isUpperCase(localName.charAt(0))) {
            int i = localName.indexOf(46);
            if (i != -1 && Character.isLowerCase(localName.charAt(i + 1))) {
                elementType = Element.Type.WRITABLE_PROPERTY;
                name = localName.substring(i + 1);
                String propertyClassName = namespaceURI + "." + localName.substring(0, i);
                try {
                    propertyClass = Class.forName(propertyClassName, true, classLoader);
                }
                catch (Throwable exception) {
                    throw new SerializationException(exception);
                }
            } else {
                if (namespaceURI == null) {
                    throw new SerializationException("No XML namespace specified for " + localName + " tag.");
                }
                elementType = Element.Type.INSTANCE;
                name = "<" + (prefix == null ? "" : prefix + BIND_MAPPING_DELIMITER) + localName + ">";
                String className = namespaceURI + "." + localName.replace('.', '$');
                try {
                    Class<?> type = Class.forName(className, true, classLoader);
                    value = this.newTypedObject(type);
                }
                catch (Throwable exception) {
                    throw new SerializationException(exception);
                }
            }
        } else {
            if (prefix != null) {
                throw new SerializationException("Property elements cannot have a namespace prefix.");
            }
            if (this.element.value instanceof Dictionary) {
                elementType = Element.Type.WRITABLE_PROPERTY;
            } else {
                BeanAdapter beanAdapter = new BeanAdapter(this.element.value);
                if (beanAdapter.isReadOnly(localName)) {
                    Class<?> propertyType = beanAdapter.getType(localName);
                    if (propertyType == null) {
                        throw new SerializationException("\"" + localName + "\" is not a valid property of element " + this.element.name + ".");
                    }
                    if (ListenerList.class.isAssignableFrom(propertyType)) {
                        elementType = Element.Type.LISTENER_LIST_PROPERTY;
                    } else {
                        elementType = Element.Type.READ_ONLY_PROPERTY;
                        value = beanAdapter.get(localName);
                        assert (value != null) : "Read-only properties cannot be null.";
                    }
                } else {
                    elementType = Element.Type.WRITABLE_PROPERTY;
                }
            }
            name = localName;
        }
        this.element = new Element(this.element, elementType, name, propertyClass, value);
        this.processAttributes();
        if (elementType == Element.Type.INCLUDE) {
            Serializer<?> serializer;
            Class<? extends Serializer<?>> serializerClass;
            int i;
            if (!this.element.properties.containsKey("src")) {
                throw new SerializationException("src attribute is required for bxml:include tag.");
            }
            String src = this.element.properties.get("src");
            if (src.charAt(0) == '$' && (src = src.substring(1)).length() > 0) {
                String variableValue;
                if (!JSON.containsKey(this.namespace, src)) {
                    throw new SerializationException("Value \"" + src + "\" is not defined.");
                }
                src = variableValue = (String)JSON.get(this.namespace, src);
            }
            Resources resourcesLocal = this.resources;
            if (this.element.properties.containsKey(INCLUDE_RESOURCES_ATTRIBUTE)) {
                resourcesLocal = new Resources(resourcesLocal, this.element.properties.get(INCLUDE_RESOURCES_ATTRIBUTE));
            }
            String mimeType = null;
            if (this.element.properties.containsKey(INCLUDE_MIME_TYPE_ATTRIBUTE)) {
                mimeType = this.element.properties.get(INCLUDE_MIME_TYPE_ATTRIBUTE);
            }
            if (mimeType == null && (i = src.lastIndexOf(".")) != -1) {
                String extension = src.substring(i + 1);
                mimeType = fileExtensions.get(extension);
            }
            if (mimeType == null) {
                throw new SerializationException("Cannot determine MIME type of include \"" + src + "\".");
            }
            boolean inline = false;
            if (this.element.properties.containsKey(INCLUDE_INLINE_ATTRIBUTE)) {
                inline = Boolean.parseBoolean(this.element.properties.get(INCLUDE_INLINE_ATTRIBUTE));
            }
            if ((serializerClass = mimeTypes.get(mimeType)) == null) {
                throw new SerializationException("No serializer associated with MIME type " + mimeType + ".");
            }
            try {
                serializer = this.newIncludeSerializer(serializerClass);
            }
            catch (InstantiationException exception) {
                throw new SerializationException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new SerializationException(exception);
            }
            URL locationLocal = src.charAt(0) == '/' ? classLoader.getResource(src.substring(1)) : new URL(this.location, src);
            if (serializer instanceof Resolvable) {
                Resolvable resolvable = (Resolvable)((Object)serializer);
                if (inline) {
                    resolvable.setNamespace(this.namespace);
                }
                resolvable.setLocation(locationLocal);
                resolvable.setResources(resourcesLocal);
            }
            BufferedInputStream inputStream = new BufferedInputStream(locationLocal.openStream());
            try {
                this.element.value = serializer.readObject(inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        if (this.element.type == Element.Type.REFERENCE) {
            if (!this.element.properties.containsKey("id")) {
                throw new SerializationException("id attribute is required for bxml:reference tag.");
            }
            String id = this.element.properties.get("id");
            if (!this.namespace.containsKey(id)) {
                throw new SerializationException("A value with ID \"" + id + "\" does not exist.");
            }
            this.element.value = this.namespace.get(id);
        }
        if (this.element.id != null) {
            this.namespace.put(this.element.id, this.element.value);
            Class<?> type = this.element.value.getClass();
            IDProperty idProperty = type.getAnnotation(IDProperty.class);
            if (idProperty != null) {
                BeanAdapter beanAdapter = new BeanAdapter(this.element.value);
                beanAdapter.put(idProperty.value(), (Object)this.element.id);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAttributes() throws SerializationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int n = this.xmlStreamReader.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String name;
            String prefix = this.xmlStreamReader.getAttributePrefix(i);
            String localName = this.xmlStreamReader.getAttributeLocalName(i);
            String value = this.xmlStreamReader.getAttributeValue(i);
            if (prefix != null && prefix.equals("bxml")) {
                if (!localName.equals("id")) throw new SerializationException("bxml:" + localName + " is not a valid attribute.");
                if (value.length() == 0 || value.contains(".")) {
                    throw new IllegalArgumentException("\"" + value + "\" is not a valid ID value.");
                }
                if (this.namespace.containsKey(value)) {
                    throw new SerializationException("ID " + value + " is already in use.");
                }
                if (this.element.type != Element.Type.INSTANCE && this.element.type != Element.Type.INCLUDE) {
                    throw new SerializationException("An ID cannot be assigned to this element.");
                }
                this.element.id = value;
                continue;
            }
            boolean property = false;
            switch (this.element.type) {
                case INCLUDE: {
                    property = localName.equals("src") || localName.equals(INCLUDE_RESOURCES_ATTRIBUTE) || localName.equals(INCLUDE_MIME_TYPE_ATTRIBUTE) || localName.equals(INCLUDE_INLINE_ATTRIBUTE);
                    break;
                }
                case SCRIPT: {
                    property = localName.equals("src");
                    break;
                }
                case REFERENCE: {
                    property = localName.equals("id");
                    break;
                }
            }
            if (property) {
                this.element.properties.put(localName, value);
                continue;
            }
            Class<?> propertyClass = null;
            if (Character.isUpperCase(localName.charAt(0))) {
                int j = localName.indexOf(46);
                name = localName.substring(j + 1);
                String namespaceURI = this.xmlStreamReader.getAttributeNamespace(i);
                if (namespaceURI == null || namespaceURI.isEmpty()) {
                    namespaceURI = this.xmlStreamReader.getNamespaceURI("");
                }
                String propertyClassName = namespaceURI + "." + localName.substring(0, j);
                try {
                    propertyClass = Class.forName(propertyClassName, true, classLoader);
                }
                catch (Throwable exception) {
                    throw new SerializationException(exception);
                }
            } else {
                name = localName;
            }
            if (value.startsWith(NAMESPACE_BINDING_PREFIX) && value.endsWith(NAMESPACE_BINDING_SUFFIX)) {
                if (propertyClass != null) {
                    throw new SerializationException("Namespace binding is not supported for static properties.");
                }
                this.namespaceBindingAttributes.add(new Attribute(this.element, name, propertyClass, value.substring(2, value.length() - 1)));
                continue;
            }
            Attribute attribute = new Attribute(this.element, name, propertyClass, value);
            if (value.length() > 0) {
                if (value.charAt(0) == '@') {
                    if ((value = value.substring(1)).length() <= 0) throw new SerializationException("Invalid URL resolution argument.");
                    if (value.charAt(0) == '@') {
                        attribute.value = value;
                    } else {
                        if (this.location == null) {
                            throw new IllegalStateException("Base location is undefined.");
                        }
                        try {
                            attribute.value = new URL(this.location, value);
                        }
                        catch (MalformedURLException exception) {
                            throw new SerializationException(exception);
                        }
                    }
                } else if (value.charAt(0) == '%') {
                    if ((value = value.substring(1)).length() <= 0) throw new SerializationException("Invalid resource resolution argument.");
                    attribute.value = value.charAt(0) == '%' ? value : (this.resources != null && JSON.containsKey(this.resources, value) ? JSON.get((Object)this.resources, value) : value);
                } else if (value.charAt(0) == '$') {
                    if ((value = value.substring(1)).length() <= 0) throw new SerializationException("Invalid object resolution argument.");
                    if (value.charAt(0) == '$') {
                        attribute.value = value;
                    } else if (value.equals("bxml:" + null)) {
                        attribute.value = null;
                    } else {
                        if (!JSON.containsKey(this.namespace, value)) {
                            throw new SerializationException("Value \"" + value + "\" is not defined.");
                        }
                        attribute.value = JSON.get(this.namespace, value);
                    }
                }
            }
            this.element.attributes.add(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEndElement() throws SerializationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        switch (this.element.type) {
            case INSTANCE: 
            case INCLUDE: 
            case REFERENCE: {
                for (Attribute attribute : this.element.attributes) {
                    if (attribute.propertyClass == null) {
                        Dictionary dictionary = this.element.value instanceof Dictionary ? (Dictionary)this.element.value : new BeanAdapter(this.element.value);
                        dictionary.put(attribute.name, attribute.value);
                        continue;
                    }
                    if (attribute.propertyClass.isInterface()) {
                        Method addMethod;
                        Object listenerList;
                        Method getListenerListMethod;
                        String listenerClassName = attribute.propertyClass.getName();
                        listenerClassName = listenerClassName.substring(listenerClassName.lastIndexOf(46) + 1);
                        String getListenerListMethodName = "get" + Character.toUpperCase(listenerClassName.charAt(0)) + listenerClassName.substring(1) + "s";
                        try {
                            Class<?> type = this.element.value.getClass();
                            getListenerListMethod = type.getMethod(getListenerListMethodName, new Class[0]);
                        }
                        catch (NoSuchMethodException exception) {
                            throw new SerializationException(exception);
                        }
                        try {
                            listenerList = getListenerListMethod.invoke(this.element.value, new Object[0]);
                        }
                        catch (InvocationTargetException exception) {
                            throw new SerializationException(exception);
                        }
                        catch (IllegalAccessException exception) {
                            throw new SerializationException(exception);
                        }
                        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.language);
                        AttributeInvocationHandler handler = new AttributeInvocationHandler(scriptEngine, attribute.name, (String)attribute.value);
                        Object listener = Proxy.newProxyInstance(classLoader, new Class[]{attribute.propertyClass}, (InvocationHandler)handler);
                        Class<?> listenerListClass = listenerList.getClass();
                        try {
                            addMethod = listenerListClass.getMethod("add", Object.class);
                        }
                        catch (NoSuchMethodException exception) {
                            throw new RuntimeException(exception);
                        }
                        try {
                            addMethod.invoke(listenerList, listener);
                            continue;
                        }
                        catch (IllegalAccessException exception) {
                            throw new SerializationException(exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new SerializationException(exception);
                        }
                    }
                    BXMLSerializer.setStaticProperty(this.element.value, attribute.propertyClass, attribute.name, attribute.value);
                }
                if (this.element.parent == null) break;
                if (this.element.parent.type == Element.Type.WRITABLE_PROPERTY) {
                    this.element.parent.value = this.element.value;
                    break;
                }
                if (this.element.parent.value == null) break;
                Class<?> parentType = this.element.parent.value.getClass();
                DefaultProperty defaultProperty = parentType.getAnnotation(DefaultProperty.class);
                if (defaultProperty == null) {
                    if (this.element.parent.value instanceof Sequence) {
                        Sequence sequence = (Sequence)this.element.parent.value;
                        sequence.add(this.element.value);
                        break;
                    }
                    throw new SerializationException(this.element.parent.value.getClass() + " is not a sequence.");
                }
                BeanAdapter beanAdapter = new BeanAdapter(this.element.parent.value);
                String defaultPropertyName = defaultProperty.value();
                Object defaultPropertyValue = beanAdapter.get(defaultPropertyName);
                if (defaultPropertyValue instanceof Sequence) {
                    Sequence sequence = (Sequence)defaultPropertyValue;
                    try {
                        sequence.add(this.element.value);
                    }
                    catch (UnsupportedOperationException uoe) {
                        beanAdapter.put(defaultPropertyName, this.element.value);
                    }
                    break;
                }
                beanAdapter.put(defaultPropertyName, this.element.value);
                break;
            }
            case READ_ONLY_PROPERTY: {
                Dictionary dictionary = this.element.value instanceof Dictionary ? (Dictionary)this.element.value : new BeanAdapter(this.element.value);
                for (Attribute attribute : this.element.attributes) {
                    if (attribute.propertyClass != null) {
                        throw new SerializationException("Static setters are not supported for read-only properties.");
                    }
                    dictionary.put(attribute.name, attribute.value);
                }
                break;
            }
            case WRITABLE_PROPERTY: {
                if (this.element.propertyClass == null) {
                    Dictionary dictionary = this.element.parent.value instanceof Dictionary ? (Dictionary)this.element.parent.value : new BeanAdapter(this.element.parent.value);
                    dictionary.put(this.element.name, this.element.value);
                    break;
                }
                if (this.element.parent == null) {
                    throw new SerializationException("Element does not have a parent.");
                }
                if (this.element.parent.value == null) {
                    throw new SerializationException("Parent value is null.");
                }
                BXMLSerializer.setStaticProperty(this.element.parent.value, this.element.propertyClass, this.element.name, this.element.value);
                break;
            }
            case LISTENER_LIST_PROPERTY: {
                Method addMethod;
                String script = (String)this.element.value;
                ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.language);
                if (scriptEngine == null) {
                    throw new SerializationException("Script engine for \"" + this.language + "\" not found.");
                }
                scriptEngine.setBindings(new SimpleBindings(), 100);
                try {
                    scriptEngine.eval(script);
                }
                catch (ScriptException exception) {
                    System.err.println(exception);
                    break;
                }
                BeanAdapter beanAdapter = new BeanAdapter(this.element.parent.value);
                ListenerList listenerList = (ListenerList)beanAdapter.get(this.element.name);
                Class<?> listenerListClass = listenerList.getClass();
                Type[] genericInterfaces = listenerListClass.getGenericInterfaces();
                Class listenerClass = (Class)genericInterfaces[0];
                ElementInvocationHandler handler = new ElementInvocationHandler(scriptEngine);
                try {
                    addMethod = listenerListClass.getMethod("add", Object.class);
                }
                catch (NoSuchMethodException exception) {
                    throw new RuntimeException(exception);
                }
                Object listener = Proxy.newProxyInstance(classLoader, new Class[]{listenerClass}, (InvocationHandler)handler);
                try {
                    addMethod.invoke((Object)listenerList, listener);
                    break;
                }
                catch (IllegalAccessException exception) {
                    throw new SerializationException(exception);
                }
                catch (InvocationTargetException exception) {
                    throw new SerializationException(exception);
                }
            }
            case SCRIPT: {
                String src = null;
                if (this.element.properties.containsKey("src")) {
                    src = this.element.properties.get("src");
                }
                if (src != null) {
                    int i = src.lastIndexOf(".");
                    if (i == -1) {
                        throw new SerializationException("Cannot determine type of script \"" + src + "\".");
                    }
                    String extension = src.substring(i + 1);
                    ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension(extension);
                    if (scriptEngine == null) {
                        throw new SerializationException("Unable to find scripting engine for extension " + extension + ".");
                    }
                    scriptEngine.setBindings(this.scriptEngineManager.getBindings(), 100);
                    try {
                        URL scriptLocation = src.charAt(0) == '/' ? classLoader.getResource(src.substring(1)) : new URL(this.location, src);
                        BufferedReader scriptReader = null;
                        try {
                            scriptReader = new BufferedReader(new InputStreamReader(scriptLocation.openStream()));
                            scriptEngine.eval(scriptReader);
                        }
                        catch (ScriptException exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            if (scriptReader != null) {
                                scriptReader.close();
                            }
                        }
                    }
                    catch (IOException exception) {
                        throw new SerializationException(exception);
                    }
                }
                if (this.element.value == null) break;
                String script = (String)this.element.value;
                ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByName(this.language);
                if (scriptEngine == null) {
                    throw new SerializationException("Unable to find scripting engine for language \"" + this.language + "\".");
                }
                scriptEngine.setBindings(this.scriptEngineManager.getBindings(), 100);
                try {
                    scriptEngine.eval(script);
                }
                catch (ScriptException exception) {
                    System.err.println(exception);
                    System.err.println(script);
                }
                break;
            }
            case DEFINE: {
                break;
            }
        }
        if (this.element.parent == null) {
            this.root = this.element.value;
        }
        this.element = this.element.parent;
    }

    public Location getCurrentLocation() {
        return this.xmlStreamReader.getLocation();
    }

    private void logException() {
        Location streamReaderlocation = this.xmlStreamReader.getLocation();
        String message = "An error occurred at line number " + streamReaderlocation.getLineNumber();
        if (this.location != null) {
            message = message + " in file " + this.location.getPath();
        }
        message = message + BIND_MAPPING_DELIMITER;
        System.err.println(message);
    }

    @Override
    public void writeObject(Object object, OutputStream outputStream) throws IOException, SerializationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMIMEType(Object object) {
        return MIME_TYPE;
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public org.apache.pivot.collections.Map<String, Object> getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(org.apache.pivot.collections.Map<String, Object> namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        this.namespace = namespace;
    }

    @Override
    public URL getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(URL location) {
        this.location = location;
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void bind(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.bind(object, object.getClass());
    }

    public void bind(Object object, Class<?> type) throws BindException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (!type.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException();
        }
        for (Field field : type.getDeclaredFields()) {
            String id;
            String fieldName = field.getName();
            int fieldModifiers = field.getModifiers();
            BXML bindingAnnotation = field.getAnnotation(BXML.class);
            if (bindingAnnotation == null) continue;
            if ((fieldModifiers & 0x10) > 0) {
                throw new BindException(fieldName + " is final.");
            }
            if ((fieldModifiers & 1) == 0) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException exception) {
                    throw new BindException(fieldName + " is not accessible.");
                }
            }
            if ((id = bindingAnnotation.id()).equals("\u0000")) {
                id = field.getName();
            }
            if (!this.namespace.containsKey(id)) continue;
            Object value = this.namespace.get(id);
            try {
                field.set(object, value);
            }
            catch (IllegalAccessException exception) {
                throw new BindException(exception);
            }
        }
    }

    protected Serializer<?> newIncludeSerializer(Class<? extends Serializer<?>> type) throws InstantiationException, IllegalAccessException {
        return type.newInstance();
    }

    protected Object newTypedObject(Class<?> type) throws InstantiationException, IllegalAccessException {
        return type.newInstance();
    }

    protected final XMLStreamReader getXMLStreamReader() {
        return new StreamReaderDelegate(this.xmlStreamReader){

            @Override
            public void close() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int next() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int nextTag() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static org.apache.pivot.collections.Map<String, String> getFileExtensions() {
        return fileExtensions;
    }

    public static org.apache.pivot.collections.Map<String, Class<? extends Serializer<?>>> getMimeTypes() {
        return mimeTypes;
    }

    private static Method getStaticGetterMethod(Class<?> propertyClass, String propertyName, Class<?> objectType) {
        Method method = null;
        if (objectType != null) {
            try {
                method = propertyClass.getMethod("get" + propertyName, objectType);
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = propertyClass.getMethod("is" + propertyName, objectType);
                }
                catch (NoSuchMethodException exception) {
                    // empty catch block
                }
            }
            if (method == null) {
                method = BXMLSerializer.getStaticGetterMethod(propertyClass, propertyName, objectType.getSuperclass());
            }
        }
        return method;
    }

    private static Method getStaticSetterMethod(Class<?> propertyClass, String propertyName, Class<?> objectType, Class<?> propertyValueType) {
        Method method = null;
        if (objectType != null) {
            String methodName = "set" + propertyName;
            try {
                method = propertyClass.getMethod(methodName, objectType, propertyValueType);
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
            if (method == null) {
                try {
                    Field primitiveTypeField = propertyValueType.getField("TYPE");
                    Class primitivePropertyValueType = (Class)primitiveTypeField.get(null);
                    try {
                        method = propertyClass.getMethod(methodName, objectType, primitivePropertyValueType);
                    }
                    catch (NoSuchMethodException exception) {}
                }
                catch (NoSuchFieldException exception) {
                }
                catch (IllegalAccessException exception) {
                    // empty catch block
                }
            }
            if (method == null) {
                method = BXMLSerializer.getStaticSetterMethod(propertyClass, propertyName, objectType.getSuperclass(), propertyValueType);
            }
        }
        return method;
    }

    private static void setStaticProperty(Object object, Class<?> propertyClass, String propertyName, Object value) throws SerializationException {
        Method getterMethod;
        Class<?> objectType = object.getClass();
        String propertyNameUpdated = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Object valueToAssign = value;
        Method setterMethod = null;
        if (valueToAssign != null) {
            setterMethod = BXMLSerializer.getStaticSetterMethod(propertyClass, propertyNameUpdated, objectType, valueToAssign.getClass());
        }
        if (setterMethod == null && (getterMethod = BXMLSerializer.getStaticGetterMethod(propertyClass, propertyNameUpdated, objectType)) != null) {
            Class<?> propertyType = getterMethod.getReturnType();
            setterMethod = BXMLSerializer.getStaticSetterMethod(propertyClass, propertyNameUpdated, objectType, propertyType);
            if (valueToAssign instanceof String) {
                valueToAssign = BeanAdapter.coerce((String)valueToAssign, propertyType);
            }
        }
        if (setterMethod == null) {
            throw new SerializationException(propertyClass.getName() + "." + propertyNameUpdated + " is not valid static property.");
        }
        try {
            setterMethod.invoke(null, object, valueToAssign);
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    static {
        mimeTypes.put(MIME_TYPE, BXMLSerializer.class);
        mimeTypes.put("application/x-java-serialized-object", BinarySerializer.class);
        mimeTypes.put("application/octet-stream", ByteArraySerializer.class);
        mimeTypes.put("text/csv", CSVSerializer.class);
        mimeTypes.put("application/json", JSONSerializer.class);
        mimeTypes.put("text/plain", PropertiesSerializer.class);
        fileExtensions.put("bxml", MIME_TYPE);
        fileExtensions.put("csv", "text/csv");
        fileExtensions.put("json", "application/json");
        fileExtensions.put("properties", "text/plain");
    }

    private static class ScriptBindMapping
    implements NamespaceBinding.BindMapping {
        private ScriptEngine scriptEngine;
        private String functionName;

        public ScriptBindMapping(ScriptEngine scriptEngine, String functionName) {
            this.scriptEngine = scriptEngine;
            this.functionName = functionName;
        }

        @Override
        public Object evaluate(Object value) {
            Object result = value;
            Bindings bindings = this.scriptEngine.getBindings(200);
            if (bindings.containsKey(this.functionName)) {
                Invocable invocable;
                try {
                    invocable = (Invocable)((Object)this.scriptEngine);
                }
                catch (ClassCastException exception) {
                    throw new RuntimeException(exception);
                }
                try {
                    result = invocable.invokeFunction(this.functionName, result);
                }
                catch (NoSuchMethodException exception) {
                    throw new RuntimeException(exception);
                }
                catch (ScriptException exception) {
                    throw new RuntimeException(exception);
                }
            }
            throw new RuntimeException("Mapping function \"" + this.functionName + "\" is not defined.");
            return result;
        }
    }

    private static class ElementInvocationHandler
    implements InvocationHandler {
        private ScriptEngine scriptEngine;

        public ElementInvocationHandler(ScriptEngine scriptEngine) {
            this.scriptEngine = scriptEngine;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            String methodName = method.getName();
            Bindings bindings = this.scriptEngine.getBindings(100);
            if (bindings.containsKey(methodName)) {
                Invocable invocable;
                try {
                    invocable = (Invocable)((Object)this.scriptEngine);
                }
                catch (ClassCastException exception) {
                    throw new SerializationException(exception);
                }
                result = invocable.invokeFunction(methodName, args);
            }
            if (result == null) {
                Class<?> returnType = method.getReturnType();
                if (returnType == Vote.class) {
                    result = Vote.APPROVE;
                } else if (returnType == Boolean.TYPE) {
                    result = false;
                }
            }
            return result;
        }
    }

    private static class AttributeInvocationHandler
    implements InvocationHandler {
        private ScriptEngine scriptEngine;
        private String event;
        private String script;
        private static final String ARGUMENTS_KEY = "arguments";

        public AttributeInvocationHandler(ScriptEngine scriptEngine, String event, String script) {
            this.scriptEngine = scriptEngine;
            this.event = event;
            this.script = script;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> returnType;
            Object result = null;
            String methodName = method.getName();
            if (methodName.equals(this.event)) {
                try {
                    SimpleBindings bindings = new SimpleBindings();
                    bindings.put(ARGUMENTS_KEY, (Object)args);
                    this.scriptEngine.setBindings(bindings, 100);
                    this.scriptEngine.eval(this.script);
                }
                catch (ScriptException exception) {
                    System.err.println(exception);
                    System.err.println(this.script);
                }
            }
            if ((returnType = method.getReturnType()) == Vote.class) {
                result = Vote.APPROVE;
            } else if (returnType == Boolean.TYPE) {
                result = false;
            }
            return result;
        }
    }

    private static class Attribute {
        public final Element element;
        public final String name;
        public final Class<?> propertyClass;
        public Object value;

        public Attribute(Element element, String name, Class<?> propertyClass, Object value) {
            this.element = element;
            this.name = name;
            this.propertyClass = propertyClass;
            this.value = value;
        }
    }

    private static class Element {
        public final Element parent;
        public final Type type;
        public final Class<?> propertyClass;
        public final String name;
        public Object value;
        public String id = null;
        public final HashMap<String, String> properties = new HashMap();
        public final LinkedList<Attribute> attributes = new LinkedList();

        public Element(Element parent, Type type, String name, Class<?> propertyClass, Object value) {
            this.parent = parent;
            this.type = type;
            this.name = name;
            this.propertyClass = propertyClass;
            this.value = value;
        }

        public static enum Type {
            INSTANCE,
            READ_ONLY_PROPERTY,
            WRITABLE_PROPERTY,
            LISTENER_LIST_PROPERTY,
            INCLUDE,
            SCRIPT,
            DEFINE,
            REFERENCE;

        }
    }
}

