/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.beans;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.apache.pivot.beans.BeanAdapter;
import org.apache.pivot.beans.PropertyChangeListener;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.HashSet;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;

public class BeanMonitor {
    private Object bean = null;
    private HashMap<Class<?>, Object> beanListenerProxies = new HashMap();
    private BeanInvocationHandler invocationHandler = new BeanInvocationHandler();
    private HashSet<String> notifyingProperties = new HashSet();
    private PropertyChangeListenerList propertyChangeListeners = new PropertyChangeListenerList();
    public static final String LISTENERS_SUFFIX = "Listeners";
    public static final String PROPERTY_CHANGE_SUFFIX = "Changed";

    public BeanMonitor(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException();
        }
        this.bean = bean;
        BeanAdapter beanAdapter = new BeanAdapter(bean);
        Method[] methods = bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            ParameterizedType genericType;
            Type[] typeArguments;
            Method method = methods[i];
            if (!ListenerList.class.isAssignableFrom(method.getReturnType()) || (method.getModifiers() & 8) != 0 || (typeArguments = (genericType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class listenerInterface = (Class)typeArguments[0];
            if (!listenerInterface.isInterface()) {
                throw new RuntimeException(listenerInterface.getName() + " is not an interface.");
            }
            Method[] interfaceMethods = listenerInterface.getMethods();
            for (int j = 0; j < interfaceMethods.length; ++j) {
                String propertyName;
                Method interfaceMethod = interfaceMethods[j];
                String interfaceMethodName = interfaceMethod.getName();
                if (!interfaceMethodName.endsWith(PROPERTY_CHANGE_SUFFIX) || !beanAdapter.containsKey(propertyName = interfaceMethodName.substring(0, interfaceMethodName.length() - PROPERTY_CHANGE_SUFFIX.length()))) continue;
                this.notifyingProperties.add(propertyName);
            }
        }
    }

    public Object getBean() {
        return this.bean;
    }

    public boolean isNotifying(String key) {
        return this.notifyingProperties.contains(key);
    }

    private void registerBeanListeners() {
        Method[] methods = this.bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method addMethod;
            Object listenerList;
            ParameterizedType genericType;
            Type[] typeArguments;
            Method method = methods[i];
            if (!ListenerList.class.isAssignableFrom(method.getReturnType()) || (method.getModifiers() & 8) != 0 || (typeArguments = (genericType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class listenerInterface = (Class)typeArguments[0];
            try {
                listenerList = method.invoke(this.bean, new Object[0]);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            Object listener = this.beanListenerProxies.get(listenerInterface);
            if (listener == null) {
                listener = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)this.invocationHandler);
                this.beanListenerProxies.put(listenerInterface, listener);
            }
            Class<?> listenerListClass = listenerList.getClass();
            try {
                addMethod = listenerListClass.getMethod("add", Object.class);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException(exception);
            }
            try {
                addMethod.invoke(listenerList, listener);
                continue;
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void unregisterBeanListeners() {
        Method[] methods = this.bean.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method removeMethod;
            Object listenerList;
            ParameterizedType genericType;
            Type[] typeArguments;
            Method method = methods[i];
            if (!ListenerList.class.isAssignableFrom(method.getReturnType()) || (method.getModifiers() & 8) != 0 || (typeArguments = (genericType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
            Class listenerInterface = (Class)typeArguments[0];
            try {
                listenerList = method.invoke(this.bean, new Object[0]);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            Object listener = this.beanListenerProxies.get(listenerInterface);
            if (listener == null) {
                throw new IllegalStateException("Listener proxy is null.");
            }
            Class<?> listenerListClass = listenerList.getClass();
            try {
                removeMethod = listenerListClass.getMethod("remove", Object.class);
            }
            catch (NoSuchMethodException exception) {
                throw new RuntimeException(exception);
            }
            try {
                removeMethod.invoke(listenerList, listener);
                continue;
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public ListenerList<PropertyChangeListener> getPropertyChangeListeners() {
        return this.propertyChangeListeners;
    }

    private class PropertyChangeListenerList
    extends ListenerList<PropertyChangeListener>
    implements PropertyChangeListener {
        private PropertyChangeListenerList() {
        }

        @Override
        public void add(PropertyChangeListener listener) {
            if (this.isEmpty()) {
                BeanMonitor.this.registerBeanListeners();
            }
            super.add(listener);
        }

        @Override
        public void remove(PropertyChangeListener listener) {
            super.remove(listener);
            if (this.isEmpty()) {
                BeanMonitor.this.unregisterBeanListeners();
            }
        }

        @Override
        public void propertyChanged(Object beanArgument, String propertyName) {
            for (PropertyChangeListener listener : this) {
                listener.propertyChanged(beanArgument, propertyName);
            }
        }
    }

    private class BeanInvocationHandler
    implements InvocationHandler {
        private BeanInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method event, Object[] arguments) throws Throwable {
            String eventName = event.getName();
            if (eventName.endsWith(BeanMonitor.PROPERTY_CHANGE_SUFFIX)) {
                String propertyName = eventName.substring(0, eventName.length() - BeanMonitor.PROPERTY_CHANGE_SUFFIX.length());
                if (BeanMonitor.this.notifyingProperties.contains(propertyName)) {
                    BeanMonitor.this.propertyChangeListeners.propertyChanged(BeanMonitor.this.bean, propertyName);
                }
            }
            Object result = null;
            Class<?> returnType = event.getReturnType();
            if (returnType == Vote.class) {
                result = Vote.APPROVE;
            } else if (returnType == Boolean.TYPE) {
                result = false;
            }
            return result;
        }
    }
}

