/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.collections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.LinkedList;
import org.apache.pivot.collections.Stack;
import org.apache.pivot.collections.StackListener;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;

public class LinkedStack<T>
implements Stack<T>,
Serializable {
    private static final long serialVersionUID = -6276454328308188689L;
    private LinkedList<T> linkedList = new LinkedList();
    private transient Stack.StackListenerList<T> stackListeners = new Stack.StackListenerList();

    public LinkedStack() {
        this(null);
    }

    public LinkedStack(Comparator<T> comparator) {
        this.setComparator(comparator);
    }

    @Override
    public void push(T item) {
        this.linkedList.add(item);
        this.stackListeners.itemPushed(this, item);
    }

    @Override
    public T pop() {
        int length = this.linkedList.getLength();
        if (length == 0) {
            throw new IllegalStateException("queue is empty");
        }
        T item = this.linkedList.remove(length - 1, 1).get(0);
        this.stackListeners.itemPopped(this, item);
        return item;
    }

    @Override
    public T peek() {
        T item = null;
        int length = this.linkedList.getLength();
        if (length > 0) {
            item = this.linkedList.get(length - 1);
        }
        return item;
    }

    @Override
    public void clear() {
        if (this.linkedList.getLength() > 0) {
            this.linkedList.clear();
            this.stackListeners.stackCleared(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.getLength() == 0;
    }

    @Override
    public int getDepth() {
        return this.linkedList.getLength();
    }

    @Override
    public Comparator<T> getComparator() {
        return this.linkedList.getComparator();
    }

    @Override
    public void setComparator(Comparator<T> comparator) {
        Comparator<T> previousComparator = this.getComparator();
        this.linkedList.setComparator(comparator);
        this.stackListeners.comparatorChanged(this, previousComparator);
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator(this.linkedList.iterator());
    }

    @Override
    public ListenerList<StackListener<T>> getStackListeners() {
        return this.stackListeners;
    }
}

