/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class FileSerializer
implements Serializer<File> {
    private File tempFileDirectory;
    public static final int BUFFER_SIZE = 1024;
    private static final MimetypesFileTypeMap MIME_TYPES_FILE_MAP = new MimetypesFileTypeMap();

    public FileSerializer() {
        this(null);
    }

    public FileSerializer(File tempFileDirectory) {
        if (tempFileDirectory != null && !tempFileDirectory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.tempFileDirectory = tempFileDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File readObject(InputStream inputStream) throws IOException, SerializationException {
        File file = File.createTempFile(this.getClass().getName(), null, this.tempFileDirectory);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file), 1024);
            int data = inputStream.read();
            while (data != -1) {
                outputStream.write((byte)data);
                data = inputStream.read();
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(File file, OutputStream outputStream) throws IOException, SerializationException {
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file), 1024);
            int data = inputStream.read();
            while (data != -1) {
                outputStream.write((byte)data);
                data = inputStream.read();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public String getMIMEType(File file) {
        return MIME_TYPES_FILE_MAP.getContentType(file);
    }
}

