/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.serialization;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;

public class ByteArraySerializer
implements Serializer<byte[]> {
    public static final String MIME_TYPE = "application/octet-stream";
    public static final int BUFFER_SIZE = 2048;

    @Override
    public byte[] readObject(InputStream inputStream) throws IOException, SerializationException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null.");
        }
        byte[] result = null;
        try {
            int read;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((read = bufferedInputStream.read(buffer)) != -1) {
                byteOutputStream.write(buffer, 0, read);
            }
            byteOutputStream.flush();
            result = byteOutputStream.toByteArray();
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
        return result;
    }

    @Override
    public void writeObject(byte[] bytes, OutputStream outputStream) throws IOException, SerializationException {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array is null.");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream is null.");
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            bufferedOutputStream.write(bytes);
            bufferedOutputStream.flush();
        }
        catch (IOException exception) {
            throw new SerializationException(exception);
        }
    }

    @Override
    public String getMIMEType(byte[] bytes) {
        return MIME_TYPE;
    }
}

