/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayAdapter;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.HashMap;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;

public class ResultList
implements List<Map<String, Object>> {
    private ResultSet resultSet;
    private ArrayList<Field> fields = new ArrayList();
    private boolean includeNullValues = false;
    private List.ListListenerList<Map<String, Object>> listListeners = new List.ListListenerList();

    public ResultList(ResultSet resultSet) {
        if (resultSet == null) {
            throw new IllegalArgumentException();
        }
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public Sequence<Field> getFields() {
        return this.fields;
    }

    public void setFields(Sequence<Field> fields) {
        if (fields == null) {
            throw new IllegalArgumentException();
        }
        this.fields = new ArrayList<Field>(fields);
    }

    public void setFields(Field ... fields) {
        if (fields == null) {
            throw new IllegalArgumentException();
        }
        this.setFields(new ArrayAdapter<Field>(fields));
    }

    public boolean getIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    @Override
    public int add(Map<String, Object> item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insert(Map<String, Object> item, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> update(int index, Map<String, Object> item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(Map<String, Object> item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sequence<Map<String, Object>> remove(int index, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Object> get(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Map<String, Object> item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public Comparator<Map<String, Object>> getComparator() {
        return null;
    }

    @Override
    public void setComparator(Comparator<Map<String, Object>> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map<String, Object>> iterator() {
        return new ResultListItemIterator();
    }

    @Override
    public ListenerList<ListListener<Map<String, Object>>> getListListeners() {
        return this.listListeners;
    }

    private class ResultListItemIterator
    implements Iterator<Map<String, Object>> {
        private boolean hasNext = true;
        private boolean moveNext = true;

        private ResultListItemIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext && this.moveNext) {
                try {
                    this.hasNext = ResultList.this.resultSet.next();
                    this.moveNext = false;
                }
                catch (SQLException exception) {
                    throw new RuntimeException(exception);
                }
            }
            return this.hasNext;
        }

        @Override
        public Map<String, Object> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            HashMap<String, Object> item = new HashMap<String, Object>();
            try {
                for (Field field : ResultList.this.fields) {
                    Object value = field.type == Boolean.class || field.type == Boolean.TYPE ? Boolean.valueOf(ResultList.this.resultSet.getBoolean(field.columnName)) : (field.type == Byte.class || field.type == Byte.TYPE ? Byte.valueOf(ResultList.this.resultSet.getByte(field.columnName)) : (field.type == Short.class || field.type == Short.TYPE ? Short.valueOf(ResultList.this.resultSet.getShort(field.columnName)) : (field.type == Integer.class || field.type == Integer.TYPE ? Integer.valueOf(ResultList.this.resultSet.getInt(field.columnName)) : (field.type == Long.class || field.type == Long.TYPE ? Long.valueOf(ResultList.this.resultSet.getLong(field.columnName)) : (field.type == Float.class || field.type == Float.TYPE ? Float.valueOf(ResultList.this.resultSet.getFloat(field.columnName)) : (field.type == Double.class || field.type == Double.TYPE ? Double.valueOf(ResultList.this.resultSet.getDouble(field.columnName)) : (field.type == String.class ? ResultList.this.resultSet.getString(field.columnName) : (field.type == Date.class ? ResultList.this.resultSet.getDate(field.columnName) : ResultList.this.resultSet.getObject(field.columnName)))))))));
                    if (ResultList.this.resultSet.wasNull()) {
                        value = null;
                    }
                    if (value == null && !ResultList.this.includeNullValues) continue;
                    item.put(field.key == null ? field.columnName : field.key, value);
                }
            }
            catch (SQLException exception) {
                throw new RuntimeException(exception);
            }
            this.moveNext = true;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Field {
        public final String columnName;
        public final String key;
        public final Class<?> type;

        public Field(String columnName) {
            this(columnName, null, null);
        }

        public Field(String columnName, String key) {
            this(columnName, key, null);
        }

        public Field(String columnName, String key, Class<?> type) {
            if (columnName == null) {
                throw new IllegalArgumentException();
            }
            if (type != null && type != Boolean.class && type != Boolean.TYPE && type != Byte.class && type != Byte.TYPE && type != Short.class && type != Short.TYPE && type != Integer.class && type != Integer.TYPE && type != Long.class && type != Long.TYPE && type != Float.class && type != Float.TYPE && type != Double.class && type != Double.TYPE && type != Date.class && type != String.class) {
                throw new IllegalArgumentException(type.getName() + " is not a supported type.");
            }
            this.columnName = columnName;
            this.key = key;
            this.type = type;
        }
    }
}

