/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ListenerList<T>
implements Iterable<T> {
    private static final int DEFAULT_SIZE = 5;
    private T[] list = new Object[5];
    private int last = 0;

    public void add(T listener) {
        if (this.indexOf(listener) >= 0) {
            System.err.println("Duplicate listener " + listener + " added to " + this);
            return;
        }
        if (this.last >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.list.length + 5);
        }
        this.list[this.last++] = listener;
    }

    public void remove(T listener) {
        int index = this.indexOf(listener);
        if (index < 0) {
            System.err.println("Nonexistent listener " + listener + " removed from " + this);
            return;
        }
        if (index < this.last - 1) {
            System.arraycopy(this.list, index + 1, this.list, index, this.last - 1 - index);
        }
        this.list[--this.last] = null;
    }

    private int indexOf(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        for (int i = 0; i < this.last; ++i) {
            if (this.list[i] != listener) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(T listener) {
        return this.indexOf(listener) >= 0;
    }

    public boolean isEmpty() {
        return this.last == 0;
    }

    public int getLength() {
        return this.last;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        int i = 0;
        for (T item : this) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(item);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private class NodeIterator
    implements Iterator<T> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ListenerList.this.last;
        }

        @Override
        public T next() {
            if (this.index >= ListenerList.this.last) {
                throw new NoSuchElementException();
            }
            return ListenerList.this.list[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

