/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.util;

import org.apache.pivot.collections.HashMap;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.MessageBusListener;

public class MessageBus {
    private static HashMap<Class<?>, ListenerList<MessageBusListener<?>>> messageTopics = new HashMap();

    public static <T> void subscribe(Class<? super T> topic, MessageBusListener<T> messageListener) {
        ListenerList topicListeners = messageTopics.get(topic);
        if (topicListeners == null) {
            topicListeners = new ListenerList<MessageBusListener<?>>(){};
            messageTopics.put(topic, topicListeners);
        }
        topicListeners.add(messageListener);
    }

    public static <T> void unsubscribe(Class<? super T> topic, MessageBusListener<T> messageListener) {
        ListenerList<MessageBusListener<?>> topicListeners = messageTopics.get(topic);
        if (topicListeners == null) {
            throw new IllegalArgumentException(topic.getName() + " does not exist.");
        }
        topicListeners.remove(messageListener);
        if (topicListeners.isEmpty()) {
            messageTopics.remove(topic);
        }
    }

    public static <T> void sendMessage(T message) {
        Class<?> topic = message.getClass();
        ListenerList<MessageBusListener<?>> topicListeners = messageTopics.get(topic);
        if (topicListeners != null) {
            for (MessageBusListener<?> listener : topicListeners) {
                listener.messageSent(message);
            }
        }
    }
}

