/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.Map;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.Application;
import org.apache.pivot.wtk.BrowserApplicationContext;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Meter;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.Window;
import ui.XMLDownload;

public class SplashScreenTest
extends Application.Adapter {
    private Window window = null;
    private XMLDownload download = null;
    private static final Logger logger = Logger.getLogger(SplashScreenTest.class);

    public void startup(final Display display, Map<String, String> properties) throws Exception {
        Container.setEventDispatchThreadChecker(null);
        Task<Void> prepareApplicationTask = new Task<Void>(){
            final SplashScreenProgressOverlay progressOverlay = new SplashScreenProgressOverlay();

            public Void execute() throws TaskExecutionException {
                this.progressOverlay.increment(0.0);
                this.loadBXML(display, 0.1);
                return null;
            }

            private void loadBXML(final Display displayArgument, final double weight) {
                try {
                    BrowserApplicationContext.queueCallback((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SplashScreenTest.this.download = (XMLDownload)((Object)new BXMLSerializer().readObject(XMLDownload.class, "XMLDownload.bxml"));
                            }
                            catch (IOException | SerializationException e) {
                                throw new RuntimeException(e);
                            }
                            if (SplashScreenTest.this.download != null) {
                                SplashScreenTest.this.download.open(displayArgument);
                                progressOverlay.increment(weight);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        TaskListener<Void> taskListener = new TaskListener<Void>(){

            public void taskExecuted(Task<Void> task) {
                this.finished();
            }

            public void executeFailed(Task<Void> task) {
                System.err.println(String.format("Failed\n%s", task.getFault()));
                task.getFault().printStackTrace();
                this.finished();
            }

            private void finished() {
            }
        };
        prepareApplicationTask.execute((TaskListener)new TaskAdapter((TaskListener)taskListener));
    }

    public boolean shutdown(boolean optional) {
        if (this.download != null) {
            this.download.close();
        }
        return false;
    }

    public void suspend() {
    }

    public void resume() {
    }

    private static class SplashScreenProgressOverlay {
        private final SplashScreen splashScreen;
        private final Meter meter = new Meter(Orientation.HORIZONTAL);
        private Graphics2D graphics;

        private SplashScreenProgressOverlay() {
            this.splashScreen = SplashScreen.getSplashScreen();
            if (this.splashScreen != null) {
                this.configureMeter(256, 16);
                this.configureGraphics();
            } else {
                logger.error((Object)"Splash Screen not found");
            }
        }

        private void increment(double increment) {
            if (this.splashScreen == null) {
                return;
            }
            double percentage = this.meter.getPercentage() + increment;
            this.meter.setPercentage(Math.min(percentage, 1.0));
            if (this.splashScreen != null) {
                this.meter.paint(this.graphics);
                this.splashScreen.update();
            }
            logger.info((Object)String.format("Completed : %3.0f%%", this.getPercentage() * 100.0));
        }

        private double getPercentage() {
            return this.meter.getPercentage();
        }

        private void configureMeter(int width, int height) {
            this.meter.setSize(width, height);
            this.meter.setPercentage(0.0);
            this.meter.getStyles().put("gridFrequency", (Object)1);
        }

        private void configureGraphics() {
            Rectangle splash = this.splashScreen.getBounds();
            int x = (splash.width - this.meter.getBounds().width) / 2;
            int y = splash.height - this.meter.getBounds().height - 10;
            this.graphics = this.splashScreen.createGraphics();
            this.graphics.translate(x, y);
        }
    }
}

