/*
 * Decompiled with CFR 0.152.
 */
package certutil;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public final class CertFromWeb {
    private static final Logger logger = Logger.getLogger(CertFromWeb.class);

    public static X509Certificate getX509Certificate(String certSerialNo) throws MalformedURLException, IOException, CertificateException {
        int n;
        if (certSerialNo == null) {
            throw new IllegalArgumentException("\u6191\u8b49\u5e8f\u865f\u4e0d\u5b58\u5728");
        }
        String certUrl = "http://xca.nat.gov.tw/PEXE_XCA/DownLoadCert.CEXE?CertNo=";
        logger.debug((Object)("Cert Downlaod Url : " + certUrl.concat(certSerialNo)));
        BigInteger big = new BigInteger(certSerialNo, 16);
        byte[] b = big.toByteArray();
        String sn = CertFromWeb.getHex(b);
        if (sn.startsWith("00")) {
            sn = sn.substring(2);
        }
        logger.debug((Object)("\u539f\u59cb\u5e8f\u865f:[" + certSerialNo + "]-\u66f4\u65b0\u5e8f\u865f[" + sn + "]\n"));
        URL website = new URL(certUrl.concat(sn));
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        InputStream is = website.openStream();
        while ((n = is.read(buffer)) > 0) {
            bais.write(buffer, 0, n);
        }
        bais.flush();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(bais.toByteArray()));
        logger.debug((Object)("Cert DN : " + cert.getSubjectDN().getName()));
        logger.debug((Object)("Cert : " + bais.toByteArray()));
        return cert;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        String HEXES = "0123456789ABCDEF";
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append("0123456789ABCDEF".charAt((b & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(b & 0xF));
        }
        return hex.toString();
    }
}

