/*
 * Decompiled with CFR 0.152.
 */
package certutil;

import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Module;
import tw.com.chttl.Token;

public class CryptFromXCA
implements PrivilegedAction<String> {
    private String password;
    private String plaintext;
    private static final Logger logger = Logger.getLogger(CryptFromXCA.class);

    public CryptFromXCA(String password, String plaintext) {
        this.password = password;
        this.plaintext = plaintext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run() {
        X509Certificate xca2 = null;
        Token tok = null;
        byte[] wrap = null;
        try {
            block7: {
                Module.initialize();
                Module module = Module.getInstance();
                int[] tokIDs = module.getTokens();
                if (tokIDs.length == 0) break block7;
                tok = module.getToken(tokIDs[0]);
                if (!tok.isTokenPresent()) break;
                xca2 = tok.getCert(Token.ID_ENCRYPT);
                if (tok.login(this.password)) {
                    wrap = CryptoUtil.wrap(xca2, this.plaintext.getBytes());
                    logger.debug((Object)("Bsae64 : " + Base64.encodeBase64String(wrap)));
                    logger.debug((Object)("\u89e3\u5bc6\u5f8c\u5b57\u4e32:" + new String(tok.unwrap(Token.ID_ENCRYPT, wrap))));
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
        finally {
            if (tok != null) {
                tok.logout();
            }
            return Base64.encodeBase64String(wrap);
        }
    }
}

