/*
 * Decompiled with CFR 0.152.
 */
package certutil;

import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Module;
import tw.com.chttl.Token;
import tw.com.chttl.TokenException;

public class SignFromXCA
implements PrivilegedAction<String> {
    private String password;
    private String plaintext;
    private static final Logger logger = Logger.getLogger(SignFromXCA.class);

    public SignFromXCA(String password, String plaintext) {
        this.password = password;
        this.plaintext = plaintext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run() {
        X509Certificate xca2 = null;
        Token tok = null;
        byte[] sig = null;
        try {
            block7: {
                Module.initialize();
                Module module = Module.getInstance();
                int[] tokIDs = module.getTokens();
                if (tokIDs.length == 0) break block7;
                tok = module.getToken(tokIDs[0]);
                if (!tok.isTokenPresent()) break;
                xca2 = tok.getCert(Token.ID_SIGN);
                if (tok.login(this.password)) {
                    sig = tok.signMD5(Token.ID_SIGN, this.plaintext.getBytes());
                    logger.debug((Object)("\u9a57\u8b49\u7c3d\u7ae0 : " + CryptoUtil.verifyMD5(xca2, this.plaintext.getBytes(), sig)));
                }
                break;
            }
        }
        catch (CertificateException | TokenException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (tok != null) {
                tok.logout();
            }
            return Base64.encodeBase64String(sig);
        }
    }
}

