/*
 * Decompiled with CFR 0.152.
 */
package certutil;

import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import tw.com.chttl.CryptoUtil;
import tw.com.chttl.Module;
import tw.com.chttl.Token;
import tw.com.chttl.TokenException;

public class VerifyFromXCA
implements PrivilegedAction<String> {
    private final String password;
    private final String base64plaintext;
    private final String base64signedtext;
    private static final Logger logger = Logger.getLogger(VerifyFromXCA.class);

    public VerifyFromXCA(String password, String base64plaintext, String base64signedtext) {
        this.password = password;
        this.base64plaintext = base64plaintext;
        this.base64signedtext = base64signedtext;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u50b3\u5165\u7684PIN :\n" + password));
            logger.debug((Object)("\u50b3\u5165\u7684XML :\n" + base64plaintext));
            logger.debug((Object)("\u50b3\u5165\u7684\u7c3d\u7ae0XML :\n" + base64signedtext));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String run() {
        X509Certificate xca2 = null;
        Token tok = null;
        boolean isVerified = false;
        boolean isPINCorrect = true;
        try {
            Module.initialize();
            Module module = Module.getInstance();
            int[] tokIDs = module.getTokens();
            if (tokIDs.length != 0) {
                tok = module.getToken(tokIDs[0]);
                if (tok.isTokenPresent()) {
                    xca2 = tok.getCert(Token.ID_SIGN);
                    if (tok.login(this.password)) {
                        isVerified = CryptoUtil.verifyMD5(xca2, this.base64plaintext.getBytes(), Base64.decodeBase64(this.base64signedtext));
                        logger.debug((Object)("\u9a57\u8b49XML\u7c3d\u7ae0 : " + isVerified));
                    }
                    isPINCorrect = false;
                    return isPINCorrect;
                }
            }
        }
        catch (CertificateException | TokenException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (tok != null) {
                tok.logout();
            }
            if (isPINCorrect) {
                if (isVerified) {
                    return "Verified";
                }
                return "Not Verified";
            }
            return "PIN CODE ERROR";
        }
    }
}

